package com.sakura.momo.comon.config;

import android.text.TextUtils;

import com.sakura.momo.comon.game.BaraSdk;
import com.sakura.momo.comon.login.FacebookManager;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.comon.constants.Constants;
import com.sakura.momo.comon.object.SdkConfigObj;
import com.sakura.momo.comon.object.UserObj;
import com.sakura.momo.comon.sharePref.PrefManager;
import com.bara.SakuraSDK;

public class GameConfigs {

    private static GameConfigs gameConfigs;
    private String appKey;
    private String adsKey;
    private SdkConfigObj sdkConfig;
    private boolean show_qc;
    //    private String FCM_APP_API_KEY = "e83661bc7c7f639e5f0334471c8188deb8d5542a";
    private String FCM_APP_API_KEY = "d5f66e393eaab40f72e6b7d3ca5f32f275db5bd5";


    UserObj user;

    public static GameConfigs getInstance() {
        if (gameConfigs == null)
            gameConfigs = new GameConfigs();
        return gameConfigs;
    }

    private GameConfigs() {
    }

    public static void clearInstance() {
        getInstance().setUser(null);
        getInstance().setSdkConfig(null);
    }


    public String getAppKey() {
        if (appKey == null) {
            return PrefManager.getAppKey(BaraSdk.getInstance().getApplication());
        }
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
        PrefManager.saveAppKey(BaraSdk.getInstance().getApplication(), appKey);
    }

    public String getAdsKey() {
        if (adsKey == null) {
            return PrefManager.getAdsKey(BaraSdk.getInstance().getApplication());
        }
        return adsKey;
    }

    public void setAdsKey(String adsKey) {
        this.adsKey = appKey;
        PrefManager.saveAdsKey(BaraSdk.getInstance().getApplication(), adsKey);
    }

    public UserObj getUser() {
        if (user == null) {
            return PrefManager.getUser(BaraSdk.getInstance().getApplication());
        }
        return user;
    }

    public void setUser(UserObj user) {
        this.user = user;
        PrefManager.saveUser(BaraSdk.getInstance().getApplication(), user);
    }


    public SdkConfigObj getSdkConfig() {
        return sdkConfig;
    }

    public void setSdkConfig(SdkConfigObj sdkConfig) {
        if (sdkConfig == null) {
            this.sdkConfig = null;
            return;
        }
        this.sdkConfig = sdkConfig;
        if (sdkConfig.getEx() != null && sdkConfig.getEx().isShowLogo()) {
            SakuraSDK.getInstance().requestOverlayPermission(SakuraSDK.activity);
        }
        GameConfigs.getInstance().setShow_qc(true);
        PrefManager.saveBoolean(BaraSdk.getInstance().getApplication(),
                com.bara.utils.Constants.SHARED_PREF_DB_ENABLED,
                true);
        PrefManager.saveSetting(BaraSdk.getInstance().getApplication(), Constants.SESSION_OUT_TIME, sdkConfig.getSessionOutTime());
    }


    public boolean isLogin() {
        return !TextUtils.isEmpty(PrefManager.getAccessToken(BaraSdk.getInstance().getApplication()));
    }

    public void initFacebook(String facebookAppId) {
        FacebookManager.getInstance(BaraSdk.getInstance().getApplication()).init(facebookAppId);

    }

    public boolean getShow_qc() {
        return show_qc;
    }

    public void setShow_qc(boolean show_qc) {
        this.show_qc = show_qc;
    }

    public SdkConfigObj.Pop getPopup() {
        if (sdkConfig == null || sdkConfig.getPop() == null) {
            return new SdkConfigObj.Pop();
        }
        return sdkConfig.getPop();
    }

    public String getLang() {
        return DeviceUtils.getLanguage();
    }

    public SdkConfigObj.GoogleIAB getGgIABConfig() {
        return sdkConfig == null ? null : new SdkConfigObj.GoogleIAB();
    }


    public String getFcmApiKey() {
        return FCM_APP_API_KEY;
    }
}
