package com.sakura.momo.comon.api.request;

import com.sakura.momo.comon.constants.ConstantApi;
import com.sakura.momo.comon.object.request.InitalizePuchaseRequestObj;
import com.sakura.momo.comon.object.request.VerifyPurchaseRequestObj;
import com.sakura.momo.comon.object.response.InitialPurchaseResponseObj;
import com.sakura.momo.comon.object.response.ItemPayResponseObj;
import com.sakura.momo.comon.object.response.RetryPaymentResponseObj;
import com.sakura.momo.comon.object.response.VerifyPurchaseResponseObj;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface PaymentRequest {

    @Headers({"Content-Type: application/json","Accept:application/json"})
    @POST(ConstantApi.URL_VERIFY_PURCHASE)
    Call<VerifyPurchaseResponseObj> verifyPurchase(@Path("order_no") String order_no,
                                                   @Body VerifyPurchaseRequestObj body);



    @Headers({"Content-Type: application/x-www-form-urlencoded", "Accept:application/json"})
    @GET(ConstantApi.URL_GET_LIST_ITEM)
    Call<ItemPayResponseObj> getListItem(
            @Query("method") String method,
            @Query("x_request") String x_request,
            @Query("app_version") String app_version,
            @Query("sdk_version") String sdk_version
    );

    @Headers({"Content-Type: application/json", "Accept:application/json"})
    @POST(ConstantApi.URL_INITIAL_PURCHASE)
    Call<InitialPurchaseResponseObj> initialPurchase(@Body InitalizePuchaseRequestObj body);

}
