/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.notification;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Vibrator;
import android.text.TextUtils;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.appsflyer.AppsFlyerLib;
import com.bumptech.glide.Glide;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.R;
import com.kajime.libtsy.api.RegisterTokenAndTask;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.gui.KajimeWebviewActivity;
import com.kajime.libtsy.utils.NotificationUtils;
import com.kajime.libtsy.utils.Preference;
import com.kajime.libtsy.utils.Res;
import java.util.Map;

public class KajimeFirebaseMessagingService
extends FirebaseMessagingService {
    private static final String TAG = KajimeFirebaseMessagingService.class.getSimpleName();
    private static KajimeFirebaseMessagingService INSTANCE;

    protected int getDrawableSmall(Context c) {
        return Res.drawableResource(c, R.drawable.transparent);
    }

    public static KajimeFirebaseMessagingService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KajimeFirebaseMessagingService();
        }
        return INSTANCE;
    }

    @SuppressLint(value={"MissingPermission"})
    public void onMessageReceived(RemoteMessage remoteMessage) {
        try {
            Context context = this.getApplicationContext();
            Log.i((String)TAG, (String)("onMessage: " + remoteMessage));
            if (remoteMessage.getData().size() <= 0) {
                return;
            }
            Map map = remoteMessage.getData();
            String title = (String)map.get("title");
            String message = (String)map.get("body");
            String id2 = (String)map.get("id");
            String url = (String)map.get("url");
            String timer = (String)map.get("timer");
            String link = (String)map.get("link");
            if (link != null) {
                Preference.save(context, "deeplink", link);
            } else if (url != null) {
                Preference.save(context, "deeplink", url);
                Preference.save(context, KajimeWebviewActivity.KEY_ENABLE_TITLE, false);
            }
            Log.i((String)TAG, (String)("id: " + id2));
            Log.i((String)TAG, (String)("title: " + title));
            Log.i((String)TAG, (String)("message: " + message));
            Log.i((String)TAG, (String)("url: " + url));
            Log.i((String)TAG, (String)("timer: " + timer));
            if (url != null) {
                Glide.with((Context)context.getApplicationContext()).load(url).downloadOnly(512, 256);
            }
            Intent intent = new Intent("com.kajime.libtsy.broadcast");
            intent.putExtra("category", "gcm");
            intent.putExtra("id", id2);
            intent.putExtra("title", title);
            intent.putExtra("mesage", message);
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            GameConfigManager.getInstance().setHasUnreadNotifications(true);
            try {
                if (!TextUtils.isEmpty((CharSequence)id2)) {
                    NotificationUtils.addNtf(context, Integer.parseInt(id2));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!TextUtils.isEmpty((CharSequence)title) || !TextUtils.isEmpty((CharSequence)message)) {
                if (url != null) {
                    NotificationUtils.getInstance(context).setMainClass(null).setMessage(message).setTitle(title).setImageUrl(url).setLink(link).setId(id2).setSmallIcon(this.getDrawableSmall(context)).showNotificationWithImage();
                } else {
                    NotificationUtils.getInstance(context).setMainClass(null).setMessage(message).setTitle(title).setLink(link).setId(id2).setSmallIcon(this.getDrawableSmall(context)).showNotification();
                }
                Vibrator v = (Vibrator)context.getSystemService("vibrator");
                if (v != null) {
                    v.vibrate(30L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendRegistrationToServer(String userId, String refreshedToken) {
        try {
            Log.d((String)TAG, (String)("sendToken/RegId to server: " + refreshedToken));
            AppsFlyerLib.getInstance().updateServerUninstallToken(KajimeSDK.getApplicationContext(), refreshedToken);
            Preference.save(KajimeSDK.getApplicationContext(), "save_fcm_key", refreshedToken);
            if (!TextUtils.isEmpty((CharSequence)refreshedToken)) {
                Log.i((String)TAG, (String)"sendToken/RegId to server:");
                new RegisterTokenAndTask(userId, refreshedToken).execute(new Void[0]);
                Log.d((String)TAG, (String)("userId: " + userId));
            }
            AppsFlyerLib.getInstance().updateServerUninstallToken(KajimeSDK.getApplicationContext(), refreshedToken);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

