/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.js;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.api.ProcessIABReceiptTask;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.Game;
import com.kajime.libtsy.utils.iab.IabHelper;
import com.kajime.libtsy.utils.iab.IabResult;
import com.kajime.libtsy.utils.iab.Inventory;
import com.kajime.libtsy.utils.iab.Purchase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.ResponseBody;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public final class CmdPayment {
    private static String TAG = CmdPayment.class.getSimpleName();
    private static CmdPayment INSTANCE;
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_IAB = 1;
    private static final int TYPE_PAYPAL = 2;
    private String state = "";
    private IabHelper mIabHelper;
    private ArrayList<String> listPendingPurchases = new ArrayList();
    private Activity activity;
    private IabHelper.OnIabSetupFinishedListener mOnIabSetupFinishedListener = new IabHelper.OnIabSetupFinishedListener(){

        @Override
        public void onIabSetupFinished(IabResult result) {
            try {
                Log.i((String)TAG, (String)"onIabSetupFinished");
                if (!result.isSuccess()) {
                    Log.i((String)TAG, (String)("Problem setting up In-app Billing: " + result));
                    Intent intent = new Intent("com.kajime.libtsy.broadcast");
                    intent.putExtra("category", "payment");
                    intent.putExtra("status", false);
                    intent.putExtra("message", "Problem setting up In-app Billing: " + result);
                    LocalBroadcastManager.getInstance((Context)CmdPayment.this.activity).sendBroadcast(intent);
                    return;
                }
                if (CmdPayment.this.mIabHelper != null) {
                    CmdPayment.this.mIabHelper.queryInventoryAsync(CmdPayment.this.mQueryInventoryFinishedListener);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private IabHelper.QueryInventoryFinishedListener mQueryInventoryFinishedListener = new IabHelper.QueryInventoryFinishedListener(){

        @Override
        public void onQueryInventoryFinished(IabResult result, Inventory inv) {
            try {
                Log.i((String)TAG, (String)"onQueryInventoryFinished");
                if (!result.isSuccess()) {
                    Log.i((String)TAG, (String)("Problem setting up In-App-Billing" + result));
                    Intent intent = new Intent("com.kajime.libtsy.broadcast");
                    intent.putExtra("category", "payment");
                    intent.putExtra("status", false);
                    intent.putExtra("message", "Problem setting up In-app Billing: " + result);
                    LocalBroadcastManager.getInstance((Context)CmdPayment.this.activity).sendBroadcast(intent);
                    return;
                }
                if (inv.getAllPurchases().size() > 0) {
                    CmdPayment.this.mIabHelper.consumeAsync(inv.getAllPurchases(), CmdPayment.this.mOnIabConsumeMultiFinishedListener);
                } else if (CmdPayment.this.listPendingPurchases.size() > 0) {
                    String sku = (String)CmdPayment.this.listPendingPurchases.get(CmdPayment.this.listPendingPurchases.size() - 1);
                    CmdPayment.this.listPendingPurchases.clear();
                    CmdPayment.this.mIabHelper.launchPurchaseFlowWithRetry(sku, 10001, CmdPayment.this.mOnIabPurchaseFinishedListener);
                } else {
                    KajimeSDK.getInstance().close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private IabHelper.OnConsumeFinishedListener mOnIabConsumeFinishedListener = new IabHelper.OnConsumeFinishedListener(){

        @Override
        public void onConsumeFinished(Purchase purchase, IabResult result) {
            CmdPayment.this.handleConsume(purchase, result);
        }
    };
    private IabHelper.OnConsumeMultiFinishedListener mOnIabConsumeMultiFinishedListener = new IabHelper.OnConsumeMultiFinishedListener(){

        @Override
        public void onConsumeMultiFinished(List<Purchase> purchases, List<IabResult> results) {
            try {
                for (int i = 0; i < purchases.size(); ++i) {
                    CmdPayment.this.handleConsume(purchases.get(i), results.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private IabHelper.OnIabPurchaseFinishedListener mOnIabPurchaseFinishedListener = new IabHelper.OnIabPurchaseFinishedListener(){

        @Override
        public void onIabPurchaseFinished(IabResult result, Purchase purchase) {
            try {
                Log.i((String)TAG, (String)"onIabPurchaseFinished");
                if (result.isFailure()) {
                    if (result.getResponse() != -1005) {
                        Log.i((String)TAG, (String)("Error purchasing: " + result));
                        Intent intent = new Intent("com.kajime.libtsy.broadcast");
                        intent.putExtra("category", "payment");
                        intent.putExtra("status", false);
                        intent.putExtra("message", "Error IAB purchasing: " + result);
                        LocalBroadcastManager.getInstance((Context)CmdPayment.this.activity).sendBroadcast(intent);
                    }
                    return;
                }
                CmdPayment.this.mIabHelper.consumeAsync(purchase, CmdPayment.this.mOnIabConsumeFinishedListener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private CmdPayment() {
    }

    public static CmdPayment getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdPayment();
        }
        return INSTANCE;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public void handleResult(Activity activity, int requestCode, int resultCode, Intent data) {
        this.activity = activity;
        switch (requestCode) {
            case 10001: {
                this.mIabHelper.handleActivityResult(requestCode, resultCode, data);
            }
        }
    }

    public void StartCenterManager(Activity activity, String params) {
        Log.i((String)TAG, (String)("paymentStartIAP:" + params));
        this.activity = activity;
        this.initIAB(activity);
        try {
            JSONObject obj = new JSONObject(params);
            String product_id = obj.getString("product_id");
            this.listPendingPurchases.add(product_id);
            if (this.mIabHelper != null && this.mIabHelper.isSetupDone()) {
                this.mIabHelper.queryInventoryAsync(this.mQueryInventoryFinishedListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void khoidongNao(Activity activity, String params) {
        Log.i((String)TAG, (String)("paymentStartIAP:" + params));
        this.activity = activity;
        this.initIAB(activity);
        try {
            JSONObject obj = new JSONObject(params);
            String product_id = obj.getString("product_id");
            this.listPendingPurchases.add(product_id);
            if (this.mIabHelper != null && this.mIabHelper.isSetupDone()) {
                this.mIabHelper.queryInventoryAsync(this.mQueryInventoryFinishedListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initIAB(Activity activity) {
        Log.i((String)TAG, (String)"initIAB");
        try {
            if (this.mIabHelper == null || !this.mIabHelper.getActivity().equals(activity)) {
                Game.GoogleIABConfig config = GameConfigManager.getInstance().getGameConfig().getGoogleIAB();
                if (!TextUtils.isEmpty((CharSequence)config.getHashkey())) {
                    this.mIabHelper = new IabHelper(activity, config.getHashkey());
                    this.mIabHelper.startSetup(this.mOnIabSetupFinishedListener);
                } else {
                    Log.i((String)TAG, (String)"No hashkey found, skip setup IAB");
                }
            }
            Log.i((String)TAG, (String)"init done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleConsume(Purchase purchase, IabResult result) {
        Log.i((String)TAG, (String)"onConsumeFinished");
        try {
            if (result.isFailure()) {
                if (result.getResponse() != -1005) {
                    Log.i((String)TAG, (String)("Error purchasing: " + result));
                    Intent intent = new Intent("com.kajime.libtsy.broadcast");
                    intent.putExtra("category", "payment");
                    intent.putExtra("status", false);
                    intent.putExtra("message", "Error IAB purchasing: " + result);
                    LocalBroadcastManager.getInstance((Context)this.activity).sendBroadcast(intent);
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.i((String)TAG, (String)"purchase successful .");
        try {
            new ProcessIABReceiptTask(this.state, purchase.getItemType(), purchase.getSignature(), purchase.getOriginalJson(), new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    try {
                        String responseBody = ((ResponseBody)response.body()).string();
                        CmdPayment.this.cucsuc(CmdPayment.this.activity, responseBody, 1);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                public void onFailure(Call<ResponseBody> call, Throwable e) {
                }
            }).execute(new Void[0]);
            this.mIabHelper.queryInventoryAsync(this.mQueryInventoryFinishedListener);
        }
        catch (Exception e) {
            Intent intent = new Intent("com.kajime.libtsy.broadcast");
            intent.putExtra("category", "payment");
            intent.putExtra("status", false);
            intent.putExtra("message", e.getMessage());
            LocalBroadcastManager.getInstance((Context)this.activity).sendBroadcast(intent);
        }
    }

    void cucsuc(Activity activity, String params) {
        this.cucsuc(activity, params, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cucsuc(Activity activity, String params, int type) {
        Log.i((String)TAG, (String)"cucsuc");
        try {
            JSONObject order = new JSONObject(params);
            if (order != null && order.getString("status").equals("0")) {
                String userId = order.getString("user_id");
                String orderId = order.getString("order_id");
                String orderProduct = order.getString("order_product");
                String orderInfo = order.getString("details");
                String orderTime = order.getString("time");
                String platformPrice = order.getString("platform_price");
                String gamePrice = order.getString("game_price");
                String state = "";
                String game_role_id = "";
                String game_area_id = "";
                String is_sandbox = "";
                if (order.has("state")) {
                    state = order.getString("state");
                }
                if (order.has("game_role_id")) {
                    game_role_id = order.getString("game_role_id");
                }
                if (order.has("game_area_id")) {
                    game_area_id = order.getString("game_area_id");
                }
                if (order.has("is_sandbox")) {
                    is_sandbox = order.getString("is_sandbox");
                }
                Intent intent = new Intent("com.kajime.libtsy.broadcast");
                intent.putExtra("category", "payment");
                intent.putExtra("status", true);
                intent.putExtra("user_id", userId);
                intent.putExtra("order_id", orderId);
                intent.putExtra("order_product", orderProduct);
                intent.putExtra("order_info", orderInfo);
                intent.putExtra("order_time", orderTime);
                intent.putExtra("platform_price", platformPrice);
                intent.putExtra("game_price", gamePrice);
                intent.putExtra("state", state);
                intent.putExtra("game_role_id", game_role_id);
                intent.putExtra("game_area_id", game_area_id);
                intent.putExtra("is_sandbox", is_sandbox);
                LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
                Intent closeIntent = new Intent("intent_close_form_payment");
                closeIntent.putExtra("extra_close_form_payment", true);
                LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(closeIntent);
            } else {
                Log.i((String)TAG, (String)"on pay failed");
                Intent intent = new Intent("com.kajime.libtsy.broadcast");
                intent.putExtra("category", "payment");
                intent.putExtra("status", false);
                intent.putExtra("message", "Error purchasing");
                LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
            }
        }
        catch (Exception e) {
            Intent intent = new Intent("com.kajime.libtsy.broadcast");
            intent.putExtra("category", "payment");
            intent.putExtra("status", false);
            intent.putExtra("message", e.getMessage());
            LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
        }
        finally {
            switch (type) {
                case 0: 
                case 2: {
                    KajimeSDK.getInstance().close();
                    break;
                }
            }
        }
    }
}

