/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.component;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.R;
import java.io.IOException;

public final class GoogleAuthManager {
    private static final String TAG = GoogleAuthManager.class.getSimpleName();
    private static GoogleAuthManager INSTANCE;
    private static final int REQUEST_GOOGLE_PLAY_SERVICES = 412;
    private GoogleApiClient mGoogleApiClient;
    private boolean mResolvingError = false;
    private GooglePlusResultCallback googlePlusResultCallback;
    private Activity activity;
    private String SCOPE = "oauth2:https://www.googleapis.com/auth/userinfo.profile";
    private GoogleApiClient.ConnectionCallbacks mConnectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

        public void onConnected(Bundle bundle) {
        }

        public void onConnectionSuspended(int arg0) {
        }
    };
    private GoogleApiClient.OnConnectionFailedListener mOnConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

        public void onConnectionFailed(ConnectionResult result) {
            try {
                Log.i((String)TAG, (String)("onConnectionFailed:" + result));
                if (GoogleAuthManager.this.mResolvingError) {
                    return;
                }
                if (result.hasResolution()) {
                    try {
                        GoogleAuthManager.this.mResolvingError = true;
                        result.startResolutionForResult(KajimeSDK.activity, 123);
                    }
                    catch (IntentSender.SendIntentException e) {
                        GoogleAuthManager.this.mGoogleApiClient.connect();
                    }
                } else {
                    GoogleAuthManager.this.mResolvingError = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public static GoogleAuthManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GoogleAuthManager();
        }
        return INSTANCE;
    }

    private GoogleAuthManager() {
    }

    void init(Activity activity) {
        try {
            this.activity = activity;
            GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().build();
            this.mGoogleApiClient = new GoogleApiClient.Builder((Context)activity).addConnectionCallbacks(this.mConnectionCallbacks).addOnConnectionFailedListener(this.mOnConnectionFailedListener).addApi(Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions.HasOptions)gso).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        try {
            if (requestCode == 412) {
                this.initGoogleClient(this.activity);
            }
            if (requestCode == 123) {
                this.mResolvingError = false;
                if (resultCode == 0 && !this.mGoogleApiClient.isConnecting() && !this.mGoogleApiClient.isConnected()) {
                    this.mGoogleApiClient.connect();
                }
            }
            if (requestCode == 0) {
                GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
                if (result.isSuccess()) {
                    GoogleSignInAccount acct = result.getSignInAccount();
                    String str = acct.getIdToken();
                    Log.d((String)"TAG ", (String)("GGOOOOOOO : " + str));
                    if (this.googlePlusResultCallback != null) {
                        Log.d((String)"TAG ", (String)"GGOOOOOOO");
                        new GetToken(this.activity, this.SCOPE, acct.getEmail(), acct, this.googlePlusResultCallback).execute(new Void[0]);
                    }
                } else {
                    Log.wtf((String)"TAG", (String)("onActivityResult: " + result.getStatus().isSuccess() + " " + result.getStatus().getStatusMessage() + " " + result.getStatus().getStatusCode()));
                    if (this.googlePlusResultCallback != null) {
                        this.googlePlusResultCallback.onLoginError(result.getStatus().getStatusMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void login(Activity activity, GooglePlusResultCallback googlePlusResultCallback) {
        try {
            this.googlePlusResultCallback = googlePlusResultCallback;
            Intent signInIntent = Auth.GoogleSignInApi.getSignInIntent(this.mGoogleApiClient);
            activity.startActivityForResult(signInIntent, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logout() {
        try {
            if (this.mGoogleApiClient != null && this.mGoogleApiClient.isConnected()) {
                this.mGoogleApiClient.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getToken(Activity activity, String email, String scope) throws IOException, GoogleAuthException {
        return GoogleAuthUtil.getToken((Context)activity, (String)email, (String)scope);
    }

    private void initGoogleClient(Activity activity) {
        try {
            if (this.mGoogleApiClient == null || this.mGoogleApiClient.isConnected()) {
                GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().requestIdToken(activity.getString(R.string.server_client_id)).requestScopes(new Scope("https://www.googleapis.com/auth/plus.me"), new Scope[0]).requestScopes(new Scope("https://www.googleapis.com/auth/plus.login"), new Scope[0]).build();
                this.mGoogleApiClient = new GoogleApiClient.Builder((Context)this.activity).addConnectionCallbacks(this.mConnectionCallbacks).addOnConnectionFailedListener(this.mOnConnectionFailedListener).addApi(Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions.HasOptions)gso).addScope(new Scope("profile")).addScope(new Scope("email")).build();
            } else {
                this.mGoogleApiClient.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isGoogleServiceAvailable(Activity activity) {
        try {
            GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
            int result = googleAPI.isGooglePlayServicesAvailable((Context)activity);
            if (result != 0) {
                if (googleAPI.isUserResolvableError(result)) {
                    googleAPI.getErrorDialog(activity, result, 412).show();
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    class GetToken
    extends AsyncTask<Void, Void, String> {
        Activity mActivity;
        String mScope;
        String mEmail;
        GooglePlusResultCallback mCallback;
        GoogleSignInAccount mGogleSignin;

        public GetToken(Activity activity, String scope, String email, GoogleSignInAccount googleSignInAccount, GooglePlusResultCallback callback) {
            this.mActivity = activity;
            this.mScope = scope;
            this.mEmail = email;
            this.mCallback = callback;
            this.mGogleSignin = googleSignInAccount;
        }

        protected String doInBackground(Void ... params) {
            try {
                return GoogleAuthManager.this.getToken(GoogleAuthManager.this.activity, this.mEmail, this.mScope);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (GoogleAuthException e) {
                e.printStackTrace();
            }
            return "";
        }

        protected void onPostExecute(String aVoid) {
            super.onPostExecute((Object)aVoid);
            try {
                if (!TextUtils.isEmpty((CharSequence)aVoid)) {
                    this.mCallback.onLoginSuccess(this.mGogleSignin, aVoid);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface GooglePlusResultCallback {
        public void onLoginSuccess(GoogleSignInAccount var1, String var2);

        public void onLoginError(String var1);
    }
}

