/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.api;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.api.RestfulApi;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.CharacterInfo;
import com.kajime.libtsy.utils.KajimeAppsflyerUtils;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class SaveCharacterTask
extends AsyncTask<Void, Void, Void> {
    private String roleId;
    private String areaId;
    private String roleName;
    private String areaName;

    public SaveCharacterTask(String areaId, String areaName, String roleId, String roleName) {
        this.roleId = roleId;
        this.areaId = areaId;
        this.roleName = roleName;
        this.areaName = areaName;
    }

    protected Void doInBackground(Void ... params) {
        try {
            final Context context = KajimeSDK.getApplicationContext();
            CharacterInfo charInfo = new CharacterInfo();
            charInfo.setAreaId(this.areaId);
            charInfo.setAreaName(this.areaName);
            charInfo.setRoleId(this.roleId);
            charInfo.setRoleName(this.roleName);
            GameConfigManager.getInstance().setCharacterInfo(charInfo);
            if (!TextUtils.isEmpty((CharSequence)this.areaId) && !TextUtils.isEmpty((CharSequence)this.roleId)) {
                KajimeAppsflyerUtils.getInstance().trackCreateCharacterRequest(context, "call");
                RestfulApi api = RestfulApi.getInstance();
                Call<ResponseBody> call = api.saveCharacter(this.roleId, this.areaId, this.roleName, this.areaName);
                call.enqueue((Callback)new Callback<ResponseBody>(){

                    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                        if (response.isSuccessful()) {
                            KajimeAppsflyerUtils.getInstance().trackCreateCharacterRequest(context, "success");
                        }
                    }

                    public void onFailure(Call<ResponseBody> call, Throwable t) {
                        KajimeAppsflyerUtils.getInstance().trackCreateCharacterRequest(context, "fail");
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

