/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.api;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.api.RestfulApi;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.EncodedResponse;
import com.kajime.libtsy.model.UserInfo;
import com.kajime.libtsy.utils.EncryptionUtils;
import com.kajime.libtsy.utils.NotificationUtils;
import com.kajime.libtsy.utils.Preference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GetInfoAfterAuthenTask
extends AsyncTask<Void, Void, Void> {
    private Listener callback;

    public GetInfoAfterAuthenTask(Listener callback) {
        this.callback = callback;
    }

    protected Void doInBackground(Void ... params) {
        Context c = KajimeSDK.getApplicationContext();
        String sign = EncryptionUtils.getSignedString(c);
        RestfulApi api = RestfulApi.getInstance();
        Call<EncodedResponse> call = api.getInfoAfterAuthen(sign);
        call.enqueue((Callback)new Callback<EncodedResponse>(){

            public void onResponse(Call<EncodedResponse> call, Response<EncodedResponse> response) {
                block20: {
                    try {
                        Context c = KajimeSDK.getApplicationContext();
                        UserInfo userInfo = null;
                        if (response.code() == 200 && response.body() != null) {
                            block19: {
                                String responseBody = ((EncodedResponse)response.body()).getDecodedData();
                                try {
                                    JSONObject json = new JSONObject(responseBody);
                                    if (!json.has("saveLogin")) break block19;
                                    String saveLogin = json.getString("saveLogin");
                                    if (json.has("userInfo")) {
                                        String userInfoStr = json.getString("userInfo");
                                        userInfo = UserInfo.parse(userInfoStr);
                                    }
                                    if (json.has("ntf")) {
                                        String ntf = json.getString("ntf");
                                        JSONArray ntfs = new JSONArray(ntf);
                                        for (int i = 0; i < ntfs.length(); ++i) {
                                            JSONObject ntfObj = ntfs.getJSONObject(i);
                                            if (!ntfObj.has("id") || !ntfObj.has("noti") || !ntfObj.getBoolean("noti")) continue;
                                            NotificationUtils.addNtf(c, ntfObj.getInt("id"));
                                            GameConfigManager.getInstance().setHasUnreadNotifications(true);
                                        }
                                    } else {
                                        GameConfigManager.getInstance().setHasUnreadNotifications(false);
                                    }
                                    if (json.has("show_pu")) {
                                        Boolean isShowPopup = json.getBoolean("show_pu");
                                        GameConfigManager.getInstance().setShowPopup(isShowPopup);
                                    }
                                    if (json.has("show_qc")) {
                                        Boolean isShowAd = false;
                                        try {
                                            isShowAd = json.getBoolean("show_qc");
                                        }
                                        catch (Exception e) {
                                            Log.d((String)"AfterAuthen", (String)"onResponse: show_qc not boolean");
                                            isShowAd = json.getInt("show_qc") == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
                                        }
                                        GameConfigManager.getInstance().setShowAd(isShowAd);
                                    }
                                    if (json.has("enable_dashboard")) {
                                        boolean value = json.getBoolean("enable_dashboard");
                                        Preference.save(c, "shared_pref_db_enabled", value);
                                    } else {
                                        Preference.remove(c, "shared_pref_db_enabled");
                                    }
                                    if (json.has("new_link")) {
                                        GameConfigManager.getInstance().setNewsEventUrl(json.getString("new_link"));
                                    }
                                }
                                catch (JSONException e) {
                                    if (GetInfoAfterAuthenTask.this.callback == null) break block19;
                                    GetInfoAfterAuthenTask.this.callback.onFailure(e);
                                }
                            }
                            if (GetInfoAfterAuthenTask.this.callback != null) {
                                GetInfoAfterAuthenTask.this.callback.onSuccess(userInfo);
                            }
                            break block20;
                        }
                        if (GetInfoAfterAuthenTask.this.callback != null) {
                            Log.d((String)"TAG", (String)("ERROR when " + response.code()));
                            GetInfoAfterAuthenTask.this.callback.onFailure(new Exception());
                        }
                    }
                    catch (Exception e) {
                        if (GetInfoAfterAuthenTask.this.callback != null) {
                            GetInfoAfterAuthenTask.this.callback.onFailure(e);
                        }
                        e.printStackTrace();
                    }
                }
            }

            public void onFailure(Call<EncodedResponse> call, Throwable t) {
                if (GetInfoAfterAuthenTask.this.callback != null) {
                    GetInfoAfterAuthenTask.this.callback.onFailure(t);
                }
            }
        });
        return null;
    }

    public static interface Listener {
        public void onSuccess(UserInfo var1);

        public void onFailure(Throwable var1);
    }
}

