package com.kajime.libtsy.utils;

import android.Manifest;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.FragmentManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Build.VERSION;
import android.os.Build.VERSION_CODES;
import android.provider.Settings;

import androidx.core.content.ContextCompat;

import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.gui.KajimeDrawOverAppsFragment;
import com.kajime.libtsy.gui.PermissionFragment;

public class PermissionUtils {

    public static boolean hasPermission(String permission) {
        if (Build.VERSION.SDK_INT >= 23) {
            Context c = KajimeSDK.getApplicationContext();
            boolean granted = false;
            if (permission.equals(Manifest.permission.SYSTEM_ALERT_WINDOW)) {
                granted = isSystemAlertPermissionGranted(c);
            } else {
                granted = ContextCompat.checkSelfPermission(c, permission)
                        == PackageManager.PERMISSION_GRANTED;
            }
            return granted;
        }
        return true;
    }

    public static void requestPermission(Activity a, String permission) {

        if (permission == Manifest.permission.SYSTEM_ALERT_WINDOW) {

            FragmentManager fm = a.getFragmentManager();
            KajimeDrawOverAppsFragment fr = KajimeDrawOverAppsFragment.newInstance();
            fm.beginTransaction()
                    .add(fr, "tag_fragment_permission")
                    .commit();
        } else {

            FragmentManager fm = a.getFragmentManager();
            PermissionFragment fr = PermissionFragment.newInstance(new String[]{permission});
            fm.beginTransaction()
                    .add(fr, "tag_fragment_permission")
                    .commit();
        }
    }

    public static void requestPermissions(Activity a, String[] permissions) {

        FragmentManager fm = a.getFragmentManager();
        PermissionFragment fr = PermissionFragment.newInstance(permissions);
        fm.beginTransaction()
                .add(fr, "tag_fragment_permission")
                .commit();
    }

    @TargetApi(VERSION_CODES.M)
    private static boolean isSystemAlertPermissionGranted(Context c) {
        return VERSION.SDK_INT < VERSION_CODES.M || Settings.canDrawOverlays(c);
    }

}
