package com.kajime.libtsy.utils;

/**
 * Created by Khai Tran on 5/26/2017.
 */

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;

import androidx.core.app.NotificationCompat;
import androidx.core.app.TaskStackBuilder;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.kajime.libtsy.R;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.ArrayList;

import static android.app.Notification.BADGE_ICON_SMALL;

public class NotificationUtils {

    private static int iconSmall = R.drawable.transparent;

    public void showNotificationGif() {

    }

    public void updateNotificationGif() {

    }

    @SuppressLint("WrongConstant")
    public void showNotification() {

        Log.i(TAG, "showNotification:title=" + title + ";msg=" + message);
        try {
            Log.i(TAG, "mainClass:" + mainClass);
            if (mainClass == null) {
                try {
                    String className = Preference.getString(context,
                            Constants.SHARED_PREF_MAIN_ACTIVITY);
                    mainClass = Class.forName(className);
                } catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            Drawable ico = context.getApplicationInfo().loadIcon(context.getPackageManager());
            Bitmap bitmap = Utils.drawableToBitmap(ico);
            int bitmapSize = (int) Math.min(64 * DeviceUtils.getDensity(context), bitmap.getWidth());

            CharSequence appTitle = context.getApplicationInfo().loadLabel(context.getPackageManager());

            NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
            bigTextStyle.setBigContentTitle(title);
            bigTextStyle.bigText(message);
            bigTextStyle.setSummaryText(appTitle);

            NotificationManager mNotificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
            NotificationCompat.Builder mBuilder;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                String name = "channel";
                String description = "channel des";
                int importance = NotificationManager.IMPORTANCE_HIGH;
                assert mNotificationManager != null;
                NotificationChannel mChannel = mNotificationManager.getNotificationChannel(id);
                if (mChannel == null) {
                    mChannel = new NotificationChannel(id, name, importance);
                    mChannel.setDescription(description);
                    mChannel.enableVibration(true);
                    mChannel.setVibrationPattern(new long[]{100, 200, 300, 400, 500, 400, 300, 200, 400});
                    mNotificationManager.createNotificationChannel(mChannel);
                }

            }
            mBuilder = new NotificationCompat.Builder(context, id)
                    .setWhen(System.currentTimeMillis())
                    .setContentText(message)
                    .setContentTitle(title)
                    .setSmallIcon(smallIcon)
                    .setLargeIcon(Bitmap.createScaledBitmap(bitmap, bitmapSize, bitmapSize, false))
                    .setAutoCancel(true)
                    .setTicker(title)
                    .setBadgeIconType(BADGE_ICON_SMALL)
                    .setNumber(countNtfs(context))
                    .setStyle(bigTextStyle)
                    .setDefaults(Notification.DEFAULT_LIGHTS | Notification.DEFAULT_VIBRATE | Notification.DEFAULT_SOUND);
            // Creates an explicit intent for an Activity in your app
            Intent resultIntent = new Intent(context, mainClass);
            resultIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP);
//			resultIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
            resultIntent.putExtra("title", title);
            resultIntent.putExtra("message", message);
            resultIntent.putExtra("id", id);
            resultIntent.putExtra("link", link);
            resultIntent.putExtra("url", imageUrl);

            // The stack builder object will contain an artificial back stack for
            // the started Activity.
            // This ensures that navigating backward from the Activity leads out of
            // your application to the Home screen.
            TaskStackBuilder stackBuilder = TaskStackBuilder.create(context);
            // Adds the back stack for the Intent (but not the Intent itself)
            stackBuilder.addParentStack(mainClass);
            // Adds the Intent that starts the Activity to the top of the stack
            stackBuilder.addNextIntent(resultIntent);
            PendingIntent resultPendingIntent = PendingIntent.getActivity(context.getApplicationContext(), 959,
                    resultIntent, PendingIntent.FLAG_UPDATE_CURRENT);
            mBuilder.setContentIntent(resultPendingIntent);
            // mId allows you to update the notification later on.
            assert mNotificationManager != null;
            mNotificationManager.notify(1, mBuilder.build());

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @SuppressLint("WrongConstant")
    public void showNotificationWithImage() {
        Log.i(TAG, "showNotification:title=" + title + ";msg=" + message);
        try {
            Log.i(TAG, "mainClass:" + mainClass);
            if (mainClass == null) {
                try {
                    String className = Preference.getString(context,
                            Constants.SHARED_PREF_MAIN_ACTIVITY);
                    mainClass = Class.forName(className);
                } catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            Drawable ico = context.getApplicationInfo().loadIcon(context.getPackageManager());
            Bitmap bitmap = Utils.drawableToBitmap(ico);
            int bitmapSize = (int) Math.min(64 * DeviceUtils.getDensity(context), bitmap.getWidth());

            //hiendv(24/03/2017): set Data for bigPictureStyle
            Bitmap bigPictureBitmap = Glide.with(context).asBitmap().load(imageUrl).apply(new RequestOptions().centerCrop()).into(512, 256)
                    .get();

            NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
//            bigPictureStyle.bigPicture(Bitmap.createScaledBitmap(bigPictureBitmap, 120, 120, false));
            bigPictureStyle.setSummaryText(message);
            bigPictureStyle.bigPicture(bigPictureBitmap);
            bigPictureStyle.setBigContentTitle(title);

            NotificationManager mNotificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
            NotificationCompat.Builder mBuilder;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                String name = "channel with image";
                String description = "channel img des"; // The user-visible description of the channel.
                int importance = NotificationManager.IMPORTANCE_HIGH;
                assert mNotificationManager != null;
                NotificationChannel mChannel = mNotificationManager.getNotificationChannel(id);
                if (mChannel == null) {
                    mChannel = new NotificationChannel(id, name, importance);
                    mChannel.setDescription(description);
                    mChannel.enableVibration(true);
                    mChannel.setVibrationPattern(new long[]{100, 200, 300, 400, 500, 400, 300, 200, 400});
                    mNotificationManager.createNotificationChannel(mChannel);
                }
            }
            mBuilder = new NotificationCompat.Builder(context, id)
                    .setWhen(System.currentTimeMillis())
                    .setContentText(message)
                    .setContentTitle(title)
                    .setSmallIcon(smallIcon)
                    .setLargeIcon(Bitmap.createScaledBitmap(bitmap, bitmapSize, bitmapSize, false))
                    .setAutoCancel(true)
                    .setTicker(title)
                    .setBadgeIconType(BADGE_ICON_SMALL)
                    .setNumber(NotificationUtils.countNtfs(context))
                    .setStyle(bigPictureStyle)
                    .setDefaults(Notification.DEFAULT_LIGHTS | Notification.DEFAULT_VIBRATE | Notification.DEFAULT_SOUND);

            // Creates an explicit intent for an Activity in your app
            Intent resultIntent = new Intent(context, mainClass);
            resultIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP);
//			resultIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
            resultIntent.putExtra("title", title);
            resultIntent.putExtra("message", message);
            resultIntent.putExtra("id", id);
            resultIntent.putExtra("link", link);
            resultIntent.putExtra("url", imageUrl);

            // The stack builder object will contain an artificial back stack for
            // the started Activity.
            // This ensures that navigating backward from the Activity leads out of
            // your application to the Home screen.
            TaskStackBuilder stackBuilder = TaskStackBuilder.create(context);
            // Adds the back stack for the Intent (but not the Intent itself)
            stackBuilder.addParentStack(mainClass);
            // Adds the Intent that starts the Activity to the top of the stack
            stackBuilder.addNextIntent(resultIntent);
            PendingIntent resultPendingIntent = PendingIntent.getActivity(context.getApplicationContext(), 959,
                    resultIntent, PendingIntent.FLAG_UPDATE_CURRENT);
            mBuilder.setContentIntent(resultPendingIntent);
            // mId allows you to update the notification later on.
            assert mNotificationManager != null;
            mNotificationManager.notify(1, mBuilder.build());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//    public static int getDrawableSmall(Context c) {
//        return iconSmall;
//    }

    public static void addNtf(Context c, int id) {
        try {
            String ntfsString = Preference.getString(c,
                    Constants.SHARED_PREF_NOTIFICATONS);
            JSONArray ntfs = new JSONArray();
            try {
                ntfs = new JSONArray(ntfsString);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            ntfs.put(id);
            Preference.save(c,
                    Constants.SHARED_PREF_NOTIFICATONS,
                    ntfs.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeNtf(Context c, int id) {
        Log.d(TAG, "removeNotificationId" + id);
        try {
            String ntfsString = Preference.getString(c,
                    Constants.SHARED_PREF_NOTIFICATONS);
            JSONArray ntfs = new JSONArray(ntfsString);
            JSONArray newNtfs = new JSONArray();
            for (int i = 0; i < ntfs.length(); i++) {
                if (id != ntfs.getInt(i)) {
                    newNtfs.put(ntfs.getInt(i));
                }
            }
            Log.d(TAG, "left removeNotificationId" + newNtfs);
            Preference.save(c,
                    Constants.SHARED_PREF_NOTIFICATONS,
                    newNtfs.toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }


    public static boolean hasNtf(Context c) {
        Log.d(TAG, "NTF : " + !getNtfs(c).isEmpty());
        return !getNtfs(c).isEmpty();
    }

    public static boolean hasNtf(Context c, int id) {
        return getNtfs(c).contains(id);
    }

    private static ArrayList<Integer> getNtfs(Context c) {
        try {
            String ntfsString = Preference.getString(c,
                    Constants.SHARED_PREF_NOTIFICATONS);
            JSONArray ntfs = new JSONArray(ntfsString);
            ArrayList<Integer> ntfIds = new ArrayList<>();
            for (int i = ntfs.length() - 1; i >= 0; i--) {
                ntfIds.add(ntfs.getInt(i));
            }
            return ntfIds;
        } catch (JSONException e) {
        }
        return new ArrayList<>();
    }

    public static void removeAllNtf(Context c) {
        try {
            Preference.save(c, Constants.SHARED_PREF_NOTIFICATONS, "[]");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int countNtfs(Context c) {
        try {
            return getNtfs(c).size();
        } catch (Exception e) {
            return 0;
        }
    }


    private static String TAG = "NotificationUtils";

    private Class mainClass;
    private Context context;
    private String title;
    private String message;
    private String imageUrl;
    private String id;
    private String link;
    private int smallIcon;

    @SuppressLint("StaticFieldLeak")
    private static NotificationUtils instance;


    private NotificationUtils(Context context) {
        this.context = context;
    }

    public static NotificationUtils getInstance(Context context) {
        if (instance == null) {
            instance = new NotificationUtils(context);
        }
        return instance;
    }

    public Class getMainClass() {
        return mainClass;
    }

    public NotificationUtils setMainClass(Class mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public NotificationUtils setImageUrl(String url) {
        this.imageUrl = url;
        return this;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public Context getContext() {
        return context;
    }

    public NotificationUtils setContext(Context context) {
        this.context = context;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public NotificationUtils setTitle(String title) {
        this.title = title;
        return this;
    }


    public String getMessage() {
        return message;
    }

    public NotificationUtils setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getId() {
        return id;
    }

    public NotificationUtils setId(String id) {
        if (id != null) {
            this.id = id;
        } else {
            this.id = "";
        }
        return this;
    }

    public String getLink() {
        return link;
    }

    public NotificationUtils setLink(String link) {
        this.link = link;
        return this;
    }

    public int getSmallIcon() {
        return smallIcon;
    }

    public NotificationUtils setSmallIcon(int smallIcon) {
        this.smallIcon = smallIcon;
        return this;
    }
}
