package com.kajime.libtsy.utils;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.util.Log;

import com.appsflyer.AFInAppEventType;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerLib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.component.EventClientManager;
import com.kajime.libtsy.component.FirebaseAnalyticsManager;
import com.kajime.libtsy.component.GameConfigManager;

/**
 * Created by Pc 02 on 1/29/2018.
 */

public class KajimeAppsflyerUtils {
    private static KajimeAppsflyerUtils instance;
    private String appsflyerDevkey = "cfgYFoj97okaEbzqp8q5w5";
    private String fcmSenderId = "577522348312";//SenderId Project SDK IP
    private String TAG = "LibAppsflyerUtils";
    private Map<String, Object> conversionDataLoaded;
    private ArrayList<String> listTrackEventQueue = new ArrayList<>();
    private boolean initted;
    long applauncherTime;

    /*Tracking Appsflyer key*/
    private static final String TRACK_APP_LAUNCH = "ft_app_launch";
    private static final String TRACK_FIRST_LAUNCH = "ft_first_launch";
    private static final String TRACK_APP_LAUNCH_XX = "ft_app_launch_";
    private static final String TRACK_DOWNLOAD_RES_STARTED = "ft_resource_started";
    private static final String TRACK_DOWNLOAD_RES_FAILED = "ft_resource_failed";
    private static final String TRACK_DOWNLOAD_RES_FINISHED = "ft_resource_finished";
    private static final String TRACK_CHARACTOR_CREATED = "ft_character_created";
    private static final String TRACK_START_TUTORIAL = "af_tutorial_started";
    private static final String TRACK_FINISH_TUTORIAL = "af_tutorial_completion";
    private static final String TRACK_REACH_A_LEVEL = "af_level_achieved";
    private static final String TRACK_LEVEL_PLATFORM = "ft_level_platform";
    private static final String TRACK_LEVEL_ACHIEVED_A = "ft_level_achieved_A";
    private static final String TRACK_LEVEL_ACHIEVED_B = "ft_level_achieved_B";
    private static final String TRACK_LEVEL_ACHIEVED_C = "ft_level_achieved_C";
    private static final String TRACK_REGISTER_SUCCESS = "ft_register_success";
    private static final String TRACK_LOGIN_SUCCESS = "ft_login_success";
    public static final String TRACK_LOGIN_SUCCESS_AFTER_AUTH = "ft_login_success_after_auth";

    public static final String TRACK_PAYMENT_OPEN = "ft_payment_opened";
    public static final String TRACK_PAYMENT_CLICK = "ft_payment_clicked";
    public static final String TRACK_PAYMENT_CLOSE = "ft_payment_closed";
    private static final String TRACK_FT_PAYMENT_SUCCESS = "ft_purchase";


    private static final String TRACK_FORM_LOGIN_OPENED = "ft_login_screen_opened";
    public static final String TRACK_LOGIN_CLICKED = "ft_login_clicked";
    public static final String TRACK_LOGIN_CLOSED = "ft_login_closed";
    public static final String TRACK_EVENT_LOGOUT = "ft_logout";

    private static final String TRACK_FT_SESSION = "ft_session";
    private static final String TRACK_FT_LOADTIME = "ft_loadtime";
    private static final String SESSION_VALUE = "session_value";
    private static final String TRACK_SHOW_START_GAME_SCREEN = "ft_show_startgame";
    private static final String FT_CHARACTER_CREATED_CALL = "ft_character_created_call";
    private static final String FT_CHARACTER_CREATED_CALL_SUCCESS = "ft_character_created_call_success";
    private static final String FT_CHARACTER_CREATED_CALL_FAIL = "ft_character_created_call_fail";
    private static final String TRACK_OVERLAY_CLICK_PERMISSION = "ft_overlay_click_permission";
    public static final String TRACK_LOGIN_FORM_CLICKED_BUTTON = "ft_login_form_clicked_button";//TODO BÁO CORE BỔ SUNG SỬA LẠI TÊN CHO OPTION LOGIN EMAIL
    public static final String TRACK_LOGOUT_SUCCESS = "ft_logout_success";
    public static final String FT_LOGIN_SCREEN_LOAD_SUCCESS = "ft_login_screen_load_success";
    public static final String FT_LOGIN_SCREEN_LOAD_FAIL = "ft_login_screen_load_fail";
    private static final String TRACK_EXTRACT_STARTED = "ft_extract_started";
    private static final String TRACK_EXTRACT_FINISHED = "ft_extract_finished";
    private static final String TRACK_DOWNLOAD_RES_FIRST_BYTE = "ft_resource_first_byte";
    private static final String TRACK_DOWNLOAD_RES_PERCENT = "ft_resource_percent";
    private static final String FT_VIP_ACHIEVED = "ft_vip_achieved";


    private KajimeAppsflyerUtils() {

    }

    public synchronized static KajimeAppsflyerUtils getInstance() {
        if (instance == null) {
            instance = new KajimeAppsflyerUtils();
        }
        return instance;
    }


    public void init(Application context) {
        try {
            Log.i(TAG, "initAppsFlyer");
            KajimeSDK.applicationContext = context;
            AppsFlyerLib.getInstance().setCollectIMEI(false);
            AppsFlyerLib.getInstance().setCollectAndroidID(false);
            AppsFlyerLib.getInstance().setDebugLog(true);
            AppsFlyerConversionListener conversionDataListener =
                    new AppsFlyerConversionListener() {
                        @Override
                        public void onConversionDataSuccess(Map<String, Object> conversionData) {
                            try {
                                applauncherTime = System.currentTimeMillis();
                                String applauncherTimeString = String.valueOf(applauncherTime);
                                Map<String, Object> map = new HashMap<String, Object>(conversionData);
                                conversionDataLoaded = map;
                                if (!initted) {
                                    initted = true;
                                    map.put("time_app_launcher", applauncherTimeString);
                                    int countLauncher = Preference.getInt(context, Constants.COUNT_LAUNCHER, 0);
                                    if (countLauncher < 30) {
                                        countLauncher++;
                                        Preference.save(context, Constants.COUNT_LAUNCHER, countLauncher);
                                    }
                                }
                                for (String attrName : conversionData.keySet()) {
                                    Log.d(TAG, "onInstallConversionDataLoaded attribute: " + attrName + " = " + conversionData.get(attrName));
                                    if (attrName.equals("is_first_launch") && conversionData.get(attrName).equals("true")) {
                                        map.put("time_first_launcher", applauncherTimeString);
                                    }
                                }
                                if (listTrackEventQueue != null) {
                                    map.put("Resend", "when inited");
                                    for (String eventName : listTrackEventQueue) {
                                        trackEvent(context, eventName, map);
                                    }
                                    listTrackEventQueue.clear();
                                }

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onConversionDataFail(String errorMessage) {
                            Log.d(TAG, " onInstallConversionFailure error getting conversion data: " + errorMessage);
                        }

                        @Override
                        public void onAppOpenAttribution(Map<String, String> conversionData) {
                            for (String attrName : conversionData.keySet()) {
                                Log.d(TAG, "onAppOpenAttribution attribute: " + attrName + " = " + conversionData.get(attrName));
                            }
                        }

                        @Override
                        public void onAttributionFailure(String errorMessage) {
                            Log.d(TAG, " onAttributionFailure error onAttributionFailure : " + errorMessage);
                        }
                    };
            AppsFlyerLib.getInstance().init(appsflyerDevkey, conversionDataListener, context);
            AppsFlyerLib.getInstance().startTracking(context);

            trackAppLaunch(context);
            trackFirstLaunch(context);
            new Thread(new Runnable() {
                @Override
                public void run() {
                    if (KajimeSDK.getInstance().isLoggedIn()) {
                        EventClientManager.getInstance(context).saveEventClient(EventClientManager.SAVE_EVENT_START_SESSION, TRACK_APP_LAUNCH, null);
                    } else {
                        EventClientManager.getInstance(context).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, TRACK_APP_LAUNCH, null);
                    }
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        try {
            if (initted) {
                HashMap<String, Object> map = new HashMap<>(conversionDataLoaded);
                if (eventValues != null)
                    map.putAll(eventValues);
                AppsFlyerLib.getInstance().trackEvent(context, eventName, map);
                Log.d(TAG, "trackEvent: " + eventName + " eventValue: " + map);

            } else {
                Log.d(TAG, "trackEvent " + eventName + " fail cause of AppsflyerLib is not inited successful");
                listTrackEventQueue.add(eventName);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trackLoyalUser(Context context, String eventName) {
        try {
            Log.d(TAG, "event name : " + eventName);
            AppsFlyerLib.getInstance().trackEvent(context, eventName, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, eventName, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackOpenFormLogin(Activity activity) {
        try {
            trackEvent(activity, TRACK_FORM_LOGIN_OPENED, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_FORM_LOGIN_OPENED, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginSuccess(Activity activity) {
        try {
            trackEvent(activity, TRACK_LOGIN_SUCCESS_AFTER_AUTH, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_LOGIN_SUCCESS_AFTER_AUTH, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void trackRegisterSuccess(Activity activity, String typeRegister) {
        try {
            HashMap<String, Object> hashMap = new HashMap<>();
            hashMap.put("VALUE", typeRegister);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_REGISTER_SUCCESS, hashMap);
            trackEvent(activity, TRACK_REGISTER_SUCCESS, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginSuccessFromWeb(Activity activity, String typeLogin) {
        try {
            HashMap<String, Object> hashMap = new HashMap<>();
            hashMap.put("VALUE", typeLogin);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_LOGIN_SUCCESS, hashMap);
            trackEvent(activity, TRACK_LOGIN_SUCCESS, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginClick(Activity activity, String label, HashMap<String, Object> typeLoginClick) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, label, typeLoginClick);
            trackEvent(activity, label, typeLoginClick);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPayment_RegisterClick(Activity activity, String label, String value) {
        try {
            trackEvent(activity, label, null);
            HashMap<String, Object> map = new HashMap<>();
            map.put("VALUE", value);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, label, map);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPaymentSuccess(Activity activity, HashMap<String, Object> eventValue) {
        try {
            trackEvent(activity, AFInAppEventType.PURCHASE, eventValue);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_FT_PAYMENT_SUCCESS, eventValue);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackSession(Activity activity, long deltaSession) {
        try {
            HashMap<String, Object> hashMap = new HashMap<>();
            hashMap.put(SESSION_VALUE, String.valueOf(deltaSession));
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_FT_SESSION, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoadTime(Activity activity, long deltaTime) {
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("TIME_VALUE", String.valueOf(deltaTime));
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_FT_LOADTIME, map);
            Preference.remove(activity, Constants.START_SESSION);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackingLogout(Activity activity) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_EVENT_LOGOUT, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceStarted(Activity activity) {
        try {
            //bắt đầu download resource. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
            String gameVersionName = Utils.getGameVersion(activity);
            String gameVersionCode = Utils.getGameVersionCode(activity);
            String versionsave = Preference.getString(activity, "GAME_VERSION");
            if (!versionsave.equals(gameVersionCode)) {
                HashMap<String, Object> map = new HashMap<>();
                map.put("version name", gameVersionName);
                map.put("version code", gameVersionCode);
                trackEvent(activity, TRACK_DOWNLOAD_RES_STARTED, map);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_DOWNLOAD_RES_STARTED, map);
            } else Log.d(TAG, "trackDownloadResourceStarted dont call because it is same version");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceFinished(Activity activity) {
        //kết thúc download resource. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
        String gameVersionName = Utils.getGameVersion(activity);
        String gameVersionCode = Utils.getGameVersionCode(activity);
        String versionsave = Preference.getString(activity, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            trackEvent(activity, TRACK_DOWNLOAD_RES_FINISHED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_DOWNLOAD_RES_FINISHED, map);

        } else Log.d(TAG, "trackDownloadResourceFinished dont call because it is same version");
        Preference.save(activity, "GAME_VERSION", gameVersionCode);
    }

    public void trackDownloadResourceFailed(Context context) {
        //download resource thất bại. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
        String gameVersionName = Utils.getGameVersion(context);
        String gameVersionCode = Utils.getGameVersionCode(context);
        String versionsave = Preference.getString(context, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            trackEvent(context, TRACK_DOWNLOAD_RES_FAILED, map);
        } else Log.d(TAG, "trackDownloadResourceFailed dont call because it is same version");
    }

    public void trackStartTutorial(Activity activity) {
        trackEvent(activity, TRACK_START_TUTORIAL, null);
    }

    public void trackFinishTutorial(Activity activity) {
        trackEvent(activity, TRACK_FINISH_TUTORIAL, null);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_FINISH_TUTORIAL, null);
    }

    public void trackCreateCharactor(Activity activity, String roleID, String areaID) {
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            trackEvent(activity, TRACK_CHARACTOR_CREATED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_CHARACTOR_CREATED, map);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackReachALevel(Activity activity, String roleID, String areaID, String level) {
        Log.d(TAG, "trackReachALevel: ");
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("level", level);
            trackEvent(activity, TRACK_REACH_A_LEVEL, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_REACH_A_LEVEL, map);
        } catch (Exception e) {
            e.printStackTrace();
        }

        //tracking platform
        String levelTracking = null;
        try {
            if (GameConfigManager.getInstance() != null
                    && GameConfigManager.getInstance().getGameConfig() != null
                    && GameConfigManager.getInstance().getGameConfig().getLevel() != null)
                levelTracking = GameConfigManager.getInstance().getGameConfig().getLevel();
            Log.i(TAG, "trackLevelPlatform: " + levelTracking);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (levelTracking != null) {
            String[] arrLevelTrackingPlf = levelTracking.split(",");
            for (String levelTrack : arrLevelTrackingPlf) {
                try {
                    if (!Preference.getBoolean(activity, TRACK_LEVEL_PLATFORM + levelTrack, false)
                            && Integer.parseInt(level) >= Integer.parseInt(levelTrack)) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("LEVEL", levelTrack + "");
                        trackEvent(activity, TRACK_LEVEL_PLATFORM, map);
                        if (Integer.parseInt(level) >= Integer.parseInt(arrLevelTrackingPlf[2])) {
                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_LEVEL_ACHIEVED_C, map);
                        } else if (Integer.parseInt(level) >= Integer.parseInt(arrLevelTrackingPlf[1])) {
                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_LEVEL_ACHIEVED_B, map);
                        } else if (Integer.parseInt(level) >= Integer.parseInt(arrLevelTrackingPlf[0])) {
                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_LEVEL_ACHIEVED_A, map);
                        } else {
                            Log.i(TAG, "Do something");
                        }
                        map.clear();
                        Preference.save(activity, TRACK_LEVEL_PLATFORM + levelTrack, true);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }


    public void trackClickOverlayPermission(Context context) {
        Log.d(TAG, "event name : " + TRACK_OVERLAY_CLICK_PERMISSION);
        try {
            trackEvent(context, TRACK_OVERLAY_CLICK_PERMISSION, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_OVERLAY_CLICK_PERMISSION, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void trackAppLaunch(Context context) {
        try {
            applauncherTime = System.currentTimeMillis();
            String applauncherTimeString = String.valueOf(applauncherTime);
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("time_app_launcher", applauncherTimeString);

            trackEvent(context, TRACK_APP_LAUNCH, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_APP_LAUNCH, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trackFirstLaunch(Context context) {

        if (Preference.getBoolean(context, TRACK_FIRST_LAUNCH, true)) {

            applauncherTime = System.currentTimeMillis();
            String applauncherTimeString = String.valueOf(applauncherTime);
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("time_first_launcher", applauncherTimeString);

            trackEvent(context, TRACK_FIRST_LAUNCH, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_FIRST_LAUNCH, null);

            Preference.save(context, TRACK_FIRST_LAUNCH, false);
        }
    }


    public void trackOpenFormPayment(Activity activity) {
        try {
            trackEvent(activity, TRACK_PAYMENT_OPEN, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_PAYMENT_OPEN, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void trackLoginButtonClick(Activity activity, String name) {
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("TYPE_LOGIN", name);
            trackEvent(activity, TRACK_LOGIN_FORM_CLICKED_BUTTON, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_LOGIN_FORM_CLICKED_BUTTON, map);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public String getAppsflyerDevkey() {
        return appsflyerDevkey;
    }

    public void setAppsflyerDevkey(String appsflyerDevkey) {
        this.appsflyerDevkey = appsflyerDevkey;
    }

    public String getFcmSenderId() {
        return fcmSenderId;
    }

    public void setFcmSenderId(String fcmSenderId) {
        this.fcmSenderId = fcmSenderId;
    }

    public String getAppsflyerId(Context context) {
        return AppsFlyerLib.getInstance().getAppsFlyerUID(context);
    }

    public void startSession(Application application) {
        long startSession = System.currentTimeMillis();
        Preference.save(application, Constants.START_SESSION, startSession);
    }


    public void trackLogoutSuccess(Activity activity, String typeLogin) {
        try {
            HashMap<String, Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_logout_success", currentTime);
            hashMap.put("delta_logout_success", delta);
            trackEvent(activity, TRACK_LOGOUT_SUCCESS, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, TRACK_LOGOUT_SUCCESS, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void trackFinishLoadWebView(Activity activity, String labelUrl, long delta) {
        try {
            String deltaString = String.valueOf(delta);
            HashMap<String, Object> hashMap = new HashMap<>();
            hashMap.put("LabelUrl", labelUrl);
            hashMap.put("deltaTime", deltaString);
            Log.i(TAG, "trackLogoutSuccess 3 : " + delta + " : " + labelUrl + " : " + deltaString);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, FT_LOGIN_SCREEN_LOAD_SUCCESS, hashMap);
            trackEvent(activity, FT_LOGIN_SCREEN_LOAD_SUCCESS, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginscreenLoadSuccess(Activity activity, long delta) {
        try {
            HashMap<String, Object> hashMap = new HashMap<>();
            hashMap.put("deltaTime", delta);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, FT_LOGIN_SCREEN_LOAD_SUCCESS, hashMap);
            trackEvent(activity, FT_LOGIN_SCREEN_LOAD_SUCCESS, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginScreenFail(Activity activity) {
        try {
            Log.d(TAG, "event name : " + FT_LOGIN_SCREEN_LOAD_FAIL);
            HashMap<String, Object> hashMap = new HashMap<>();
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, FT_LOGIN_SCREEN_LOAD_FAIL, hashMap);
            KajimeAppsflyerUtils.getInstance().trackEvent(activity, FT_LOGIN_SCREEN_LOAD_FAIL, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackErrorLoadWebView(Activity activity, String labelUrl) {
        try {
            HashMap<String, Object> hashMap = new HashMap<>();
            hashMap.put("LabelUrl", labelUrl);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, FT_LOGIN_SCREEN_LOAD_FAIL, hashMap);
            trackEvent(activity, FT_LOGIN_SCREEN_LOAD_FAIL, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void trackLoginSuccess(Activity activity, String userId) {
        try {
            HashMap<String, Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_login_success", currentTime);
            hashMap.put("delta_login_success", delta);
            hashMap.put("user_id", userId);

            trackEvent(activity, AFInAppEventType.LOGIN, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, AFInAppEventType.LOGIN, hashMap);

            Log.d(TAG, "af_login");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void startExtractData(Context context) {
        try {
            Log.d(TAG, "event name : " + TRACK_EXTRACT_STARTED);
            HashMap<String, Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_extract_start", currentTime);
            hashMap.put("delta_extract_start", delta);
            trackEvent(context, TRACK_EXTRACT_STARTED, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_EXTRACT_STARTED, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishExtractData(Context context) {
        try {
            Log.d(TAG, "event name : " + TRACK_EXTRACT_FINISHED);
            HashMap<String, Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_extract_finish", currentTime);
            hashMap.put("delta_extract_finish", delta);
            trackEvent(context, TRACK_EXTRACT_FINISHED, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_EXTRACT_FINISHED, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void firstByteDownloadResource(Context context) {
        try {
            Log.d(TAG, "event name : " + TRACK_DOWNLOAD_RES_FIRST_BYTE);
            HashMap<String, Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_download_res_first_byte", currentTime);
            hashMap.put("delta_download_res_first_byte", delta);
            trackEvent(context, TRACK_DOWNLOAD_RES_FIRST_BYTE, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_DOWNLOAD_RES_FIRST_BYTE, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showStartGameScreen(Context context) {
        try {
            Log.d(TAG, "event name : " + TRACK_SHOW_START_GAME_SCREEN);
            HashMap<String, Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            String currentTimeString = String.valueOf(currentTime);
            String deltaString = String.valueOf(delta);
            hashMap.put("current_start_game_screen", currentTimeString);
            hashMap.put("delta_start_game_screen", deltaString);
            trackEvent(context, TRACK_SHOW_START_GAME_SCREEN, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_SHOW_START_GAME_SCREEN, hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void downloadResourceByPercent(Context context, String percent) {
        try {
            Log.d(TAG, "event name : " + TRACK_DOWNLOAD_RES_PERCENT + "_" + percent);
            HashMap<String, Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_download_res_first_byte", currentTime);
            hashMap.put("delta_download_res_first_byte", delta);
            hashMap.put("delta_download_res_percent", percent);
            trackEvent(context, (TRACK_DOWNLOAD_RES_PERCENT + "_" + percent).toString(), hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, (TRACK_DOWNLOAD_RES_PERCENT + "_" + percent).toString(), hashMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackCreateCharacterRequest(Context context, String type) {
        switch (type) {
            case "call":
                trackEvent(context, FT_CHARACTER_CREATED_CALL, null);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, FT_CHARACTER_CREATED_CALL, null);
                break;
            case "success":
                trackEvent(context, FT_CHARACTER_CREATED_CALL_SUCCESS, null);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, FT_CHARACTER_CREATED_CALL_SUCCESS, null);
                break;
            case "fail":
                trackEvent(context, FT_CHARACTER_CREATED_CALL_FAIL, null);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, FT_CHARACTER_CREATED_CALL_FAIL, null);
                break;
        }
    }

    public void trackVipLevel(Activity activity, String roleID, String areaID, String vipLevel) {
        Log.d(TAG, "trackVipLevel: ");
        Log.d(TAG, "event name : " + FT_VIP_ACHIEVED);
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("vip_level", vipLevel);
            trackEvent(activity, FT_VIP_ACHIEVED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, FT_VIP_ACHIEVED, map);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
