package com.kajime.libtsy.model;

import android.util.Log;

import com.google.gson.annotations.SerializedName;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * Created by Pc 02 on 12/26/2017.
 */

public class MItemPayment {
    @SerializedName("xt")
    private String categoryItem;
    @SerializedName("product_id")
    private String productId;
    @SerializedName("ig")
    private String urlPng;
    @SerializedName("config")
    private Config config;

    public static ArrayList<MItemPayment> parse(String json){
        ArrayList<MItemPayment> list = new ArrayList<>();
        if(json != null){
            try {
                JSONArray jsonArray = new JSONArray(json);
                for (int i = 0 ; i < jsonArray.length() ; i++){
                    MItemPayment item = new MItemPayment();
                    JSONObject jsonObj = jsonArray.getJSONObject(i);
                    if(jsonObj.has("xt")){
                        item.setCategoryItem(jsonObj.getString("xt").toString());
                    }
                    if(jsonObj.has("product_id")){
                        item.setProductId(jsonObj.getString("product_id").toString());
                    }
                    if(jsonObj.has("ig")){
                        item.setUrlPng(jsonObj.getString("ig").toString());
                    }

                    if(jsonObj.has("config")){
                        String strConfig = jsonObj.getString("config");
                        JSONObject jsonConfig = new JSONObject(strConfig);
                        String type , url;
                        Config config = new Config();
                        Log.d("TAG" , jsonConfig.toString());
                        if(jsonConfig.has("type")){
                            type = jsonConfig.getString("type");
                            config.setType(type);
                        }

                        if(jsonConfig.has("url")){
                            url = jsonConfig.getString("url");
                            config.setUrl(url);
                        }

                        item.setConfig(config);
                    }

                    list.add(item);
                }
                return list;
            } catch (JSONException e) {
                e.printStackTrace();
                return list;
            }
        }
        return list;
    }
    public String getCategoryItem() {
        return categoryItem;
    }

    public void setCategoryItem(String categoryItem) {
        this.categoryItem = categoryItem;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getUrlPng() {
        return urlPng;
    }

    public void setUrlPng(String urlPng) {
        this.urlPng = urlPng;
    }


    public Config getConfig() {
        return config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public static class Config{
        @SerializedName("type")
        private String type;
        @SerializedName("url")
        private String url;

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}