package com.kajime.libtsy.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;

public class Game {
	
	@SerializedName("app_gaid")
	private String googleAnalyticsId;
	
	@SerializedName("app_gaid_total")
	private String googleAnalyticsIdTotal;
	
	@SerializedName("app_gaid_local")
	private String googleAnalyticsIdLocal;
	
	@SerializedName("fb_appid")
	private String facebookId;
	
	@SerializedName("paypal")
	private PaypalConfig paypal;
	
	@SerializedName("google_iab")
	private GoogleIABConfig googleIAB;

	@SerializedName("adwords")
	private AdwordsConfig adwords;
	
	@SerializedName("ads")
	private AdsConfig adsConfig;
	
	@SerializedName("language_default")
	private String lang;

	@SerializedName("p_m")
	private Payment p_m;

	@SerializedName("i_s")
	private String isSubmit;

	@SerializedName("level")
 	private String level;

	@SerializedName("session_out_time")
	private long timeSession;

	@SerializedName("appsflyer")
 	private AppsFlyerConfig appsflyer;

	@SerializedName("ex")
	private ValidationConfig validationConfig;

	public ValidationConfig getValidationConfig() {
		return validationConfig;
	}

	public void setValidationConfig(ValidationConfig validationConfig) {
		this.validationConfig = validationConfig;
	}

	public static Game parse(String json) {
		Gson gson = new GsonBuilder().create();
		Game game = gson.fromJson(json.trim(), Game.class);
		return game;
	}

	public long getTimeSession() {
		return timeSession;
	}

	public AppsFlyerConfig getAppsflyer() {
		return appsflyer;
	}

	public void setAppsflyer(AppsFlyerConfig appsflyer) {
		this.appsflyer = appsflyer;
	}

	public void setTimeSession(long timeSession) {
		this.timeSession = timeSession;
	}

	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}

	public String getGoogleAnalyticsId() {
		return googleAnalyticsId;
	}

	public void setGoogleAnalyticsId(String googleAnalyticsId) {
		this.googleAnalyticsId = googleAnalyticsId;
	}

	public String getGoogleAnalyticsIdTotal() {
		return googleAnalyticsIdTotal;
	}

	public void setGoogleAnalyticsIdTotal(String googleAnalyticsIdTotal) {
		this.googleAnalyticsIdTotal = googleAnalyticsIdTotal;
	}

	public String getGoogleAnalyticsIdLocal() {
		return googleAnalyticsIdLocal;
	}

	public void setGoogleAnalyticsIdLocal(String googleAnalyticsIdLocal) {
		this.googleAnalyticsIdLocal = googleAnalyticsIdLocal;
	}

	public String getFacebookId() {
		return facebookId;
	}

	public void setFacebookId(String facebookId) {
		this.facebookId = facebookId;
	}

	public PaypalConfig getPaypal() {
		return paypal;
	}

	public void setPaypal(PaypalConfig paypal) {
		this.paypal = paypal;
	}

	public GoogleIABConfig getGoogleIAB() {
		return googleIAB;
	}

	public void setGoogleIAB(GoogleIABConfig googleIAB) {
		this.googleIAB = googleIAB;
	}

	public AdwordsConfig getAdwords() {
		return adwords;
	}

	public void setAdwords(AdwordsConfig adwords) {
		this.adwords = adwords;
	}

	public String getLang() {
		return lang;
	}

	public void setLang(String lang) {
		this.lang = lang;
	}
	
	public AdsConfig getAdsConfig() {
		return adsConfig;
	}

	public void setAdsConfig(AdsConfig adsApiKey) {
		this.adsConfig = adsApiKey;
	}

	public class GoogleIABConfig {
		
		@SerializedName("hashkey")
		private String hashkey;

		public String getHashkey() {
			return hashkey;
		}

		public void setHashkey(String hashkey) {
			this.hashkey = hashkey;
		}
		
	}
	
	public class AdwordsConfig {
		
		@SerializedName("conversion_id")
		private String conversionId;

		public String getConversionId() {
			return conversionId;
		}

		public void setConversionId(String conversionId) {
			this.conversionId = conversionId;
		}
		
	}
	
	public class AdsConfig {
		
		@SerializedName("api_key")
		private String apiKey;

		public String getApiKey() {
			return apiKey;
		}

		public void setApiKey(String apiKey) {
			this.apiKey = apiKey;
		}
		
	}
	
	public class PaypalConfig {
		
		@SerializedName("client_id_production")
		private String clientId;

		@SerializedName("privacy_url")
		private String privacyUrl;
		
		@SerializedName("user_agreement_url")
		private String userAgreementUrl;
		
		@SerializedName("accept_credit_cards")
		private boolean acceptCreditCard;
		
		@SerializedName("client_id_sandbox")
		private String clientIdSnadbox;
		
		@SerializedName("merchant_name")
		private String merchantName;

		public String getClientId() {
			return clientId;
		}

		public void setClientId(String clientId) {
			this.clientId = clientId;
		}

		public String getPrivacyUrl() {
			return privacyUrl;
		}

		public void setPrivacyUrl(String privacyUrl) {
			this.privacyUrl = privacyUrl;
		}

		public String getUserAgreementUrl() {
			return userAgreementUrl;
		}

		public void setUserAgreementUrl(String userAgreementUrl) {
			this.userAgreementUrl = userAgreementUrl;
		}

		public boolean isAcceptCreditCard() {
			return acceptCreditCard;
		}

		public void setAcceptCreditCard(boolean acceptCreditCard) {
			this.acceptCreditCard = acceptCreditCard;
		}

		public String getClientIdSnadbox() {
			return clientIdSnadbox;
		}

		public void setClientIdSnadbox(String clientIdSnadbox) {
			this.clientIdSnadbox = clientIdSnadbox;
		}

		public String getMerchantName() {
			return merchantName;
		}

		public void setMerchantName(String merchantName) {
			this.merchantName = merchantName;
		}
		
	}

	public Payment getP_m() {
		return p_m;
	}

	public void setP_m(Payment p_m) {
		this.p_m = p_m;
	}

	public String getIsSubmit() {
		return isSubmit;
	}

	public void setIsSubmit(String isSubmit) {
		this.isSubmit = isSubmit;
	}


	public class ConfigPayment{
		@SerializedName("scroll")
		private String scrollOrientation;
		@SerializedName("row")
		private String row;
		@SerializedName("col")
		private String col;

		public String getScrollOrientation() {
			return scrollOrientation;
		}

		public void setScrollOrientation(String scrollOrientation) {
			this.scrollOrientation = scrollOrientation;
		}

		public String getRow() {
			return row;
		}

		public void setRow(String row) {
			this.row = row;
		}

		public String getCol() {
			return col;
		}

		public void setCol(String col) {
			this.col = col;
		}
	}

	public class Payment{
		@SerializedName("p_d")
		private ConfigPayment p_d;

		@SerializedName("b_g")
		private String backgroundFormPay;


		public ConfigPayment getP_d() {
			return p_d;
		}

		public void setP_d(ConfigPayment p_d) {
			this.p_d = p_d;
		}

		public String getBackgroundFormPay() {
			return backgroundFormPay;
		}

		public void setBackgroundFormPay(String backgroundFormPay) {
			this.backgroundFormPay = backgroundFormPay;
		}
	}

	public class AppsFlyerConfig {

		@SerializedName("appsflyer_dev_key")
		private String devKey;

		@SerializedName("is_use_http")
		private boolean isUseHttp;

		@SerializedName("currency")
		private String currency;

		public String getDevKey() {
			return devKey;
		}

		public void setDevKey(String devKey) {
			this.devKey = devKey;
		}

		public boolean isUseHttp() {
			return isUseHttp;
		}

		public void setUseHttp(boolean isUseHttp) {
			this.isUseHttp = isUseHttp;
		}

		public String getCurrency() {
			return currency;
		}

		public void setCurrency(String currency) {
			this.currency = currency;
		}

	}

	public class ValidationConfig {
		@SerializedName("show_logo")
		private boolean isShouldShowLogo;

		@SerializedName("logo_url")
		private String logoUrl;

		@SerializedName("text")
		private String text;

		@SerializedName("never_hide_ex")
		private boolean neverHideEx;

		public boolean isShouldShowLogo() {
			return isShouldShowLogo;
		}

		public void setShouldShowLogo(boolean shouldShowLogo) {
			isShouldShowLogo = shouldShowLogo;
		}

		public String getLogoUrl() {
			return logoUrl;
		}

		public void setLogoUrl(String logoUrl) {
			this.logoUrl = logoUrl;
		}

		public String getText() {
			return text;
		}

		public void setText(String text) {
			this.text = text;
		}

		public boolean isNeverHideEx() {
			return neverHideEx;
		}

		public void setNeverHideEx(boolean neverHideEx) {
			this.neverHideEx = neverHideEx;
		}
	}


}
