package com.kajime.libtsy.js;

import android.app.Activity;
import android.util.Log;
import android.webkit.JavascriptInterface;

import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.gui.KajimeDialogRequestIpFragment;
import com.kajime.libtsy.gui.KajimeDialogSocialFragment;
import com.kajime.libtsy.gui.KajimeHaveBackButtonFragment;
import com.kajime.libtsy.gui.KajimeWebFragment;

public class JsHandler {

    private static String TAG = JsHandler.class.getSimpleName();


    private Activity activity;
    private KajimeWebFragment webFragment;
    private KajimeDialogSocialFragment webDialogFragment;
    private KajimeDialogRequestIpFragment dialogRequestFragment;
    private KajimeHaveBackButtonFragment webDialogHaveBackButton;

    private enum switchCommandJS {
        vaosingtc, // Login thanh cong
        vaofbnhanh, // login FB
        nangcapMatSach,
        vaosignKhach,
        mobLoginGooglePlay, //TODO
        loginMthGG, //TODO
        khoidongNao,
        cucsuc,
        contactView, //TODO
        moimatsach,
        ganchisematsach,
        guithumail,
        guithutinh,
        motrduyen,
        moNhommatsach,
        momodal,
        danhbadt,
        fuzhidaoClip,
        modanhba,
        chuangjianTupian,
        naWenti,
        shandiaoTupian,
        guandiaoChuangkou,
        moClbmatsach,
        chonbanmatsach,
        shanchuQuanbu,
        jianchaDip,
        track
    }

    public JsHandler(Activity activity) {
        this.activity = activity;
    }

    public JsHandler(Activity activity, KajimeWebFragment webFragment) {
        this.activity = activity;
        this.webFragment = webFragment;
    }

    public JsHandler(Activity activity, KajimeDialogSocialFragment webDialogFragment) {
        this.activity = activity;
        this.webDialogFragment = webDialogFragment;
    }

    public JsHandler(Activity activity, KajimeDialogRequestIpFragment dialogRequestFragment) {
        this.activity = activity;
        this.dialogRequestFragment = dialogRequestFragment;
    }

    public JsHandler(Activity activity, KajimeHaveBackButtonFragment webDialogHaveBackButton) {
        this.activity = activity;
        this.webDialogHaveBackButton = webDialogHaveBackButton;
    }

    @JavascriptInterface
    public void executeFunctionP(String command, String params) {
        try {
            Log.i(TAG, "executeFunctionP: command = " + command + "; params = " + params);

            switch (switchCommandJS.valueOf(command)) {

                /**********  LOGIN  **********/
                case vaofbnhanh:
                    CmdLogin.getInstance().mobLoginFacebook(activity, webFragment, params);
                    break;
                case nangcapMatSach:
                    CmdLogin.getInstance().mobUpgradeFacebook(activity, webFragment, webDialogHaveBackButton, params);
                    break;
                case loginMthGG:
                    CmdLogin.getInstance().LoginGoogleAccount(activity, webFragment, params);
                    break;
                case mobLoginGooglePlay:
                    CmdLogin.getInstance().LoginGooglePlay(activity, webFragment, params);
                    break;
                case vaosignKhach:
                    CmdLogin.getInstance().vaosignKhach(activity, webFragment, params);
                    break;
                case vaosingtc:
                    CmdLogin.getInstance().vaosingtc(activity, webFragment, params);
                    break;
                // END LOGIN

                /**********  PAYMENT  **********/
                case khoidongNao:
                    CmdPayment.getInstance().khoidongNao(activity, params);
                    break;
                case cucsuc:
                    CmdPayment.getInstance().cucsuc(activity, params);
                    break;
                // END PAYMENT

                /**********  DASHBOARD  **********/
                case modanhba:
                    CmdDashboard.getInstance().modanhba(activity, params);
                    break;
                case contactView:
                    CmdDashboard.getInstance().contactView(activity, params);
                    break;
                case moimatsach:
                    CmdDashboard.getInstance().moimatsach(activity, params);
                    break;
                case ganchisematsach:
                    CmdDashboard.getInstance().mobAppShare(activity, params);
                    break;
                case guithumail:
                    CmdDashboard.getInstance().guithumail(activity, params);
                    break;
                case guithutinh:
                    CmdDashboard.getInstance().guithutinh(activity, params);
                    break;
                case motrduyen:
                    CmdDashboard.getInstance().motrduyen(activity, params);
                    break;

                case moNhommatsach:
                    CmdDashboard.getInstance().mobmoNhommatsach(activity, params);
                    break;
                case momodal:
                    CmdDashboard.getInstance().momodal(activity, params);
                    break;
                case danhbadt:
                    CmdDashboard.getInstance().danhbadt(activity, params);
                    break;
                case fuzhidaoClip:
                    CmdDashboard.getInstance().fuzhidaoClip(activity, params);
                    break;
                case chuangjianTupian:
                    CmdDashboard.getInstance().mSelectImage(activity, webFragment, params);
                    break;
                case naWenti:
                    CmdDashboard.getInstance().naWenti(activity, webFragment, params);
                    break;
                case shandiaoTupian:
                    CmdDashboard.getInstance().shandiaoTupian(activity, webFragment, params);
                    break;

                case shanchuQuanbu:
                    CmdDashboard.getInstance().clearImageData(activity);
                    break;
                case guandiaoChuangkou:
                    KajimeSDK.isShowLogo = true;
                    KajimeSDK.getInstance().showNotiFloatButton();
                    webDialogFragment.dismiss();
                    break;
                case moClbmatsach:
                    CmdDashboard.getInstance().OpenFBFanpage(activity, params);
                    break;
                case chonbanmatsach:
                    CmdDashboard.getInstance().chonbanmatsach(activity, params);
                    break;
                case track:
                    CmdDashboard.getInstance().trackingFromWeb(activity, params);
                    break;
                case jianchaDip:
                    Log.e("js", params);
                    if (dialogRequestFragment != null) {
                        dialogRequestFragment.getOnRequestIp().OnGetResquestIp(params);
                    }
                    break;
                default:
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}