package com.kajime.libtsy.js;

import android.Manifest;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore.MediaColumns;
import android.text.Html;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.widget.Toast;

import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.facebook.share.widget.GameRequestDialog.Result;
import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.R;
import com.kajime.libtsy.api.PostTask;
import com.kajime.libtsy.api.UploadBitmapTask;
import com.kajime.libtsy.component.FacebookManager;
import com.kajime.libtsy.component.FacebookManager.InviteGameCallback;
import com.kajime.libtsy.component.FacebookManager.InviteGameContent;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.gui.KajimeWebFragment;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.KajimeAppsflyerUtils;
import com.kajime.libtsy.utils.PermissionUtils;
import com.kajime.libtsy.utils.Res;
import com.kajime.libtsy.utils.Utils;

import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

public final class CmdDashboard {

    private static final String TAG = CmdDashboard.class.getSimpleName();
    private static CmdDashboard INSTANCE;

    private CmdDashboard() {
    }

    public static CmdDashboard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdDashboard();
        }
        return INSTANCE;
    }

    public void handleResult(Activity activity, int requestCode,
                             int resultCode, Intent data) {
        try {
            switch (requestCode) {
                case Constants.REQUEST_CODE_PICKER:
                    Uri selectImageUri = data.getData();
                    Bitmap bitmap = getCompressedBitmapFromUri(selectImageUri);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100,
                            byteArrayOutputStream);
                    byte[] byteArray = byteArrayOutputStream.toByteArray();
                    String encoded = Base64.encodeToString(byteArray, Base64.DEFAULT);
                    String key = "img" + Calendar.getInstance().getTimeInMillis();
                    String jsFunction = String.format("getImageData('%s', '%s');",
                            encoded, key);
                    Log.d(TAG, "js function: " + jsFunction);
                    webFragment.invokeJavascript(jsFunction);
                    if (issuePhotos == null) {
                        issuePhotos = new HashMap<String, Bitmap>();
                    }
                    issuePhotos.put(key, bitmap);
                    break;

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    void contactView(Activity activity, String params) {
        Log.i(TAG, "contactView:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String support_email = obj.getString("support_email");
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse("mailto:"
                    + support_email));
            activity.startActivity(intent);
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    void guithutinh(Activity activity, String params) {
        Log.i(TAG, "guithutinh:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String body = obj.getString("body");
            Intent smsVIntent = new Intent(Intent.ACTION_VIEW);
            // prompts only sms-mms clients
            smsVIntent.setType("vnd.android-dir/mms-sms");
            // extra fields for number and message respectively
            smsVIntent.putExtra("sms_body", body);
            activity.startActivity(smsVIntent);
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    void guithumail(Activity activity, String params) {
        Log.i(TAG, "guithumail:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String subject = obj.getString("subject");
            String body = obj.getString("body");
            Intent email = new Intent(Intent.ACTION_SEND, Uri.parse("mailto:"));
            email.setType("text/plain");
            email.putExtra(Intent.EXTRA_EMAIL, "");
            email.putExtra(Intent.EXTRA_SUBJECT, subject);
            email.putExtra(Intent.EXTRA_TEXT, Html.fromHtml(body));
            activity.startActivity(Intent.createChooser(email,
                    "Choose an email client from..."));
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    void moimatsach(Activity activity, String params) {
        Log.i(TAG, "moimatsach:" + params);
        try {

            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;

            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }

            final Activity a = activity;
            final String url = callbackUrl;

            FacebookManager.InviteContent content = new FacebookManager.InviteContent();
            if (obj.has("applinkurl")) {
                content.setApplinkUrl(obj.getString("applinkurl"));
            }
            if (obj.has("previewimageurl")) {
                content.setPreviewImageUrl(obj.getString("previewimageurl"));
            }

            FacebookManager.getInstance().invite(activity, content,
                    new FacebookManager.InviteCallback() {

                        @Override
                        public void onSuccess(Bundle data) {
                            if (!TextUtils.isEmpty(url)) {
                                new PostTask(activity, url, null, false,
                                        new PostTask.Callback() {

                                            @Override
                                            public void onSuccess(
                                                    final String response) {

                                                Intent intent = new Intent(
                                                        Constants.INTENT_FILTER);
                                                intent.putExtra("category",
                                                        "reload");
                                                LocalBroadcastManager
                                                        .getInstance(a)
                                                        .sendBroadcast(intent);
                                            }

                                            @Override
                                            public void onFailure(Throwable e) {
                                            }
                                        }).execute();
                            }
                        }

                        @Override
                        public void onError(Throwable t) {
                            Toast.makeText(
                                    a,
                                    Res.string(a, R.string.something_went_wrong),
                                    Toast.LENGTH_LONG).show();
                        }

                        @Override
                        public void onCancel() {

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    void mobAppShare(Activity activity, String params) {
        Log.i(TAG, "mobAppShare:" + params);
        try {

            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            boolean isSocial = false;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            if (obj.has("isSocial")) {
                isSocial = obj.getBoolean("isSocial");
            }
            final Activity a = activity;
            final String url = callbackUrl;

            FacebookManager.ShareContent shareContent = new FacebookManager.ShareContent();
            if (obj.has("url")) {
                shareContent.setContentUrl(obj.getString("url"));
            }
            if (obj.has("content_title")) {
                shareContent.setContentTitle(obj.getString("content_title"));
            }
            if (obj.has("content")) {
                shareContent.setContentDescription(obj.getString("content"));
            }
            final boolean hasSocial = isSocial;
            FacebookManager.getInstance().shareLink(activity, shareContent,
                    new FacebookManager.ShareCallback() {

                        @Override
                        public void onSuccess(String postId) {
                            if (!TextUtils.isEmpty(url)) {
                                new PostTask(activity, url, null, false,
                                        new PostTask.Callback() {

                                            @Override
                                            public void onSuccess(
                                                    final String response) {
                                                if (!hasSocial) {
                                                    Intent intent = new Intent(
                                                            Constants.INTENT_FILTER);
                                                    intent.putExtra("category",
                                                            "reload");
                                                    LocalBroadcastManager
                                                            .getInstance(a)
                                                            .sendBroadcast(intent);
                                                }
                                            }

                                            @Override
                                            public void onFailure(Throwable e) {
                                            }
                                        }).execute();
                            }
                        }

                        @Override
                        public void onError(Throwable t) {
                            Toast.makeText(
                                    a,
                                    Res.string(a, R.string.something_went_wrong),
                                    Toast.LENGTH_LONG).show();
                        }

                        @Override
                        public void onCancel() {
                            Toast.makeText(a, "Cancel", Toast.LENGTH_SHORT).show();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void motrduyen(Activity activity, String params) {
        Log.i(TAG, "motrduyen:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String url = obj.getString("url");
            motrduyen(activity, Uri.parse(url));
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    private void motrduyen(Activity activity, Uri uri) {
        Log.i(TAG, "motrduyen:" + uri);
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            activity.startActivity(intent);
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void OpenFBFanpage(Activity activity, String params) {
        Log.i(TAG, "moClbmatsach:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String pageid = obj.getString("pageid");
            String callbackUrl = null;
            boolean isSocial = false;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            if (obj.has("isSocial")) {
                isSocial = obj.getBoolean("isSocial");
            }
            try {
                activity.getPackageManager().getPackageInfo(
                        "com.facebook.katana", 0);
                Intent intent = new Intent(Intent.ACTION_VIEW,
                        Uri.parse("fb://page/" + pageid));
                activity.startActivity(intent);
            } catch (Exception e) {
                motrduyen(
                        activity,
                        Uri.parse("http://m.facebook.com/profile.php?id="
                                + pageid));
            }
            if (!TextUtils.isEmpty(callbackUrl)) {
                final Activity a = activity;
                if (!Utils.hasDomain(callbackUrl)) {
                    callbackUrl = Constants.BASE_URL_DOMAIN + callbackUrl;
                }
                final boolean hasSocial = isSocial;
                new PostTask(activity, callbackUrl, null, false, new PostTask.Callback() {

                    @Override
                    public void onSuccess(final String response) {
                        if (!hasSocial) {
                            Intent intent = new Intent(Constants.INTENT_FILTER);
                            intent.putExtra("category", "reload");
                            LocalBroadcastManager.getInstance(a).sendBroadcast(
                                    intent);
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                    }
                }).execute();
            }

        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void mobmoNhommatsach(Activity activity, String params) {
        Log.i(TAG, "moNhommatsach:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String groupid = obj.getString("groupid");
            try {
                activity.getPackageManager().getPackageInfo(
                        "com.facebook.katana", 0);
                Intent intent = new Intent(Intent.ACTION_VIEW,
                        Uri.parse("fb://group/" + groupid));
                activity.startActivity(intent);
            } catch (Exception e) {
                motrduyen(activity,
                        Uri.parse("http://facebook.com/groups/" + groupid));
            }
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void momodal(Activity activity, String params) {
        Log.i(TAG, "momodal:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent(Constants.INTENT_FILTER);
            intent.putExtra("category", "dashboard");
            intent.putExtra("urls", "[{'action':'" + obj.getString("url")
                    + "'}]");
            LocalBroadcastManager.getInstance(activity.getApplicationContext())
                    .sendBroadcast(intent);
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }


    void danhbadt(Activity activity, String params) {
        Log.i(TAG, "danhbadt:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent(Intent.ACTION_DIAL);
            intent.setData(Uri.parse("tel:" + obj.getString("number")));
            activity.startActivity(intent);
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    @SuppressWarnings("deprecation")
    void fuzhidaoClip(Activity activity, String params) {
        try {
            int sdk = android.os.Build.VERSION.SDK_INT;
            JSONObject obj = new JSONObject(params);
            String data = obj.getString("data").trim();
            if (sdk < android.os.Build.VERSION_CODES.HONEYCOMB) {
                android.text.ClipboardManager clipboard = (android.text.ClipboardManager) activity
                        .getSystemService(Context.CLIPBOARD_SERVICE);
                clipboard.setText(data);
            } else {
                android.content.ClipboardManager clipboard = (android.content.ClipboardManager) activity
                        .getSystemService(Context.CLIPBOARD_SERVICE);
                android.content.ClipData clip = android.content.ClipData
                        .newPlainText("clipboard", data);
                clipboard.setPrimaryClip(clip);
            }
            Toast.makeText(activity, Res.string(activity, R.string.copied),
                    Toast.LENGTH_LONG).show();
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    private KajimeWebFragment webFragment;
    private HashMap<String, Bitmap> issuePhotos;

    public void naWenti(Activity activity, KajimeWebFragment webFragment,
                        String params) {
        Log.i(TAG, "naWenti:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            long issueId = Long.parseLong(obj.getString("id"));
            if (issueId != 0) {
                if (issuePhotos != null) {
                    for (Entry<String, Bitmap> entry : issuePhotos.entrySet()) {
                        String key = entry.getKey();
                        Bitmap bitmap = entry.getValue();
                        new UploadBitmapTask(Constants.URL_UPLOAD_ISSUE_IMAGE
                                + "?id=" + issueId, bitmap, activity).execute();
                    }
                }
                issuePhotos = null;
            }
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void shandiaoTupian(Activity activity,
                               KajimeWebFragment webFragment, String params) {
        Log.i(TAG, "shandiaoTupian:" + params);
        if (issuePhotos == null) {
            return;
        }
        if (issuePhotos.isEmpty()) {
            return;
        }

        try {
            JSONObject obj = new JSONObject(params);
            String index = obj.optString("index");

//			Toast.makeText(activity, "index: " + index, Toast.LENGTH_SHORT)
//					.show();

            if (issuePhotos.containsKey(index)) {
                issuePhotos.remove(index);
            }
            Log.d(TAG, "issue photo size:" + issuePhotos.size());
        } catch (Exception e) {
            e.printStackTrace();
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    // clear all photo if user exit report view or submit data error
    public void clearImageData(Activity activity) {
        Log.d(TAG, "clearImageData");
        if (issuePhotos == null) {
            return;
        }

        if (issuePhotos.isEmpty()) {
            return;
        }
        issuePhotos.clear();
    }

    // TODO file choose
    public void mSelectImage(Activity activity, KajimeWebFragment webFragment, String params) {
        try {
            Log.d(TAG, "mSelectImage: " + params);
            if (issuePhotos != null) {
                if (issuePhotos.size() > 2) {

                    AlertDialog.Builder alert = new AlertDialog.Builder(activity);
                    alert.setMessage(activity
                            .getString(R.string.alert_image_validate));
                    alert.setNegativeButton("Ok",
                            new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog,
                                                    int which) {
                                    dialog.dismiss();
                                }
                            });
                    Dialog dialog = alert.create();
                    dialog.setCancelable(false);
                    dialog.show();

                    return;

                }
            }
            this.webFragment = webFragment;

            boolean grantedReadStorage = PermissionUtils
                    .hasPermission(Manifest.permission.READ_EXTERNAL_STORAGE);

            if (!grantedReadStorage) {
                PermissionUtils.requestPermission(KajimeSDK.currentActivity,
                        Manifest.permission.READ_EXTERNAL_STORAGE);
            }

            if (grantedReadStorage) {
                Intent intent = new Intent(
                        Intent.ACTION_PICK,
                        android.provider.MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                intent.setType("image/*");
                activity.startActivityForResult(
                        Intent.createChooser(intent, "Choose photo"),
                        Constants.REQUEST_CODE_PICKER);

            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private Bitmap getCompressedBitmapFromUri(Uri imageUri) {
        Bitmap bitmap = null;
        try {
            String[] projection = {MediaColumns.DATA};
            Cursor cursor = KajimeSDK.currentActivity.managedQuery(imageUri,
                    projection, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow(MediaColumns.DATA);
            cursor.moveToFirst();
            String selectImagePath = cursor.getString(column_index);

            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            o.inSampleSize = 6;
            BitmapFactory.decodeFile(selectImagePath, o);
            final int REQUIRED_SIZE = 75;
            int scale = 1;
            while (o.outWidth / scale / 2 >= REQUIRED_SIZE
                    && o.outHeight / scale / 2 >= REQUIRED_SIZE) {
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            bitmap = BitmapFactory.decodeFile(selectImagePath, o2);
        } catch (Exception e) {
            e.printStackTrace();
            bitmap = Bitmap.createBitmap(100, 100, Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(Color.WHITE);
        }

        return bitmap;
    }

    public void chonbanmatsach(final Activity activity, String params) {
        // TODO Auto-generated method stub
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            final String url = callbackUrl;
            InviteGameContent parameter = new InviteGameContent();
            parameter.setTitle("Invite friend play game");
            parameter.setMessage("Play game with me");
            FacebookManager.getInstance().inviteGameRequest(activity, parameter, new InviteGameCallback() {

                @Override
                public void onSuccess(Result data) {
                    // TODO Auto-generated method stub
                    Log.i(TAG, "invite onSuccess");
                    List<String> list = data.getRequestRecipients();
                    HashMap<String, String> maps = new HashMap<>();
                    String str = "";

                    for (int i = 0; i < list.size(); i++) {
                        str = str + list.get(i) + ",";
                    }
                    Log.d("STR", "str:" + str);
                    String id = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
                    maps.put("account_id", id);
                    maps.put("fbid_friends", str);
                    new PostTask(activity, url, maps, true, true, id, new PostTask.Callback() {
                        @Override
                        public void onSuccess(String response) {
                            // TODO Auto-generated method stub

                        }

                        @Override
                        public void onFailure(Throwable e) {
                            // TODO Auto-generated method stub
                        }
                    }).execute();
                }

                @Override
                public void onError(Throwable t) {
                    // TODO Auto-generated method stub
                    Log.i(TAG, "invite onError");
                }

                @Override
                public void onCancel() {
                    // TODO Auto-generated method stub
                    Log.i(TAG, "invite onCancel");
                }
            });
        } catch (Exception e) {
            // TODO: handle exception
        }
    }

    public void trackingFromWeb(Activity activity, String params) {
        try {
            Log.d(TAG, "label : params - " + params);

            JSONObject json = new JSONObject(params);
            String label = json.getString("label");
            String value = json.getString("value");
            JSONObject jsonChild = new JSONObject(value);
            String name = jsonChild.getString("name");


            Log.d(TAG, "label :" + label + " , name : " + name);
            KajimeAppsflyerUtils.getInstance().trackPayment_RegisterClick(activity, label, name);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    void modanhba(Activity activity, String params) {
        Log.i(TAG, "mobOpenContact:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String support_email = obj.getString("support_email");
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse("mailto:"
                    + support_email));
            activity.startActivity(intent);
        } catch (Exception e) {
            Toast.makeText(
                    activity,
                    "Có lỗi xảy ra",
                    Toast.LENGTH_LONG).show();
        }
    }
}
