package com.kajime.libtsy.gui;

import android.animation.Animator;
import android.animation.Animator.AnimatorListener;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.kajime.libtsy.R;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.Game;
import com.kajime.libtsy.utils.Constants;

public class KajimePagerFragment extends Fragment {

    private Activity activity;
    private View layoutMain;
    private KajimeViewPager viewPager;
    private KajimePagerTabStrip tabs;
    private FragmentPagerAdapter adapter;
    private KajimeWebFragment.EventListener mWebEventListener;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private int selectedIndex;

    public KajimePagerFragment() {
    }

    @SuppressLint("ValidFragment")
    public KajimePagerFragment(Activity activity) {
        this.activity = activity;
    }

    public static final KajimePagerFragment newInstance(Activity activity) {
        KajimePagerFragment mPagerFragment = new KajimePagerFragment(activity);
        return mPagerFragment;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_pager, container, false);
        layoutMain = view.findViewById(R.id.layout_main);
        viewPager = (KajimeViewPager) view.findViewById(R.id.pager);
        tabs = (KajimePagerTabStrip) view.findViewById(R.id.pager_title_strip);

        try {
            Game gameConfigs = GameConfigManager.getInstance().getGameConfig();

            String lang = Constants.LANG_EN;
            if (gameConfigs != null) {
                lang = gameConfigs.getLang();
            }

            if (Constants.LANG_VI.equalsIgnoreCase(lang)) {
                tabs.setIndicatorColor(Color.rgb(241, 67, 8));
                tabs.setTextColor(Color.rgb(241, 67, 8));
            } else {
                tabs.setIndicatorColor(Color.rgb(194, 39, 45));
                tabs.setTextColor(Color.rgb(194, 39, 45));
            }

            if (adapter != null) {
                setAdapter(adapter);
            }
            if (mOnPageChangeListener != null) {
                viewPager.addOnPageChangeListener(mOnPageChangeListener);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return view;
    }

    public void setAdapter(FragmentPagerAdapter adapter) {
        setAdapter(adapter, this.selectedIndex);
    }

    public void setAdapter(FragmentPagerAdapter adapter, final int selectedIndex) {
        try {
            if (viewPager != null && tabs != null) {
                viewPager.setAdapter(null); // IMPORTANT !!!
                viewPager.setAdapter(adapter);
//			adapter.notifyDataSetChanged();
                tabs.setViewPager(viewPager);
                if (adapter.getCount() <= 1
                        && this.adapter.getCount() > 1) {
                    hideTabs(false);
                } else if (adapter.getCount() > 1
                        && this.adapter.getCount() <= 1) {
                    showTabs(false);
                }

                for (int i = 0; i < adapter.getCount(); i++) {
                    Fragment frag = adapter.getItem(i);
                    if (frag instanceof KajimeWebFragment) {
                        ((KajimeWebFragment) frag).setWebViewTag(i + "");
                        if (mWebEventListener != null) {
                            ((KajimeWebFragment) frag).setEventListener(mWebEventListener);
                        }
                    }
                }
                viewPager.setCurrentItem(selectedIndex, false);
                if (mOnPageChangeListener != null) {
                    mOnPageChangeListener.onPageSelected(selectedIndex);
                }
            }
            this.adapter = adapter;
            this.selectedIndex = selectedIndex;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notifyTabsChanged() {
        if (tabs != null) {
            tabs.notifyDataSetChanged();
        }
    }

    public void setWebEventListener(KajimeWebFragment.EventListener eventListener) {
        try {
            this.mWebEventListener = eventListener;
            if (adapter != null) {
                for (int i = 0; i < adapter.getCount(); i++) {
                    Fragment frag = adapter.getItem(i);
                    if (frag instanceof KajimeWebFragment) {
                        ((KajimeWebFragment) frag).setEventListener(mWebEventListener);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addOnPageChangeListener(ViewPager.SimpleOnPageChangeListener onPageChangeListener) {
        if (viewPager != null) {
            viewPager.addOnPageChangeListener(onPageChangeListener);
        }
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public int countTabs() {
        return adapter.getCount();
    }

    public void showTabs(boolean isAnimated) {
        try {
            viewPager.setPagingEnabled(true);
            tabs.setVisibility(View.VISIBLE);
            if (isAnimated) {
                tabs.animate()
                        .setDuration(250)
                        .y(0);
                viewPager.animate()
                        .setDuration(250)
                        .y(tabs.getHeight())
                        .setListener(mAnimatorListener);
            } else {
                tabs.setY(0);
                viewPager.setY(tabs.getHeight());
                ((ViewGroup) layoutMain).updateViewLayout(
                        viewPager,
                        new RelativeLayout.LayoutParams(
                                LayoutParams.MATCH_PARENT,
                                layoutMain.getHeight() - tabs.getHeight()
                        )
                );
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideTabs(boolean isAnimated) {
        try {
            Log.d("kajimeSDK", " hide tab");
            if (viewPager == null) return;
            viewPager.setPagingEnabled(false);
            if (isAnimated) {
                tabs.animate()
                        .setDuration(250)
                        .y(-tabs.getHeight());
                viewPager.animate()
                        .setDuration(250)
                        .y(0)
                        .setListener(mAnimatorListener);
            } else {
                tabs.setY(-tabs.getHeight());
                viewPager.setY(0);
                ((ViewGroup) layoutMain).updateViewLayout(
                        viewPager,
                        new RelativeLayout.LayoutParams(
                                LayoutParams.MATCH_PARENT,
                                layoutMain.getHeight()
                        )
                );
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateTabs() {
        try {
            ((ViewGroup) layoutMain).updateViewLayout(
                    viewPager,
                    new RelativeLayout.LayoutParams(
                            LayoutParams.MATCH_PARENT,
                            layoutMain.getHeight() - tabs.getHeight() - (int) tabs.getY()
                    )
            );
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AnimatorListener mAnimatorListener = new AnimatorListener() {

        @Override
        public void onAnimationStart(Animator animator) {
            try {
                activity.runOnUiThread(new Runnable() {

                    @Override
                    public void run() {
                        ((ViewGroup) layoutMain).updateViewLayout(
                                viewPager,
                                new RelativeLayout.LayoutParams(
                                        LayoutParams.MATCH_PARENT,
                                        layoutMain.getHeight()
                                )
                        );
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onAnimationRepeat(Animator animator) {
        }

        @Override
        public void onAnimationEnd(Animator animator) {
            try {
                activity.runOnUiThread(new Runnable() {

                    @Override
                    public void run() {
                        updateTabs();
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onAnimationCancel(Animator animator) {
        }
    };

}
