package com.kajime.libtsy.gui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Color;
import android.graphics.PixelFormat;
import android.os.Build;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver.OnGlobalLayoutListener;
import android.view.WindowManager;
import android.widget.TextView;

import com.kajime.libtsy.R;
import com.kajime.libtsy.model.Game;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.Res;

/**
 * Created by Pc 02 on 3/28/2018.
 */

public class KajimeNotiOverlayView {
    private static final String TAG = KajimeNotiOverlayView.class.getSimpleName();

    @SuppressLint("StaticFieldLeak")
    private static Activity activity;
    private View rootView, layoutBottom, layoutFloat;/*, layoutMenu*/
    private TextView txtDismiss;

    private KajimeNotiFloatGestureView floatArea;
    //private View animationLayout;
    private boolean isOutsideBottomArea;
    // Screen
    private int boundWidth, boundHeight;
    private int relativePositionOnScreen;
    private int statusBarHeight;
    private String imageUrl = "";
    private float density;
    private Game.ValidationConfig config;
    //private boolean isShowDialogAgain;

    public KajimeNotiOverlayView(Activity a, String imageUrl, String text) {
        activity = a;
        this.imageUrl = imageUrl;
        floatArea = new KajimeNotiFloatGestureView(activity, imageUrl, text);

        density = DeviceUtils.getDensity(a);
        statusBarHeight = DeviceUtils.getStatusBarHeightInPixels(activity);

        attachView();
        initView();
        hide();
    }

    private void attachView() {
        try {
            rootView = LayoutInflater.from(activity).inflate(R.layout.noti_float_overlay_view, null);
            WindowManager windowManager = (WindowManager) activity.getApplicationContext()
                    .getSystemService(Activity.WINDOW_SERVICE);
            int LAYOUT_FLAG;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                LAYOUT_FLAG = WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY;
            } else {
                LAYOUT_FLAG = WindowManager.LayoutParams.TYPE_PHONE;
            }
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(
                    WindowManager.LayoutParams.MATCH_PARENT,
                    WindowManager.LayoutParams.MATCH_PARENT,
                    LAYOUT_FLAG,
                    WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
                    PixelFormat.TRANSPARENT);
            params.gravity = Gravity.LEFT | Gravity.TOP;
            params.flags = WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN
                    | WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
                    | WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL
                    | WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE;
            windowManager.addView(rootView, params);

            rootView.getViewTreeObserver().addOnGlobalLayoutListener(new OnGlobalLayoutListener() {

                @SuppressLint("NewApi")
                public void onGlobalLayout() {

                    if (rootView != null) {
                        boundWidth = rootView.getWidth();
                        boundHeight = rootView.getHeight();
                        floatArea.setMovableWidth(boundWidth);
                        floatArea.setMovableHeight(boundHeight);
                        Log.e(TAG, "boundWidth:" + boundWidth + "||" + "boundHeight" + boundHeight + "||");
                        int[] locations = new int[2];
                        rootView.getLocationOnScreen(locations);
                        relativePositionOnScreen = locations[1];
                        //floatArea.moveTo(0, 0);
                        rootView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initView() {
        try {
            layoutBottom = rootView.findViewById(R.id.layout_bottom_noti);
            layoutFloat = rootView.findViewById(R.id.layout_float_noti);
            txtDismiss = rootView.findViewById(R.id.txt_dismiss_noti);

            floatArea.setEventListener(mButtonEventListener);
            floatArea.moveTo(0, 0);
            txtDismiss.setText(Res.string(activity, R.string.dismiss));
            rootView.post(new Runnable() {
                @Override
                public void run() {
                    layoutBottom.setY(boundHeight + statusBarHeight - relativePositionOnScreen - 125 * density);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private KajimeNotiFloatGestureView.EventListener mButtonEventListener = new KajimeNotiFloatGestureView.EventListener() {

        @Override
        public void onTouchDown(MotionEvent event) {
            isOutsideBottomArea = true;
        }

        @Override
        public void onTouchMove(MotionEvent event) {
            try {
                if (config != null && config.isNeverHideEx()) {
                    return;
                }
                if (isInBottomArea(event.getRawX(), event.getRawY())) {
                    if (isOutsideBottomArea) {
                        showLayoutBottom();
                    }
                    isOutsideBottomArea = false;
                } else {
                    if (!isOutsideBottomArea) {
                        hideLayoutBottom();
                    }
                    isOutsideBottomArea = true;
                }
                if (isInDismissArea(event.getRawX(), event.getRawY())) {
                    txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_active, 0, 0);
                    txtDismiss.setTextColor(Color.rgb(194, 39, 45));
                } else {
                    txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_normal, 0, 0);
                    txtDismiss.setTextColor(Color.rgb(255, 255, 255));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onTouchUp(MotionEvent event) {
            try {
                floatArea.moveToEdge(true);
                if (config != null && config.isNeverHideEx()) {
                    return;
                }
                if (event != null) {
                    if (isInDismissArea(event.getRawX(), event.getRawY())) {
                        hideLayoutBottom();
                        layoutFloat.setVisibility(View.GONE);
                        floatArea.hide();
                    } else {
                        hideLayoutBottom();
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onClick(MotionEvent event) {

        }

        @Override
        public void onMove(int x, int y) {
            try {
                x = Math.max(0, Math.min(boundWidth - floatArea.getSizeInPixels(), x)); //
                y = Math.max(0, Math.min(boundHeight - relativePositionOnScreen - floatArea.getSizeInPixels(), y)); //

                layoutFloat.setX(x);
                layoutFloat.setY(y);

            } catch (Exception e) {
                e.printStackTrace();
            }
//			Log.d(TAG, String.format("move: %sx%s - animate: %sx%s", x, y, animationLayout.getX(), animationLayout.getY()));
        }
    };


    private boolean isInBottomArea(float left, float top) {
        try {
            int dY = (int) (boundHeight - 100 * density);
            return top >= dY || isInDismissArea(left, top);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isInDismissArea(float left, float top) {
        try {
            int dX = boundWidth / 2;
            int dY = (int) (boundHeight - 50 * density);
            double distance = Math.sqrt(Math.pow(left - dX, 2) + Math.pow(top - dY, 2));
            double maxDistance = Math.min(70 * density, boundWidth / 5);

            return distance <= maxDistance
                    || (top >= dY && left >= dX - maxDistance && left <= dX + maxDistance);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void showLayoutBottom() {
        try {
            layoutBottom.setVisibility(View.VISIBLE);
            layoutBottom.animate()
                    .setDuration(200)
                    .y(boundHeight + statusBarHeight - relativePositionOnScreen - 125 * density);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void hideLayoutBottom() {
        try {
            layoutBottom.animate()
                    .setDuration(200)
                    .y(boundHeight + statusBarHeight - relativePositionOnScreen);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void show() {
        try {
            layoutFloat.setVisibility(View.VISIBLE);
            layoutBottom.setVisibility(View.GONE);
            floatArea.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void hide() {
        try {
            layoutFloat.setVisibility(View.GONE);
            layoutBottom.setVisibility(View.GONE);
            floatArea.hide();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public boolean isShowing() {
        try {
            return layoutFloat.getVisibility() == View.VISIBLE;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void dismiss() {
        try {
            rootView.setVisibility(View.GONE);
            WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
                    Activity.WINDOW_SERVICE);
            windowManager.removeView(rootView);

            if (floatArea != null) {
                floatArea.dismiss();
            }
            rootView = null;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setConfig(Game.ValidationConfig config) {
        this.config = config;
    }
}
