package com.kajime.libtsy.gui;

import android.app.Activity;
import android.graphics.PixelFormat;
import android.os.Build;
import android.view.GestureDetector;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.OvershootInterpolator;
import android.view.animation.Transformation;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.kajime.libtsy.R;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.Res;


/**
 * Created by Pc 02 on 3/28/2018.
 */

public class KajimeNotiFloatGestureView {
    private static String TAG = KajimeNotiFloatGestureView.class.getSimpleName();

    private static final int ANIMAION_TIME_MOVE_TO_EDGE = 200;
    private static final int BUTTON_SIZE = 120;

    Activity activity;
    private View rootView, floatArea;
    private EventListener listener;
    private GestureDetector gestureDetector;

    private int buttonSize;
    // Screen
    private int movableWidth, movableHeight;
    private float deltaX, deltaY;

    private WindowManager windowManager;
    private WindowManager.LayoutParams params;
    private String text = "";
    private String imageUrl = "";

    KajimeNotiFloatGestureView(Activity a, String imageUrl, String text) {
        activity = a;
        this.text = text;
        this.imageUrl = imageUrl;
        float density = DeviceUtils.getDensity(a);
        movableWidth = DeviceUtils.getScreenWidthInPixels(a);
        movableHeight = DeviceUtils.getScreenHeightInPixels(a);
        buttonSize = (int) (BUTTON_SIZE * density);

        gestureDetector = new GestureDetector(a, new GestureListener());

        initView();
        attachView();
    }

    private void initView() {
        rootView = LayoutInflater.from(activity).inflate(R.layout.float_area_noti, null);
        floatArea = rootView.findViewById(R.id.layout_float_noti);
        TextView txtFloatButton = rootView.findViewById(R.id.tv_float_noti);
        if (text.length() != 0) txtFloatButton.setText(text);
        else txtFloatButton.setText("Chơi quá 180 phút một ngày sẽ ảnh hưởng xấu đến sức khỏe.");

        ImageView floatButton = rootView.findViewById(R.id.img_float_noti);
        if (imageUrl.length() != 0) {
            RequestOptions options = new RequestOptions()
                    .placeholder(R.drawable.logotuoi)
                    .error(R.drawable.logotuoi);
            Glide.with(activity)
                    .load(imageUrl)
                    .apply(options)
                    .into(floatButton);
        } else floatButton.setImageResource(Res.drawableResource(activity, R.drawable.logotuoi));
        floatArea.getLayoutParams().width = buttonSize;
        //floatArea.getLayoutParams().height = buttonSize;
        floatArea.setOnTouchListener(mOnTouchListener);
    }

    private void attachView() {
        try {
            windowManager = (WindowManager) activity.getApplicationContext()
                    .getSystemService(Activity.WINDOW_SERVICE);
            int LAYOUT_FLAG;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                LAYOUT_FLAG = WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY;
            } else {
                LAYOUT_FLAG = WindowManager.LayoutParams.TYPE_PHONE;
            }
            params = new WindowManager.LayoutParams(
                    WindowManager.LayoutParams.WRAP_CONTENT,
                    WindowManager.LayoutParams.WRAP_CONTENT,
                    LAYOUT_FLAG,
                    WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
                    PixelFormat.TRANSPARENT);
            params.gravity = Gravity.LEFT | Gravity.TOP;
            params.x = 0;
            params.y = 0;
            windowManager.addView(rootView, params);

			/*if (listener != null) {
				listener.onMove(params.x, params.y);
			}*/
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    void setEventListener(EventListener listener) {
        this.listener = listener;
    }

    void setMovableWidth(int width) {
        movableWidth = width;
    }

    void setMovableHeight(int height) {
        movableHeight = height;
    }

    public int getSize() {
        return BUTTON_SIZE;
    }

    int getSizeInPixels()
    {
        return buttonSize;
    }

    public int getX()
    {
        if (rootView == null) return 0;
        return params.x;
    }

    public int getY()
    {
        if (rootView == null) return 0;
        return params.y;
    }

    void moveTo(int x, int y) {
        moveTo(x, y, false);
    }

    private void moveTo(int x, int y, boolean isAnimated) {
        try {
            params.x = x;
            params.y = y;
            windowManager.updateViewLayout(rootView, params);
            if (listener != null) {
                listener.onMove(params.x, params.y);
                listener.onTouchUp(null);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    void moveToEdge(boolean isAnimated) {
        try {
            if (isAnimated) {
                Animation animation = new Animation() {

                    @Override
                    protected void applyTransformation(float interpolatedTime, Transformation t)
                    {
                        super.applyTransformation(interpolatedTime, t);
                        try{
                            float left = params.x;
                            float right = movableWidth - buttonSize - left;

                            if (left <= right) {
                                params.x = (int) (left - left * interpolatedTime);
                            } else {
                                params.x = (int) (left - (left - movableWidth) * interpolatedTime);
                            }

                            windowManager.updateViewLayout(rootView, params);
                            if (listener != null) {
                                listener.onMove(params.x, params.y);
                            }
                        }catch (Exception e){
                            e.printStackTrace();
                        }
                    }
                };

                animation.setDuration(ANIMAION_TIME_MOVE_TO_EDGE);
                animation.setInterpolator(new OvershootInterpolator(0.5f));
                floatArea.startAnimation(animation);
            } else {

                float left = params.x;
                float right = movableWidth - buttonSize - left;
                if (left <= right) {
                    params.x = 0;
                } else {
                    params.x = movableWidth - buttonSize;
                }
                windowManager.updateViewLayout(rootView, params);
                if (listener != null) {
                    listener.onMove(params.x, params.y);
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private OnTouchListener mOnTouchListener = new OnTouchListener() {

        @Override
        public boolean onTouch(View v, MotionEvent event)
        {
            boolean comsumed = true;
            try {
                gestureDetector.onTouchEvent(event);
                switch (event.getAction() & MotionEvent.ACTION_MASK) {
                    case MotionEvent.ACTION_DOWN: {
                        long timeTouchDown = System.currentTimeMillis();
                        onTouchDown(event);
                        break;
                    }
                    case MotionEvent.ACTION_UP: {
					/*double distance = Math.sqrt(Math.pow(deltaX - event.getX(), 2)
							+ Math.pow(deltaY - event.getY(), 2));
					if ((System.currentTimeMillis() - timeTouchDown < 250
					||	distance == 0)
					&& System.currentTimeMillis() - timeTouchUp > 1250) {
						timeTouchUp = System.currentTimeMillis();
						onClick(event);
						comsumed = false;
					}*/

                        onTouchUp(event);
                        break;
                    }
                    case MotionEvent.ACTION_POINTER_DOWN:
                        break;
                    case MotionEvent.ACTION_POINTER_UP:
                        break;
                    case MotionEvent.ACTION_MOVE: {
                        onTouchMove(event);
                        break;
                    }
                }
            }catch (Exception e){
                e.printStackTrace();
            }
            return comsumed;
        }
    };

    private void onTouchDown(MotionEvent event) {
        try {
            deltaX = event.getX();
            deltaY = event.getY();

            if (listener != null) {
                listener.onTouchDown(event);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void onTouchMove(MotionEvent event) {
        try{
            float left = event.getRawX() - deltaX;
            float top = event.getRawY() - deltaY;
//		top = top - statusBarHeightf;

            left = Math.max(0, Math.min(movableWidth , left)); //- buttonSize
            top = Math.max(0, Math.min(movableHeight , top)); //- buttonSize

            params.x = (int) left;
            params.y = (int) top;
            rootView.setLayoutParams(params);

            windowManager.updateViewLayout(rootView, params);

            if (listener != null) {
                listener.onTouchMove(event);
                listener.onMove(params.x, params.y);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void onTouchUp(MotionEvent event) {
        if (listener != null) {
            listener.onTouchUp(event);
        }
    }

    public void show() {
        try {
            rootView.setVisibility(View.VISIBLE);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    void hide() {
        try {
            if(rootView != null){
                rootView.setVisibility(View.GONE);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void dismiss() {
        try {
            rootView.setVisibility(View.GONE);
            windowManager.removeView(rootView);
            rootView = null;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    interface EventListener {
        public void onTouchUp(MotionEvent event);
        public void onTouchDown(MotionEvent event);
        public void onTouchMove(MotionEvent event);
        public void onClick(MotionEvent event);
        public void onMove(int x, int y);
    }

    GestureListener mGestureListener = new GestureListener();

    private class GestureListener extends GestureDetector.SimpleOnGestureListener {

        @Override
        public boolean onDown(MotionEvent e) {
            return true;
        }

        @Override
        public boolean onDoubleTapEvent(MotionEvent e) {
            return false;
        }

        @Override
        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (listener != null) {
                listener.onClick(e);
            }
            return true;
        }

        @Override
        public void onLongPress(MotionEvent e) {
        }
    }

}
