package com.kajime.libtsy.component;

import android.app.Activity;
import android.content.Intent;
import android.content.IntentSender.SendIntentException;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.Scopes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.GoogleApiClient.ConnectionCallbacks;
import com.google.android.gms.common.api.GoogleApiClient.OnConnectionFailedListener;
import com.google.android.gms.common.api.Scope;
import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.R;
import com.kajime.libtsy.utils.Constants;

import java.io.IOException;

public final class GoogleAuthManager {

	private final static String TAG = GoogleAuthManager.class.getSimpleName();
	private static GoogleAuthManager INSTANCE;

	private static final int REQUEST_GOOGLE_PLAY_SERVICES = 412;

	private GoogleApiClient mGoogleApiClient;
	private boolean mResolvingError = false;
	private GooglePlusResultCallback googlePlusResultCallback;
	private Activity activity;
	private String SCOPE = "oauth2:https://www.googleapis.com/auth/userinfo.profile";
	
	public static GoogleAuthManager getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new GoogleAuthManager();
		}
		return INSTANCE;
	}
	
	private GoogleAuthManager() {}
	
	void init(Activity activity) {
		try {
			this.activity = activity;
			GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN)
					.requestEmail()
					.build();

			mGoogleApiClient = new GoogleApiClient.Builder(activity)
					.addConnectionCallbacks(mConnectionCallbacks)
					.addOnConnectionFailedListener(mOnConnectionFailedListener)
					.addApi(Auth.GOOGLE_SIGN_IN_API, gso)
					.build();
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		try {
			if(requestCode == REQUEST_GOOGLE_PLAY_SERVICES){
				this.initGoogleClient(activity);
			}
			if (requestCode == 123) {
				mResolvingError = false;
				if (resultCode == 0) {
					// Make sure the app is not already connected or attempting to connect
					if (!mGoogleApiClient.isConnecting() && !mGoogleApiClient.isConnected()) {
						mGoogleApiClient.connect();
					}
				}
			}
			if (requestCode == Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES) {
				GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
				if (result.isSuccess()) {
					// Signed in successfully, show authenticated UI.

					GoogleSignInAccount acct = result.getSignInAccount();
					String str = acct.getIdToken();
					Log.d("TAG " , "GGOOOOOOO : " + str);
					if (googlePlusResultCallback != null){
						Log.d("TAG " , "GGOOOOOOO");
						new GetToken(activity,SCOPE,acct.getEmail(),acct,googlePlusResultCallback).execute();
					}


				} else {

					Log.wtf("TAG", "onActivityResult: " + result.getStatus().isSuccess() + " "
							+ result.getStatus().getStatusMessage() + " " + result.getStatus().getStatusCode());
					// Signed out, show unauthenticated UI.
					if (googlePlusResultCallback != null)
						googlePlusResultCallback.onLoginError(result.getStatus().getStatusMessage());
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	public void login(Activity activity, GooglePlusResultCallback googlePlusResultCallback) {
		try {
			this.googlePlusResultCallback = googlePlusResultCallback;
			Intent signInIntent = Auth.GoogleSignInApi.getSignInIntent(mGoogleApiClient);
			activity.startActivityForResult(signInIntent, Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES);
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	public void logout() {
		try {
			if (mGoogleApiClient != null && mGoogleApiClient.isConnected()) {
				mGoogleApiClient.disconnect();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	private ConnectionCallbacks mConnectionCallbacks = new ConnectionCallbacks() {
		
		@Override
		public void onConnected(Bundle bundle) {
//			Log.i(TAG, "onConnected:" + bundle + "; " + Plus.AccountApi.getAccountName(mGoogleApiClient));
			try {
			    
			} catch (Exception e) {
				e.printStackTrace();
		        mGoogleApiClient.disconnect();
			}
		}

		@Override
		public void onConnectionSuspended(int arg0) {
		}

	};
	
	private OnConnectionFailedListener mOnConnectionFailedListener = new OnConnectionFailedListener() {

		@Override
		public void onConnectionFailed(ConnectionResult result) {
			try {
				Log.i(TAG, "onConnectionFailed:" + result);
				if (mResolvingError) {
					// Already attempting to resolve an error.
					return;
				} else if (result.hasResolution()) {
					try {
						mResolvingError = true;
						result.startResolutionForResult(KajimeSDK.activity, 123);
					} catch (SendIntentException e) {
						// There was an error with the resolution intent. Try again.
						mGoogleApiClient.connect();
					}
				} else {
					// Show dialog using GoogleApiAvailability.getErrorDialog()
//	            showErrorDialog(result.getErrorCode());
					mResolvingError = true;
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}
	};

	public interface GooglePlusResultCallback {
		void onLoginSuccess(GoogleSignInAccount account, String mToken);

		void onLoginError(String mess);
	}

	public String getToken(Activity activity, String email, String scope) throws IOException, GoogleAuthException {
		return GoogleAuthUtil.getToken(activity, email, scope);
	}

	class GetToken extends AsyncTask<Void,Void,String> {

		Activity mActivity;
		String mScope;
		String mEmail;
		GooglePlusResultCallback mCallback;
		GoogleSignInAccount mGogleSignin;

		public GetToken(Activity activity, String scope, String email, GoogleSignInAccount googleSignInAccount
				, GooglePlusResultCallback callback){

			this.mActivity = activity;
			this.mScope = scope;
			this.mEmail = email;
			this.mCallback = callback;
			this.mGogleSignin = googleSignInAccount;

		}
		@Override
		protected String doInBackground(Void... params) {

			try {
				return getToken(activity,mEmail,mScope);
			} catch (IOException e) {
				e.printStackTrace();
			} catch (GoogleAuthException e) {
				e.printStackTrace();
			}
			return "";
		}

		@Override
		protected void onPostExecute(String aVoid) {
			super.onPostExecute(aVoid);
			try {
				if(!TextUtils.isEmpty(aVoid))
					mCallback.onLoginSuccess(mGogleSignin,aVoid);
			}catch (Exception e){
				e.printStackTrace();
			}
		}
	}

	private void initGoogleClient(Activity activity) {
		try {
			if (mGoogleApiClient == null || mGoogleApiClient.isConnected()) {
				GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN)
						.requestEmail()
//					.requestId()
						.requestIdToken(activity.getString(R.string.server_client_id))
						.requestScopes(new Scope(Scopes.PLUS_ME))
						.requestScopes(new Scope(Scopes.PLUS_LOGIN))
						.build();

				mGoogleApiClient = new GoogleApiClient.Builder(this.activity)
						.addConnectionCallbacks(mConnectionCallbacks)
						.addOnConnectionFailedListener(mOnConnectionFailedListener)
						.addApi(Auth.GOOGLE_SIGN_IN_API, gso)
						.addScope(new Scope(Scopes.PROFILE))
						.addScope(new Scope(Scopes.EMAIL))
						.build();
			} else {
				mGoogleApiClient.disconnect();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public boolean isGoogleServiceAvailable(Activity activity) {
		try {
			GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
			int result = googleAPI.isGooglePlayServicesAvailable(activity);
			if(result != ConnectionResult.SUCCESS) {
				if(googleAPI.isUserResolvableError(result)) {
					googleAPI.getErrorDialog(activity, result,
							REQUEST_GOOGLE_PLAY_SERVICES).show();
				}
				return false;
			}

			return true;
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}
}
