package com.kajime.libtsy.component;

/**
 * Created by Pc 02 on 3/7/2018.
 */
import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;

import com.google.firebase.analytics.FirebaseAnalytics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;


public class FirebaseAnalyticsManager {

    private static final String TAG = FirebaseAnalyticsManager.class.getSimpleName();
    private static FirebaseAnalyticsManager INSTANCE;
    private FirebaseAnalytics mFirebaseAnalytics;

    public static FirebaseAnalyticsManager getInstance(){
        if(INSTANCE == null){
            INSTANCE = new FirebaseAnalyticsManager();
        }
        return INSTANCE;
    }

    @SuppressLint("MissingPermission")
    public void firebaseEventTrack(Context context, String labelEvent , HashMap<String , Object> params){
        try {
            Bundle bundle = new Bundle();
            if(mFirebaseAnalytics == null){
                mFirebaseAnalytics = FirebaseAnalytics.getInstance(context);
            }
            if(params != null){
                Set mapSet = params.entrySet();
                for (Object aMapSet : mapSet) {
                    Map.Entry mapEntry = (Map.Entry) aMapSet;
                    String key = (String) mapEntry.getKey();
                    String value = String.valueOf(mapEntry.getValue());
                    Log.d(TAG, "key : " + key + " , value:" + value);
                    bundle.putString(key, value);
                }

                mFirebaseAnalytics.logEvent(labelEvent , bundle);
            }else{
                mFirebaseAnalytics.logEvent(labelEvent , null);
            }
            Log.i(TAG, "****** Firebase track: " + labelEvent + " | eventValue: " + bundle.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
