package com.kajime.libtsy.component;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;

import com.appsflyer.AppsFlyerLib;
import com.kajime.libtsy.api.SaveEventClientTask;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.Preference;
import com.kajime.libtsy.utils.TimeUtils;
import com.kajime.libtsy.utils.Utils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

/**
 * Created by NamAnh on 8/8/2017.
 */

public class EventClientManager {
    private static EventClientManager INSTANCE;
    private static final String TAG = EventClientManager.class.getSimpleName();

    public static final String SAVE_EVENT_START_SESSION = "start";
    public static final String SAVE_EVENT_END_SESSION = "end";
    public static final String SAVE_EVENT_NORMAL = "normal";


    private static String userId;
    private static Date startSessionTime;

    private String chiafkhoas;
    private String maxthoongbaos;
    private String heejddieeufhanhf;
    private String ddoojphaangiair;
    private String phieenbanr;
    private String phieenbanrCode;
    private String mangj;
    private String thietbi_teen;
    private String thuwvieenj_phieenbanr;
    private String nhanvat_max;
    private String maychu_max;
    private String nhanvat_teen;
    private String maychu_teen;
    private String ad_max;
    private String chieuf_thieetsbij;
    private String nhafphaanphoois;
    private String ngoonnguwx;
    private String af_max;

    public EventClientManager(Context context) {
        try {
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getDevice():"+ DeviceUtils.getDevice());
            setThietbi_teen(DeviceUtils.getDevice());
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getOSInfo():"+DeviceUtils.getOSInfo());
            setHeejddieeufhanhf(DeviceUtils.getOSInfo());
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getResolution(context):"+DeviceUtils.getResolution(context));
            setDdoojphaangiair(DeviceUtils.getResolution(context));
            Log.d(TAG, "initHeaderRequest: Utils.getSDKVersion(context):"+ Utils.getSDKVersion(context));
            setThuwvieenj_phieenbanr(Utils.getSDKVersion(context));
            Log.d(TAG, "initHeaderRequest: GameConfigManager.getInstance().getAppKey():"+GameConfigManager.getInstance().getAppKey(context));
            setChiafkhoas(GameConfigManager.getInstance().getAppKey(context));
            Log.d(TAG, "initHeaderRequest: Utils.getGameVersion(context):"+Utils.getGameVersion(context));
            setPhieenbanr(Utils.getGameVersion(context));
            Log.d(TAG, "initHeaderRequest: Utils.getGameVersionCode(context):"+Utils.getGameVersionCode(context));
            setPhieenbanrCode(Utils.getGameVersionCode(context));
            Log.d(TAG, "initHeaderRequest: Utils.getNetwork(context):"+Utils.getNetwork(context));
            setMangj(Utils.getNetwork(context));
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getScreenOrientation(context):"+DeviceUtils.getScreenOrientation(context));
            setChieuf_thieetsbij(DeviceUtils.getScreenOrientation(context) + "");
            Log.d(TAG, "initHeaderRequest: Utils.getReferrer(context):"+Utils.getReferrer(context));
            setNhafphaanphoois(Utils.getReferrer(context));
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getLanguage():"+DeviceUtils.getLanguage());
            setNgoonnguwx(DeviceUtils.getLanguage());
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getAdvertisingID(context):"+DeviceUtils.getAdvertisingID(context));
            setAd_max(DeviceUtils.getAdvertisingID(context));
            Log.d(TAG, "EventClientManager: GameConfigManager.getInstance().getAccessToken()"+ Preference.getString(context, GameConfigManager.SHARED_PREF_MACCESS_TOKEN));
            setMaxthoongbaos(Preference.getString(context, GameConfigManager.SHARED_PREF_MACCESS_TOKEN));
            Log.d(TAG, "initHeaderRequest: AppsFlyerLib.getInstance().getAppsFlyerUID(context):"+ AppsFlyerLib.getInstance().getAppsFlyerUID(context));
            setAf_max(AppsFlyerLib.getInstance().getAppsFlyerUID(context));
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void saveEventClient(String type, String eventName, HashMap<String, Object> eventValue){
        String data="{}";
        JSONObject objData = new JSONObject();
        try {
            objData.put("user_id", userId);

            JSONObject objSession = new JSONObject();
            JSONObject objSubSession = new JSONObject();
            String eventType = "";
            if(type.equalsIgnoreCase(SAVE_EVENT_START_SESSION)){
                setStartSessionTime(new Date());
                eventType= "_session.start";
                long timeStamp = startSessionTime.getTime()/1000;
                objSubSession.put("id", ""+userId+timeStamp);
                objSubSession.put("startTimestamp", TimeUtils.getTimeIso(startSessionTime));
            }else if(type.equalsIgnoreCase(SAVE_EVENT_END_SESSION)){
                eventType= "_session.stop";
                long timeStamp = (new Date()).getTime()/1000;
                Date endSessionTime = new Date();
                long startTime = startSessionTime.getTime()/1000;
                objSubSession.put("id", ""+userId+timeStamp);
                objSubSession.put("startTimestamp", TimeUtils.getTimeIso(startSessionTime));
                objSubSession.put("stopTimestamp", TimeUtils.getTimeIso(endSessionTime));
                objSubSession.put("duration", ""+(timeStamp - startTime));
            }
            objSession.put("eventType", eventType);
            objSession.put("timestamp", TimeUtils.getTimeIso(new Date()));
            objSession.put("session", objSubSession);
            objData.put("session", objSession);

            JSONObject objEvent = new JSONObject();
            if(eventName!=null && !eventName.isEmpty()){
                objEvent.put("eventName", eventName);
                if(eventValue!=null){
                    objEvent.put("attributes", new JSONObject(eventValue));
                }
            }
            objData.put("event", objEvent);

            objData.put("header", new JSONObject(toStringJsonRequestHeader()));

            data = objData.toString();
            Log.d(TAG, "saveEventClient: data:"+data);
            if(getChiafkhoas()!=null && !getChiafkhoas().isEmpty()){
                (new SaveEventClientTask(data)).execute();
            }
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (Exception e){
            e.printStackTrace();
        }
    }

    public static EventClientManager getInstance(Context context){
        if(INSTANCE == null){
            INSTANCE = new EventClientManager(context);
        }
        return INSTANCE;
    }

    public String toStringJsonRequestHeader(){
        JSONObject jsonObject= new JSONObject();
        Locale defaultLocale = Resources.getSystem().getConfiguration().locale;
        try {
            jsonObject.put("X-Request", getChiafkhoas());
            jsonObject.put("nguy-min-dinhdanh", getMaxthoongbaos());
            jsonObject.put("nguy-min-os", getHeejddieeufhanhf());
            jsonObject.put("nguy-min-re-so", getDdoojphaangiair());
            jsonObject.put("nguy-min-uk-ve", getPhieenbanr());
            jsonObject.put("nguy-vercode-ungdungs", getPhieenbanrCode());
            jsonObject.put("nguy-min-ne-rk", getMangj());
            jsonObject.put("nguy-min-de", getThietbi_teen());
            jsonObject.put("nguy-min-dk-ve", getThuwvieenj_phieenbanr());
            jsonObject.put("nguy-min-atz-i", getNhanvat_max());
            jsonObject.put("nguy-min-zta-i", getMaychu_max());
            jsonObject.put("nguy-min-atz-n", getNhanvat_teen());
            jsonObject.put("nguy-min-zta-n", getMaychu_teen());
            jsonObject.put("nguy-min-ad-i", getAd_max());
            jsonObject.put("nguy-chieu-thietbi", getChieuf_thieetsbij());
            jsonObject.put("nguy-nhapp-ditributor", getNhafphaanphoois());
            jsonObject.put("nguy-min-language", getNgoonnguwx());
            jsonObject.put("nguy-min-ap-i", getAf_max());
            return jsonObject.toString();
        } catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getUserId() {
        return userId;
    }

    public static void setUserId(String userId) {
        EventClientManager.userId = userId;
    }

    public static Date getStartSessionTime() {
        return startSessionTime;
    }

    public static void setStartSessionTime(Date startSessionTime) {
        EventClientManager.startSessionTime = startSessionTime;
    }

    public String getChiafkhoas() {
        return chiafkhoas;
    }

    public void setChiafkhoas(String chiafkhoas) {
        this.chiafkhoas = chiafkhoas;
    }

    public String getMaxthoongbaos() {
        return maxthoongbaos;
    }

    public void setMaxthoongbaos(String maxthoongbaos) {
        this.maxthoongbaos = maxthoongbaos;
    }

    public String getHeejddieeufhanhf() {
        return heejddieeufhanhf;
    }

    public void setHeejddieeufhanhf(String heejddieeufhanhf) {
        this.heejddieeufhanhf = heejddieeufhanhf;
    }

    public String getDdoojphaangiair() {
        return ddoojphaangiair;
    }

    public void setDdoojphaangiair(String ddoojphaangiair) {
        this.ddoojphaangiair = ddoojphaangiair;
    }

    public String getPhieenbanr() {
        return phieenbanr;
    }

    public void setPhieenbanr(String phieenbanr) {
        this.phieenbanr = phieenbanr;
    }

    public String getPhieenbanrCode() {
        return phieenbanrCode;
    }

    public void setPhieenbanrCode(String phieenbanrCode) {
        this.phieenbanrCode = phieenbanrCode;
    }

    public String getMangj() {
        return mangj;
    }

    public void setMangj(String mangj) {
        this.mangj = mangj;
    }

    public String getThietbi_teen() {
        return thietbi_teen;
    }

    public void setThietbi_teen(String thietbi_teen) {
        this.thietbi_teen = thietbi_teen;
    }

    public String getThuwvieenj_phieenbanr() {
        return thuwvieenj_phieenbanr;
    }

    public void setThuwvieenj_phieenbanr(String thuwvieenj_phieenbanr) {
        this.thuwvieenj_phieenbanr = thuwvieenj_phieenbanr;
    }

    public String getNhanvat_max() {
        return nhanvat_max;
    }

    public void setNhanvat_max(String nhanvat_max) {
        this.nhanvat_max = nhanvat_max;
    }

    public String getMaychu_max() {
        return maychu_max;
    }

    public void setMaychu_max(String maychu_max) {
        this.maychu_max = maychu_max;
    }

    public String getNhanvat_teen() {
        return nhanvat_teen;
    }

    public void setNhanvat_teen(String nhanvat_teen) {
        this.nhanvat_teen = nhanvat_teen;
    }

    public String getMaychu_teen() {
        return maychu_teen;
    }

    public void setMaychu_teen(String maychu_teen) {
        this.maychu_teen = maychu_teen;
    }

    public String getAd_max() {
        return ad_max;
    }

    public void setAd_max(String ad_max) {
        this.ad_max = ad_max;
    }

    public String getChieuf_thieetsbij() {
        return chieuf_thieetsbij;
    }

    public void setChieuf_thieetsbij(String chieuf_thieetsbij) {
        this.chieuf_thieetsbij = chieuf_thieetsbij;
    }

    public String getNhafphaanphoois() {
        return nhafphaanphoois;
    }

    public void setNhafphaanphoois(String nhafphaanphoois) {
        this.nhafphaanphoois = nhafphaanphoois;
    }

    public String getNgoonnguwx() {
        return ngoonnguwx;
    }

    public void setNgoonnguwx(String ngoonnguwx) {
        this.ngoonnguwx = ngoonnguwx;
    }

    public String getAf_max() {
        return af_max;
    }

    public void setAf_max(String af_max) {
        this.af_max = af_max;
    }
}
