package com.kajime.libtsy.api;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;

import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.CharacterInfo;
import com.kajime.libtsy.utils.KajimeAppsflyerUtils;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class SaveCharacterTask extends AsyncTask<Void, Void, Void> {

    private String roleId;
    private String areaId;
    private String roleName;
    private String areaName;

    public SaveCharacterTask(String areaId, String areaName, String roleId, String roleName) {
        this.roleId = roleId;
        this.areaId = areaId;
        this.roleName = roleName;
        this.areaName = areaName;
    }

    @Override
    protected Void doInBackground(Void... params) {
        try {
            Context context = KajimeSDK.getApplicationContext();
            CharacterInfo charInfo = new CharacterInfo();
            charInfo.setAreaId(areaId);
            charInfo.setAreaName(areaName);
            charInfo.setRoleId(roleId);
            charInfo.setRoleName(roleName);
            GameConfigManager.getInstance().setCharacterInfo(charInfo);

            if (!TextUtils.isEmpty(areaId) && !TextUtils.isEmpty(roleId)) {
                KajimeAppsflyerUtils.getInstance().trackCreateCharacterRequest(context, "call");
                RestfulApi api = RestfulApi.getInstance();
                Call<ResponseBody> call = api.saveCharacter(roleId, areaId, roleName, areaName);
                call.enqueue(new Callback<ResponseBody>() {
                    @Override
                    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                        if (response.isSuccessful()) {
                            KajimeAppsflyerUtils.getInstance().trackCreateCharacterRequest(context, "success");
                        }
                    }

                    @Override
                    public void onFailure(Call<ResponseBody> call, Throwable t) {
                        KajimeAppsflyerUtils.getInstance().trackCreateCharacterRequest(context, "fail");
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}