package com.kajime.libtsy.api;

import android.os.AsyncTask;

import com.google.gson.Gson;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.UserInfo.User;

import org.json.JSONException;
import org.json.JSONObject;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;

public class ProcessIABReceiptTask extends AsyncTask<Void, Void, Void> {
	
	private String itemType;
	private String signature;
	private String data;
	private String state;
	
	private Callback<ResponseBody> callback;

	public ProcessIABReceiptTask(String itemType, String signature, String data) {
		this.itemType = itemType;
		this.signature = signature;
		this.data = data;
	}
	
	public ProcessIABReceiptTask(String state, String itemType, String signature, String data, Callback<ResponseBody> callback) {
		this.state = state;
		this.itemType = itemType;
		this.signature = signature;
		this.data = data;
		this.callback = callback;
	}
	
	public void setCallback(Callback<ResponseBody> callback) {
		this.callback = callback;
	}

	@Override
	protected Void doInBackground(Void... params) {
		try {
			Gson gson = new Gson();
			User user = GameConfigManager.getInstance().getUserInfo().getUser();
			
			JSONObject jsonPurchase = new JSONObject();
			jsonPurchase.put("data", this.data);
			jsonPurchase.put("itemType", this.itemType);
			jsonPurchase.put("signature", this.signature);
			jsonPurchase.put("user", gson.toJson(user));
			
			RestfulApi api = RestfulApi.getInstance();
			Call<ResponseBody> call = api.processGooglePayment(jsonPurchase.toString(), state);
			call.enqueue(callback);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return null;
	}
}