package com.kajime.libtsy.api;

import android.content.Context;
import android.os.AsyncTask;
import android.webkit.CookieManager;

import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.component.FacebookManager;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.component.GoogleAnalyticsManager;
import com.kajime.libtsy.component.GoogleAuthManager;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.Preference;

public class LogoutTask extends AsyncTask<Void, Void, Void> {

    private OnLogoutSuccessfulListener callback;

    public LogoutTask(OnLogoutSuccessfulListener callback) {
        this.callback = callback;
    }


    @Override
    protected Void doInBackground(Void... params) {
        try {
            Context c = KajimeSDK.getApplicationContext();
            String roleId = "";
            try {
                roleId = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
            } catch (Exception e) {
                e.printStackTrace();
            }

            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.removeSessionCookie();
            cookieManager.removeAllCookie();

            GameConfigManager.getInstance().clearLogin();
            GoogleAnalyticsManager.getInstance().removeTrackers();
            FacebookManager.getInstance().logout();
            GoogleAuthManager.getInstance().logout();
            Preference.remove(c, Constants.SHARED_PREF_COOKIES);
            Preference.remove(c, Constants.KEY_LOGIN_TYPE);
            Preference.remove(c, Constants.IS_CONNECT_FB);
            Preference.remove(c, Constants.TYPE_LOGIN);
            if (callback != null) {
                callback.onLogoutSuccessfull(roleId);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

    public interface OnLogoutSuccessfulListener {
        void onLogoutSuccessfull(String roleId);
    }
}