package com.kajime.libtsy.api;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.kajime.libtsy.KajimeSDK;
import com.kajime.libtsy.model.EncodedResponse;
import com.kajime.libtsy.model.Game;
import com.kajime.libtsy.utils.EncryptionUtils;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GetInfoBeforeAuthenTask extends AsyncTask<Void, Void, Void> {

	private Listener callback;

	public GetInfoBeforeAuthenTask(Listener callback) {
		this.callback = callback;
	}

	@Override
	protected Void doInBackground(Void... params) {
		Context c = KajimeSDK.getApplicationContext();
		String sign = EncryptionUtils.getSignedString(c);
		Log.d("TAG " , "sign before :" + sign);

		RestfulApi api = RestfulApi.getInstance();
		Call<EncodedResponse> call = api.getInfoBeforeAuthen(sign);
		call.enqueue(new Callback<EncodedResponse>() {

			@Override
			public void onResponse(Call<EncodedResponse> call, Response<EncodedResponse> response) {
				try {
					Log.d("TAG" , "response:" + response.body());
					if (response.isSuccessful()) {
						String responseBody = response.body().getDecodedData();
						Game game = Game.parse(responseBody);
						if (callback != null) {
							callback.onSuccess(game);
						}
						Log.e("TAG","Successful");
					} else {
						if (callback != null) {
							callback.onFailure(new Exception());
						}
						Log.e("TAG","Not Successful");
					}
				} catch (Exception e) {
					if (callback != null) {
						callback.onFailure(e);
						Log.e("TAG","Exception");
					}
				}
			}

			@Override
			public void onFailure(Call<EncodedResponse> call, Throwable t) {
				if (callback != null) {
					callback.onFailure(t);
				}
			}
		});
		return null;
	}

	public interface Listener {
		public void onSuccess(Game game);
		public void onFailure(Throwable t);
	}

}