/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.content.ContextCompat;
import com.kajime.libtsy.LibrarySDK;
import com.kajime.libtsy.gui.DrawOverAppsFragment;
import com.kajime.libtsy.gui.PermissionFragment;

public class PermissionUtils {
    public static boolean hasPermission(String permission2) {
        if (Build.VERSION.SDK_INT >= 23) {
            Context c = LibrarySDK.getApplicationContext();
            boolean granted = false;
            granted = permission2.equals("android.permission.SYSTEM_ALERT_WINDOW") ? PermissionUtils.isSystemAlertPermissionGranted(c) : ContextCompat.checkSelfPermission((Context)c, (String)permission2) == 0;
            return granted;
        }
        return true;
    }

    public static void requestPermission(Activity a, String permission2) {
        if (permission2 == "android.permission.SYSTEM_ALERT_WINDOW") {
            FragmentManager fm = a.getFragmentManager();
            DrawOverAppsFragment fr = DrawOverAppsFragment.newInstance();
            fm.beginTransaction().add((Fragment)fr, "tag_fragment_permission").commit();
        } else {
            FragmentManager fm = a.getFragmentManager();
            PermissionFragment fr = PermissionFragment.newInstance(new String[]{permission2});
            fm.beginTransaction().add((Fragment)fr, "tag_fragment_permission").commit();
        }
    }

    public static void requestPermissions(Activity a, String[] permissions) {
        FragmentManager fm = a.getFragmentManager();
        PermissionFragment fr = PermissionFragment.newInstance(permissions);
        fm.beginTransaction().add((Fragment)fr, "tag_fragment_permission").commit();
    }

    @TargetApi(value=23)
    private static boolean isSystemAlertPermissionGranted(Context c) {
        return Build.VERSION.SDK_INT < 23 || Settings.canDrawOverlays((Context)c);
    }
}

