/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.utils;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerLib;
import com.kajime.libtsy.LibrarySDK;
import com.kajime.libtsy.component.EventClientManager;
import com.kajime.libtsy.component.FirebaseAnalyticsManager;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.utils.Preference;
import com.kajime.libtsy.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LibAppsflyerUtils {
    private static LibAppsflyerUtils instance;
    private String appsflyerDevkey = "cfgYFoj97okaEbzqp8q5w5";
    private String fcmSenderId = "577522348312";
    private String TAG = "LibAppsflyerUtils";
    private Map<String, Object> conversionDataLoaded;
    private ArrayList<String> listTrackEventQueue = new ArrayList();
    private boolean initted;
    private static final String TRACK_APP_LAUNCH = "ft_app_launch";
    private static final String TRACK_FIRST_LAUNCH = "ft_first_launch";
    private static final String TRACK_APP_LAUNCH_XX = "ft_app_launch_";
    private static final String TRACK_DOWNLOAD_RES_STARTED = "ft_resource_started";
    private static final String TRACK_DOWNLOAD_RES_FAILED = "ft_resource_failed";
    private static final String TRACK_DOWNLOAD_RES_FINISHED = "ft_resource_finished";
    private static final String TRACK_CHARACTOR_CREATED = "ft_character_created";
    private static final String TRACK_START_TUTORIAL = "af_tutorial_started";
    private static final String TRACK_FINISH_TUTORIAL = "af_tutorial_completion";
    private static final String TRACK_REACH_A_LEVEL = "af_level_achieved";
    private static final String TRACK_LEVEL_PLATFORM = "ft_level_platform";
    private static final String TRACK_LEVEL_ACHIEVED_A = "ft_level_achieved_A";
    private static final String TRACK_LEVEL_ACHIEVED_B = "ft_level_achieved_B";
    private static final String TRACK_LEVEL_ACHIEVED_C = "ft_level_achieved_C";
    private static final String TRACK_REGISTER_SUCCESS = "ft_register_success";
    private static final String TRACK_LOGIN_SUCCESS = "ft_login_success";
    public static final String TRACK_LOGIN_SUCCESS_AFTER_AUTH = "ft_login_success_after_auth";
    private static final String TRACK_PAYMENT_OPEN = "ft_payment_opened";
    public static final String TRACK_PAYMENT_CLICK = "ft_payment_clicked";
    public static final String TRACK_PAYMENT_CLOSE = "ft_payment_closed";
    private static final String TRACK_FT_PAYMENT_SUCCESS = "ft_purchase";
    private static final String TRACK_FORM_LOGIN_OPENED = "ft_form_login_opened";
    public static final String TRACK_LOGIN_CLICKED = "ft_login_clicked";
    public static final String TRACK_LOGIN_CLOSED = "ft_login_closed";
    public static final String TRACK_EVENT_LOGOUT = "ft_logout";
    private static final String TRACK_FT_SESSION = "ft_session";
    private static final String TRACK_FT_LOADTIME = "ft_loadtime";
    private static final String SESSION_VALUE = "session_value";

    private LibAppsflyerUtils() {
    }

    public static synchronized LibAppsflyerUtils getInstance() {
        if (instance == null) {
            instance = new LibAppsflyerUtils();
        }
        return instance;
    }

    public void init(final Application context) {
        try {
            Log.i((String)this.TAG, (String)"initAppsFlyer");
            AppsFlyerLib.getInstance().enableUninstallTracking(this.fcmSenderId);
            LibrarySDK.applicationContext = context;
            AppsFlyerLib.getInstance().setCollectIMEI(false);
            AppsFlyerLib.getInstance().setCollectAndroidID(false);
            AppsFlyerLib.getInstance().setDebugLog(true);
            AppsFlyerConversionListener conversionDataListener = new AppsFlyerConversionListener(){

                public void onInstallConversionDataLoaded(Map<String, String> conversionData) {
                    try {
                        HashMap<String, Object> map = new HashMap<String, Object>(conversionData);
                        LibAppsflyerUtils.this.conversionDataLoaded = map;
                        if (!LibAppsflyerUtils.this.initted) {
                            LibAppsflyerUtils.this.initted = true;
                            LibAppsflyerUtils.this.trackEvent((Context)context, LibAppsflyerUtils.TRACK_APP_LAUNCH, map);
                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)context, LibAppsflyerUtils.TRACK_APP_LAUNCH, null);
                            int countLauncher = Preference.getInt((Context)context, "count_launcher", 0);
                            Log.e((String)LibAppsflyerUtils.this.TAG, (String)("countLauncher:" + countLauncher));
                            if (countLauncher < 30) {
                                Preference.save((Context)context, "count_launcher", ++countLauncher);
                                LibAppsflyerUtils.this.trackLoyalUser((Context)context, LibAppsflyerUtils.TRACK_APP_LAUNCH_XX + countLauncher);
                            }
                        }
                        for (String attrName : conversionData.keySet()) {
                            Log.d((String)LibAppsflyerUtils.this.TAG, (String)("onInstallConversionDataLoaded attribute: " + attrName + " = " + conversionData.get(attrName)));
                            if (!attrName.equals("is_first_launch") || !conversionData.get(attrName).equals("true")) continue;
                            LibAppsflyerUtils.this.trackEvent((Context)context, LibAppsflyerUtils.TRACK_FIRST_LAUNCH, map);
                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)context, LibAppsflyerUtils.TRACK_FIRST_LAUNCH, null);
                        }
                        if (LibAppsflyerUtils.this.listTrackEventQueue != null) {
                            map.put("Resend", "when inited");
                            for (String eventName : LibAppsflyerUtils.this.listTrackEventQueue) {
                                LibAppsflyerUtils.this.trackEvent((Context)context, eventName, map);
                            }
                            LibAppsflyerUtils.this.listTrackEventQueue.clear();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onInstallConversionFailure(String errorMessage) {
                    LibAppsflyerUtils.this.initted = false;
                    Log.d((String)LibAppsflyerUtils.this.TAG, (String)(" onInstallConversionFailure error getting conversion data: " + errorMessage));
                }

                public void onAppOpenAttribution(Map<String, String> conversionData) {
                    for (String attrName : conversionData.keySet()) {
                        Log.d((String)LibAppsflyerUtils.this.TAG, (String)("onAppOpenAttribution attribute: " + attrName + " = " + conversionData.get(attrName)));
                    }
                }

                public void onAttributionFailure(String errorMessage) {
                    Log.d((String)LibAppsflyerUtils.this.TAG, (String)(" onAttributionFailure error onAttributionFailure : " + errorMessage));
                }
            };
            AppsFlyerLib.getInstance().init(this.appsflyerDevkey, conversionDataListener, (Context)context);
            AppsFlyerLib.getInstance().startTracking(context);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (LibrarySDK.getInstance().isLoggedIn()) {
                        EventClientManager.getInstance((Context)context).saveEventClient("start", LibAppsflyerUtils.TRACK_APP_LAUNCH, null);
                    } else {
                        EventClientManager.getInstance((Context)context).saveEventClient("normal", LibAppsflyerUtils.TRACK_APP_LAUNCH, null);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        try {
            if (this.initted) {
                HashMap<String, Object> map = new HashMap<String, Object>(this.conversionDataLoaded);
                if (eventValues != null) {
                    map.putAll(eventValues);
                }
                AppsFlyerLib.getInstance().trackEvent(context, eventName, map);
                Log.d((String)this.TAG, (String)("trackEvent: " + eventName + " eventValue: " + map));
            } else {
                Log.d((String)this.TAG, (String)("trackEvent " + eventName + " fail cause of AppsflyerLib is not inited successful"));
                this.listTrackEventQueue.add(eventName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trackLoyalUser(Context context, String eventName) {
        try {
            Log.d((String)this.TAG, (String)("event name : " + eventName));
            AppsFlyerLib.getInstance().trackEvent(context, eventName, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, eventName, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackOpenFormLogin(Activity activity) {
        try {
            this.trackEvent((Context)activity, TRACK_FORM_LOGIN_OPENED, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FORM_LOGIN_OPENED, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackOpenFormPayment(Activity activity) {
        try {
            this.trackEvent((Context)activity, TRACK_PAYMENT_OPEN, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_PAYMENT_OPEN, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginSuccess(Activity activity) {
        try {
            this.trackEvent((Context)activity, TRACK_LOGIN_SUCCESS_AFTER_AUTH, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LOGIN_SUCCESS_AFTER_AUTH, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackRegisterSuccess(Activity activity, String typeRegister) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("VALUE", typeRegister);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_REGISTER_SUCCESS, hashMap);
            this.trackEvent((Context)activity, TRACK_REGISTER_SUCCESS, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginSuccessFromWeb(Activity activity, String typeLogin) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("VALUE", typeLogin);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LOGIN_SUCCESS, hashMap);
            this.trackEvent((Context)activity, TRACK_LOGIN_SUCCESS, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginClick(Activity activity, String label, HashMap<String, Object> typeLoginClick) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, label, typeLoginClick);
            this.trackEvent((Context)activity, label, typeLoginClick);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPayment_RegisterClick(Activity activity, String label, String value) {
        try {
            this.trackEvent((Context)activity, label, null);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("VALUE", value);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, label, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPaymentSuccess(Activity activity, HashMap<String, Object> eventValue) {
        try {
            this.trackEvent((Context)activity, "af_purchase", eventValue);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FT_PAYMENT_SUCCESS, eventValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackSession(Activity activity, long deltaSession) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(SESSION_VALUE, String.valueOf(deltaSession));
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FT_SESSION, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoadTime(Activity activity, long deltaTime) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("TIME_VALUE", String.valueOf(deltaTime));
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FT_LOADTIME, map);
            Preference.remove((Context)activity, "start_session");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackingLogout(Activity activity) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_EVENT_LOGOUT, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceStarted(Activity activity) {
        try {
            String gameVersionName = Utils.getGameVersion((Context)activity);
            String gameVersionCode = Utils.getGameVersionCode((Context)activity);
            String versionsave = Preference.getString((Context)activity, "GAME_VERSION");
            if (!versionsave.equals(gameVersionCode)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("version name", gameVersionName);
                map.put("version code", gameVersionCode);
                this.trackEvent((Context)activity, TRACK_DOWNLOAD_RES_STARTED, map);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_DOWNLOAD_RES_STARTED, map);
            } else {
                Log.d((String)this.TAG, (String)"trackDownloadResourceStarted dont call because it is same version");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceFinished(Activity activity) {
        String gameVersionName = Utils.getGameVersion((Context)activity);
        String gameVersionCode = Utils.getGameVersionCode((Context)activity);
        String versionsave = Preference.getString((Context)activity, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            this.trackEvent((Context)activity, TRACK_DOWNLOAD_RES_FINISHED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_DOWNLOAD_RES_FINISHED, map);
        } else {
            Log.d((String)this.TAG, (String)"trackDownloadResourceFinished dont call because it is same version");
        }
        Preference.save((Context)activity, "GAME_VERSION", gameVersionCode);
    }

    public void trackDownloadResourceFailed(Context context) {
        String gameVersionName = Utils.getGameVersion(context);
        String gameVersionCode = Utils.getGameVersionCode(context);
        String versionsave = Preference.getString(context, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            this.trackEvent(context, TRACK_DOWNLOAD_RES_FAILED, map);
        } else {
            Log.d((String)this.TAG, (String)"trackDownloadResourceFailed dont call because it is same version");
        }
    }

    public void trackStartTutorial(Activity activity) {
        this.trackEvent((Context)activity, TRACK_START_TUTORIAL, null);
    }

    public void trackFinishTutorial(Activity activity) {
        this.trackEvent((Context)activity, TRACK_FINISH_TUTORIAL, null);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FINISH_TUTORIAL, null);
    }

    public void trackCreateCharactor(Activity activity, String roleID, String areaID) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            this.trackEvent((Context)activity, TRACK_CHARACTOR_CREATED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_CHARACTOR_CREATED, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackReachALevel(Activity activity, String roleID, String areaID, String level) {
        Log.d((String)this.TAG, (String)"trackReachALevel: ");
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("level", level);
            this.trackEvent((Context)activity, TRACK_REACH_A_LEVEL, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_REACH_A_LEVEL, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String levelTracking = null;
        try {
            if (GameConfigManager.getInstance() != null && GameConfigManager.getInstance().getGameConfig() != null && GameConfigManager.getInstance().getGameConfig().getLevel() != null) {
                levelTracking = GameConfigManager.getInstance().getGameConfig().getLevel();
            }
            Log.i((String)this.TAG, (String)("trackLevelPlatform: " + levelTracking));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (levelTracking != null) {
            String[] arrLevelTrackingPlf;
            for (String levelTrack : arrLevelTrackingPlf = levelTracking.split(",")) {
                try {
                    if (Preference.getBoolean((Context)activity, TRACK_LEVEL_PLATFORM + levelTrack, false) || Integer.parseInt(level) < Integer.parseInt(levelTrack)) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("LEVEL", levelTrack + "");
                    this.trackEvent((Context)activity, TRACK_LEVEL_PLATFORM, map);
                    if (Integer.parseInt(level) >= Integer.parseInt(arrLevelTrackingPlf[2])) {
                        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LEVEL_ACHIEVED_C, map);
                    } else if (Integer.parseInt(level) >= Integer.parseInt(arrLevelTrackingPlf[1])) {
                        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LEVEL_ACHIEVED_B, map);
                    } else if (Integer.parseInt(level) >= Integer.parseInt(arrLevelTrackingPlf[0])) {
                        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LEVEL_ACHIEVED_A, map);
                    } else {
                        Log.i((String)this.TAG, (String)"Do something");
                    }
                    map.clear();
                    Preference.save((Context)activity, TRACK_LEVEL_PLATFORM + levelTrack, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getAppsflyerId(Context context) {
        return AppsFlyerLib.getInstance().getAppsFlyerUID(context);
    }

    public void startSession(Application application) {
        long startSession = System.currentTimeMillis();
        Preference.save((Context)application, "start_session", startSession);
    }
}

