/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.js;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.facebook.AccessToken;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.kajime.libtsy.R;
import com.kajime.libtsy.api.PostTask;
import com.kajime.libtsy.component.EventClientManager;
import com.kajime.libtsy.component.FacebookManager;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.component.GoogleAuthManager;
import com.kajime.libtsy.gui.LibraryHaveBackButtonFragment;
import com.kajime.libtsy.gui.LibraryWebFragment;
import com.kajime.libtsy.model.MAccessToken;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.LibAppsflyerUtils;
import com.kajime.libtsy.utils.Preference;
import com.kajime.libtsy.utils.Res;
import com.kajime.libtsy.utils.Utils;
import java.util.HashMap;
import java.util.Set;
import org.json.JSONObject;

final class CmdLogin {
    private static final String TAG = CmdLogin.class.getSimpleName();
    private static CmdLogin INSTANCE;

    private CmdLogin() {
    }

    public static CmdLogin getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdLogin();
        }
        return INSTANCE;
    }

    void vaosingtc(final Activity activity, LibraryWebFragment webFragment, String params) {
        try {
            JSONObject json = new JSONObject(params);
            String user = json.getString("User");
            JSONObject jsonUser = new JSONObject(user);
            int is_register = 0;
            if (jsonUser.has("is_register")) {
                is_register = jsonUser.getInt("is_register");
            }
            String register_name = "";
            if (jsonUser.has("register_name")) {
                register_name = jsonUser.getString("register_name");
            }
            Log.i((String)TAG, (String)("vaosingtc :" + is_register + " , " + register_name));
            if (is_register == 1) {
                LibAppsflyerUtils.getInstance().trackRegisterSuccess(activity, register_name);
            } else {
                LibAppsflyerUtils.getInstance().trackLoginSuccessFromWeb(activity, register_name);
            }
            Utils.hideLoading();
            final MAccessToken accessToken = MAccessToken.parse(params);
            GameConfigManager.getInstance().setAccessToken(accessToken.getToken());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    EventClientManager.getInstance((Context)activity).setMaxthoongbaos(accessToken.getToken());
                }
            }).start();
            Intent intent = new Intent("com.kajime.libtsy.broadcast");
            intent.putExtra("category", "login");
            LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void vaosignKhach(final Activity activity, LibraryWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)"vaosignKhach");
        try {
            Utils.showLoading(activity, Res.string((Context)activity, R.string.logging_in));
            String mac_address = DeviceUtils.getUniqueDeviceID((Context)activity);
            String key = Utils.getSHACheckSum(mac_address + "abc");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("TYPE_LOGIN", "Login PlayNow");
            LibAppsflyerUtils.getInstance().trackLoginClick(activity, "ft_login_clicked", map);
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put("mac_address", mac_address);
            postParams.put("key", key);
            webFragment.postUrlWithMobHeaders(Constants.URL_RECEIVE_MAC_ADDRESS, postParams, new PostTask.Callback(){

                @Override
                public void onSuccess(String response) {
                    Utils.hideLoading();
                    if (Preference.getInt((Context)activity, "register_play_now", 0) == 0) {
                        LibAppsflyerUtils.getInstance().trackRegisterSuccess(activity, "play_now");
                        Preference.save((Context)activity, "register_play_now", 1);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    e.printStackTrace();
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
        }
    }

    void mobLoginFacebook(final Activity activity, final LibraryWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)("vaofbnhanh:" + params));
        Utils.showLoading(activity, "", Res.string((Context)activity, R.string.connecting_facebook), false);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TYPE_LOGIN", "Login FB");
        LibAppsflyerUtils.getInstance().trackLoginClick(activity, "ft_login_clicked", map);
        FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback(){

            @Override
            public void onSuccess(AccessToken accessToken, Set<String> recentlyGrantedPermissions, Set<String> recentlyDeniedPermissions) {
                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("access_token", accessToken.getToken());
                    webFragment.postUrlWithMobHeaders(Constants.URL_RECEIVE_ACCESS_TOKEN, postParams, new PostTask.Callback(){

                        @Override
                        public void onSuccess(String response) {
                            Utils.hideLoading();
                            if (Preference.getInt((Context)activity, "register_facebook", 0) == 0) {
                                LibAppsflyerUtils.getInstance().trackRegisterSuccess(activity, "facebook_login");
                                Preference.save((Context)activity, "register_facebook", 1);
                            }
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            Utils.hideLoading();
                        }
                    });
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Error: " + e.getMessage()));
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                    Utils.hideLoading();
                }
            }

            @Override
            public void onCancel() {
                Utils.hideLoading();
            }

            @Override
            public void onError(Throwable t) {
                Log.e((String)TAG, (String)("Error: " + t.getMessage()));
                Utils.hideLoading();
                CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
            }
        });
    }

    void mobUpgradeFacebook(final Activity activity, final LibraryWebFragment webFragment, final LibraryHaveBackButtonFragment dialogSocialFragment, String params) {
        Log.i((String)TAG, (String)("nangcapMatSach:" + params));
        Utils.showLoading(activity, Res.string((Context)activity, R.string.connecting_facebook));
        FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback(){

            @Override
            public void onSuccess(AccessToken accessToken, Set<String> recentlyGrantedPermissions, Set<String> recentlyDeniedPermissions) {
                try {
                    Utils.hideLoading();
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("token", accessToken.getToken());
                    if (dialogSocialFragment != null) {
                        dialogSocialFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams, null);
                        dialogSocialFragment.dismiss();
                    } else if (webFragment != null) {
                        webFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
                    }
                }
                catch (Exception e) {
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                }
            }

            @Override
            public void onCancel() {
                Utils.hideLoading();
            }

            @Override
            public void onError(Throwable t) {
                Utils.hideLoading();
            }
        });
    }

    void mobLoginGooglePlay(final Activity activity, final LibraryWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)"mobLoginGooglePlay");
        if (!Utils.isOnline((Context)activity)) {
            this.handleException(activity, Res.string((Context)activity, R.string.connection_lost));
            return;
        }
        if (!GoogleAuthManager.getInstance().isGoogleServiceAvailable(activity)) {
            Log.d((String)TAG, (String)"Google Play Service is out of date. Request update...");
            return;
        }
        Utils.showLoading(activity, "", Res.string((Context)activity, R.string.connecting_google_play), true);
        GoogleAuthManager.getInstance().login(activity, new GoogleAuthManager.GooglePlusResultCallback(){

            @Override
            public void onLoginSuccess(GoogleSignInAccount account, String mToken) {
                Log.d((String)TAG, (String)("Google Token: " + mToken));
                try {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("TYPE_LOGIN", "Login PlayNow");
                    LibAppsflyerUtils.getInstance().trackLoginClick(activity, "ft_login_clicked", map);
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("id_token", mToken);
                    webFragment.postUrlWithMobHeaders(Constants.URL_LOGIN_GOOGLE_ACCOUNT, postParams, new PostTask.Callback(){

                        @Override
                        public void onSuccess(String response) {
                            Log.d((String)TAG, (String)"Google Login Success");
                            CmdLogin.this.getFullResponse(response);
                            Utils.hideLoading();
                            if (Preference.getInt((Context)activity, "register_google_signin", 0) == 0) {
                                LibAppsflyerUtils.getInstance().trackRegisterSuccess(activity, "google_signin");
                                Preference.save((Context)activity, "register_google_signin", 1);
                            }
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            Log.wtf((String)"onFailure", (String)e.getLocalizedMessage());
                            Utils.hideLoading();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                    e.printStackTrace();
                    Utils.hideLoading();
                }
                Log.wtf((String)"mobLoginGooglePlay", (String)("onLoginSuccess: Token: " + mToken + " Email: " + account.getEmail()));
            }

            @Override
            public void onLoginError(String mess) {
                Log.e((String)TAG, (String)"Sign in google error");
                if (!TextUtils.isEmpty((CharSequence)mess)) {
                    CmdLogin.this.handleException(activity, mess);
                }
                Utils.hideLoading();
            }
        });
    }

    private void getFullResponse(String sb) {
        try {
            if (sb.length() > 4000) {
                Log.wtf((String)"onResponse", (String)("sb.length = " + sb.length()));
                int chunkCount = sb.length() / 4000;
                for (int i = 0; i <= chunkCount; ++i) {
                    int max = 4000 * (i + 1);
                    if (max >= sb.length()) {
                        Log.wtf((String)"onResponse", (String)("chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i)));
                        continue;
                    }
                    Log.wtf((String)"onResponse", (String)("chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i, max)));
                }
            } else {
                Log.wtf((String)TAG, (String)sb.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void mobLoginGoogleAccount(Activity activity, LibraryWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)"mobLoginGoogleAccount");
    }

    private void handleException(final Activity activity, final String message) {
        Utils.hideLoading();
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)activity, (CharSequence)message, (int)1).show();
            }
        });
        Intent intent = new Intent("com.kajime.libtsy.broadcast");
        intent.putExtra("category", "login");
        intent.putExtra("status", false);
        intent.putExtra("message", message);
        LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
    }
}

