/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.js;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Html;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.widget.Toast;
import com.facebook.share.widget.GameRequestDialog;
import com.kajime.libtsy.LibrarySDK;
import com.kajime.libtsy.R;
import com.kajime.libtsy.api.PostTask;
import com.kajime.libtsy.api.UploadBitmapTask;
import com.kajime.libtsy.component.FacebookManager;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.gui.LibraryWebFragment;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.LibAppsflyerUtils;
import com.kajime.libtsy.utils.PermissionUtils;
import com.kajime.libtsy.utils.Res;
import com.kajime.libtsy.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class CmdDashboard {
    private static final String TAG = CmdDashboard.class.getSimpleName();
    private static CmdDashboard INSTANCE;
    private LibraryWebFragment webFragment;
    private HashMap<String, Bitmap> issuePhotos;

    private CmdDashboard() {
    }

    public static CmdDashboard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdDashboard();
        }
        return INSTANCE;
    }

    public void handleResult(Activity activity, int requestCode, int resultCode, Intent data) {
        try {
            switch (requestCode) {
                case 20002: {
                    Uri selectImageUri = data.getData();
                    Bitmap bitmap = this.getCompressedBitmapFromUri(selectImageUri);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
                    byte[] byteArray = byteArrayOutputStream.toByteArray();
                    String encoded = Base64.encodeToString((byte[])byteArray, (int)0);
                    String key = "img" + Calendar.getInstance().getTimeInMillis();
                    String jsFunction = String.format("getImageData('%s', '%s');", encoded, key);
                    Log.d((String)TAG, (String)("js function: " + jsFunction));
                    this.webFragment.invokeJavascript(jsFunction);
                    if (this.issuePhotos == null) {
                        this.issuePhotos = new HashMap();
                    }
                    this.issuePhotos.put(key, bitmap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void contactView(Activity activity, String params) {
        Log.i((String)TAG, (String)("contactView:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String support_email = obj.getString("support_email");
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("mailto:" + support_email)));
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void guithutinh(Activity activity, String params) {
        Log.i((String)TAG, (String)("guithutinh:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String body = obj.getString("body");
            Intent smsVIntent = new Intent("android.intent.action.VIEW");
            smsVIntent.setType("vnd.android-dir/mms-sms");
            smsVIntent.putExtra("sms_body", body);
            activity.startActivity(smsVIntent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void guithumail(Activity activity, String params) {
        Log.i((String)TAG, (String)("guithumail:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String subject = obj.getString("subject");
            String body = obj.getString("body");
            Intent email = new Intent("android.intent.action.SEND", Uri.parse((String)"mailto:"));
            email.setType("text/plain");
            email.putExtra("android.intent.extra.EMAIL", "");
            email.putExtra("android.intent.extra.SUBJECT", subject);
            email.putExtra("android.intent.extra.TEXT", (CharSequence)Html.fromHtml((String)body));
            activity.startActivity(Intent.createChooser((Intent)email, (CharSequence)"Choose an email client from..."));
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void moimatsach(final Activity activity, String params) {
        Log.i((String)TAG, (String)("moimatsach:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            final Activity a = activity;
            final String url = callbackUrl;
            FacebookManager.InviteContent content = new FacebookManager.InviteContent();
            if (obj.has("applinkurl")) {
                content.setApplinkUrl(obj.getString("applinkurl"));
            }
            if (obj.has("previewimageurl")) {
                content.setPreviewImageUrl(obj.getString("previewimageurl"));
            }
            FacebookManager.getInstance().invite(activity, content, new FacebookManager.InviteCallback(){

                @Override
                public void onSuccess(Bundle data) {
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        new PostTask(activity, url, null, false, new PostTask.Callback(){

                            @Override
                            public void onSuccess(String response) {
                                Intent intent = new Intent("com.kajime.libtsy.broadcast");
                                intent.putExtra("category", "reload");
                                LocalBroadcastManager.getInstance((Context)a).sendBroadcast(intent);
                            }

                            @Override
                            public void onFailure(Throwable e) {
                            }
                        }).execute(new Void[0]);
                    }
                }

                @Override
                public void onError(Throwable t) {
                    Toast.makeText((Context)a, (CharSequence)Res.string((Context)a, R.string.something_went_wrong), (int)1).show();
                }

                @Override
                public void onCancel() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void mobAppShare(final Activity activity, String params) {
        Log.i((String)TAG, (String)("mobAppShare:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            boolean isSocial = false;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            if (obj.has("isSocial")) {
                isSocial = obj.getBoolean("isSocial");
            }
            final Activity a = activity;
            final String url = callbackUrl;
            FacebookManager.ShareContent shareContent = new FacebookManager.ShareContent();
            if (obj.has("url")) {
                shareContent.setContentUrl(obj.getString("url"));
            }
            if (obj.has("content_title")) {
                shareContent.setContentTitle(obj.getString("content_title"));
            }
            if (obj.has("content")) {
                shareContent.setContentDescription(obj.getString("content"));
            }
            final boolean hasSocial = isSocial;
            FacebookManager.getInstance().shareLink(activity, shareContent, new FacebookManager.ShareCallback(){

                @Override
                public void onSuccess(String postId) {
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        new PostTask(activity, url, null, false, new PostTask.Callback(){

                            @Override
                            public void onSuccess(String response) {
                                if (!hasSocial) {
                                    Intent intent = new Intent("com.kajime.libtsy.broadcast");
                                    intent.putExtra("category", "reload");
                                    LocalBroadcastManager.getInstance((Context)a).sendBroadcast(intent);
                                }
                            }

                            @Override
                            public void onFailure(Throwable e) {
                            }
                        }).execute(new Void[0]);
                    }
                }

                @Override
                public void onError(Throwable t) {
                    Toast.makeText((Context)a, (CharSequence)Res.string((Context)a, R.string.something_went_wrong), (int)1).show();
                }

                @Override
                public void onCancel() {
                    Toast.makeText((Context)a, (CharSequence)"Cancel", (int)0).show();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void motrduyen(Activity activity, String params) {
        Log.i((String)TAG, (String)("motrduyen:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String url = obj.getString("url");
            this.motrduyen(activity, Uri.parse((String)url));
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    private void motrduyen(Activity activity, Uri uri) {
        Log.i((String)TAG, (String)("motrduyen:" + uri));
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void moClbmatsach(Activity activity, String params) {
        Log.i((String)TAG, (String)("moClbmatsach:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String pageid = obj.getString("pageid");
            String callbackUrl = null;
            boolean isSocial = false;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            if (obj.has("isSocial")) {
                isSocial = obj.getBoolean("isSocial");
            }
            try {
                activity.getPackageManager().getPackageInfo("com.facebook.katana", 0);
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("fb://page/" + pageid)));
                activity.startActivity(intent);
            }
            catch (Exception e) {
                this.motrduyen(activity, Uri.parse((String)("http://m.facebook.com/profile.php?id=" + pageid)));
            }
            if (!TextUtils.isEmpty((CharSequence)callbackUrl)) {
                final Activity a = activity;
                if (!Utils.hasDomain(callbackUrl)) {
                    callbackUrl = Constants.BASE_URL_DOMAIN + callbackUrl;
                }
                final boolean hasSocial = isSocial;
                new PostTask(activity, callbackUrl, null, false, new PostTask.Callback(){

                    @Override
                    public void onSuccess(String response) {
                        if (!hasSocial) {
                            Intent intent = new Intent("com.kajime.libtsy.broadcast");
                            intent.putExtra("category", "reload");
                            LocalBroadcastManager.getInstance((Context)a).sendBroadcast(intent);
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                    }
                }).execute(new Void[0]);
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void moNhommatsach(Activity activity, String params) {
        Log.i((String)TAG, (String)("moNhommatsach:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String groupid = obj.getString("groupid");
            try {
                activity.getPackageManager().getPackageInfo("com.facebook.katana", 0);
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("fb://group/" + groupid)));
                activity.startActivity(intent);
            }
            catch (Exception e) {
                this.motrduyen(activity, Uri.parse((String)("http://facebook.com/groups/" + groupid)));
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void momodal(Activity activity, String params) {
        Log.i((String)TAG, (String)("momodal:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent("com.kajime.libtsy.broadcast");
            intent.putExtra("category", "dashboard");
            intent.putExtra("urls", "[{'action':'" + obj.getString("url") + "'}]");
            LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).sendBroadcast(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void danhbadt(Activity activity, String params) {
        Log.i((String)TAG, (String)("danhbadt:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent("android.intent.action.DIAL");
            intent.setData(Uri.parse((String)("tel:" + obj.getString("number"))));
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void fuzhidaoClip(Activity activity, String params) {
        try {
            int sdk = Build.VERSION.SDK_INT;
            JSONObject obj = new JSONObject(params);
            String data = obj.getString("data").trim();
            if (sdk < 11) {
                android.text.ClipboardManager clipboard = (android.text.ClipboardManager)activity.getSystemService("clipboard");
                clipboard.setText((CharSequence)data);
            } else {
                ClipboardManager clipboard = (ClipboardManager)activity.getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"clipboard", (CharSequence)data);
                clipboard.setPrimaryClip(clip);
            }
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.copied), (int)1).show();
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void naWenti(Activity activity, LibraryWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)("naWenti:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            long issueId = Long.parseLong(obj.getString("id"));
            if (issueId != 0L) {
                if (this.issuePhotos != null) {
                    for (Map.Entry<String, Bitmap> entry : this.issuePhotos.entrySet()) {
                        String key = entry.getKey();
                        Bitmap bitmap = entry.getValue();
                        new UploadBitmapTask(Constants.URL_UPLOAD_ISSUE_IMAGE + "?id=" + issueId, bitmap, activity).execute(new Void[0]);
                    }
                }
                this.issuePhotos = null;
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void shandiaoTupian(Activity activity, LibraryWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)("shandiaoTupian:" + params));
        if (this.issuePhotos == null) {
            return;
        }
        if (this.issuePhotos.isEmpty()) {
            return;
        }
        try {
            JSONObject obj = new JSONObject(params);
            String index = obj.optString("index");
            if (this.issuePhotos.containsKey(index)) {
                this.issuePhotos.remove(index);
            }
            Log.d((String)TAG, (String)("issue photo size:" + this.issuePhotos.size()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void clearImageData(Activity activity) {
        Log.d((String)TAG, (String)"clearImageData");
        if (this.issuePhotos == null) {
            return;
        }
        if (this.issuePhotos.isEmpty()) {
            return;
        }
        this.issuePhotos.clear();
    }

    public void mSelectImage(Activity activity, LibraryWebFragment webFragment, String params) {
        try {
            Log.d((String)TAG, (String)("mSelectImage: " + params));
            if (this.issuePhotos != null && this.issuePhotos.size() > 2) {
                AlertDialog.Builder alert = new AlertDialog.Builder((Context)activity);
                alert.setMessage((CharSequence)activity.getString(R.string.alert_image_validate));
                alert.setNegativeButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog = alert.create();
                dialog.setCancelable(false);
                dialog.show();
                return;
            }
            this.webFragment = webFragment;
            boolean grantedReadStorage = PermissionUtils.hasPermission("android.permission.READ_EXTERNAL_STORAGE");
            if (!grantedReadStorage) {
                PermissionUtils.requestPermission(LibrarySDK.currentActivity, "android.permission.READ_EXTERNAL_STORAGE");
            }
            if (grantedReadStorage) {
                Intent intent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                intent.setType("image/*");
                activity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Choose photo"), 20002);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Bitmap getCompressedBitmapFromUri(Uri imageUri) {
        Bitmap bitmap = null;
        try {
            String[] projection = new String[]{"_data"};
            Cursor cursor = LibrarySDK.currentActivity.managedQuery(imageUri, projection, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String selectImagePath = cursor.getString(column_index);
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            o.inSampleSize = 6;
            BitmapFactory.decodeFile((String)selectImagePath, (BitmapFactory.Options)o);
            int REQUIRED_SIZE = 75;
            int scale = 1;
            while (o.outWidth / scale / 2 >= 75 && o.outHeight / scale / 2 >= 75) {
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            bitmap = BitmapFactory.decodeFile((String)selectImagePath, (BitmapFactory.Options)o2);
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(-1);
        }
        return bitmap;
    }

    public void chonbanmatsach(final Activity activity, String params) {
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            final String url = callbackUrl;
            FacebookManager.InviteGameContent parameter = new FacebookManager.InviteGameContent();
            parameter.setTitle("Invite friend play game");
            parameter.setMessage("Play game with me");
            FacebookManager.getInstance().inviteGameRequest(activity, parameter, new FacebookManager.InviteGameCallback(){

                @Override
                public void onSuccess(GameRequestDialog.Result data) {
                    Log.i((String)TAG, (String)"invite onSuccess");
                    List list = data.getRequestRecipients();
                    HashMap<String, String> maps = new HashMap<String, String>();
                    String str = "";
                    for (int i = 0; i < list.size(); ++i) {
                        str = str + (String)list.get(i) + ",";
                    }
                    Log.d((String)"STR", (String)("str:" + str));
                    String id2 = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
                    maps.put("account_id", id2);
                    maps.put("fbid_friends", str);
                    new PostTask(activity, url, maps, true, true, id2, new PostTask.Callback(){

                        @Override
                        public void onSuccess(String response) {
                        }

                        @Override
                        public void onFailure(Throwable e) {
                        }
                    }).execute(new Void[0]);
                }

                @Override
                public void onError(Throwable t) {
                    Log.i((String)TAG, (String)"invite onError");
                }

                @Override
                public void onCancel() {
                    Log.i((String)TAG, (String)"invite onCancel");
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackingFromWeb(Activity activity, String params) {
        try {
            Log.d((String)TAG, (String)("label : params - " + params));
            JSONObject json = new JSONObject(params);
            String label = json.getString("label");
            String value = json.getString("value");
            JSONObject jsonChild = new JSONObject(value);
            String name = jsonChild.getString("name");
            Log.d((String)TAG, (String)("label :" + label + " , name : " + name));
            LibAppsflyerUtils.getInstance().trackPayment_RegisterClick(activity, label, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void modanhba(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenContact:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String support_email = obj.getString("support_email");
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("mailto:" + support_email)));
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)"C\u00f3 l\u1ed7i x\u1ea3y ra", (int)1).show();
        }
    }
}

