/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.gui;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.kajime.libtsy.model.MPermission;
import java.util.ArrayList;

public class PermissionFragment
extends DialogFragment {
    public static final String PERMISSIONS = "permissions";
    public static final int RESULT_REQUEST_PERMISSIONS = 21;
    private static final int REQUEST_CODE_PERMISSIONS = 20001;

    public static PermissionFragment newInstance(String[] permissions) {
        PermissionFragment fr = new PermissionFragment();
        Bundle args = new Bundle();
        args.putStringArray(PERMISSIONS, permissions);
        fr.setArguments(args);
        return fr;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().requestFeature(1);
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        return dialog;
    }

    @TargetApi(value=23)
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            String[] permisisons = args.getStringArray(PERMISSIONS);
            this.requestPermissions(permisisons, 20001);
        } else {
            this.dismiss();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 20001: {
                try {
                    ArrayList<MPermission> result = new ArrayList<MPermission>();
                    for (int i = 0; i < grantResults.length; ++i) {
                        String permission2 = permissions[i];
                        int granted = grantResults[i];
                        MPermission m = new MPermission(permission2, granted);
                        result.add(m);
                    }
                    Intent intentData = new Intent();
                    intentData.putParcelableArrayListExtra(PERMISSIONS, result);
                    this.dismiss();
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

