/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.gui;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import com.facebook.AccessToken;
import com.kajime.libtsy.R;
import com.kajime.libtsy.api.UpgradeToFacebookTask;
import com.kajime.libtsy.component.EventClientManager;
import com.kajime.libtsy.component.FacebookManager;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.LoginResponse;
import com.kajime.libtsy.model.MAccessToken;
import com.kajime.libtsy.model.UserInfo;
import com.kajime.libtsy.utils.Res;
import com.kajime.libtsy.utils.Utils;
import java.util.Set;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LibraryUpgradeDialog
extends Dialog {
    private Activity activity;
    private TextView txtAlert;
    private TextView txtBonusFacebook;
    private TextView txtBonusEmail;
    private TextView txtBonusInfo;
    private TextView txtConnect;
    private Button btnUpgrade;
    private Button btnRegisterEmail;
    private Button btnUpgradeInfo;
    private Button btnCancel;
    private boolean isShowUpgrade = false;
    long startTime = 0L;
    Handler timerHandler = new Handler();
    Runnable timerRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                long millis = System.currentTimeMillis() - LibraryUpgradeDialog.this.startTime;
                int seconds = (int)(millis / 1000L);
                if ((seconds %= 60) <= 10) {
                    if (LibraryUpgradeDialog.this.btnCancel != null) {
                        LibraryUpgradeDialog.this.btnCancel.setText((CharSequence)(Res.string((Context)LibraryUpgradeDialog.this.activity, R.string.remind_me) + " (" + (10 - seconds) + "s)"));
                    }
                    LibraryUpgradeDialog.this.timerHandler.postDelayed((Runnable)this, 1000L);
                } else if (LibraryUpgradeDialog.this.isShowing()) {
                    LibraryUpgradeDialog.this.mOnCancelClickListener.onClick((View)LibraryUpgradeDialog.this.btnCancel);
                    LibraryUpgradeDialog.this.dismiss();
                    LibraryUpgradeDialog.this.isShowUpgrade = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    View.OnClickListener mOnCancelClickListener;
    private FacebookManager.LoginCallback mFacebookCallback = new FacebookManager.LoginCallback(){

        @Override
        public void onSuccess(AccessToken accessToken, Set<String> recentlyGrantedPermissions, Set<String> recentlyDeniedPermissions) {
            try {
                new UpgradeToFacebookTask(accessToken.getToken(), new Callback<LoginResponse>(){

                    public void onFailure(Call<LoginResponse> call, Throwable e) {
                        LibraryUpgradeDialog.this.handleException(LibraryUpgradeDialog.this.activity, e.getMessage());
                        try {
                            LibraryUpgradeDialog.this.startTime = System.currentTimeMillis();
                            LibraryUpgradeDialog.this.timerHandler.postDelayed(LibraryUpgradeDialog.this.timerRunnable, 500L);
                        }
                        catch (Exception e1) {
                            e.printStackTrace();
                        }
                    }

                    public void onResponse(Call<LoginResponse> call, Response<LoginResponse> response) {
                        try {
                            LoginResponse loginResponse = (LoginResponse)response.body();
                            if (loginResponse.getError() != 0) {
                                LibraryUpgradeDialog.this.handleException(LibraryUpgradeDialog.this.activity, loginResponse.getMessage());
                                try {
                                    LibraryUpgradeDialog.this.startTime = System.currentTimeMillis();
                                    LibraryUpgradeDialog.this.timerHandler.postDelayed(LibraryUpgradeDialog.this.timerRunnable, 500L);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } else {
                                final MAccessToken accessToken = loginResponse.getAccessToken();
                                GameConfigManager.getInstance().setAccessToken(accessToken.getToken());
                                new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        EventClientManager.getInstance((Context)LibraryUpgradeDialog.this.activity).setMaxthoongbaos(accessToken.getToken());
                                    }
                                }).start();
                                Intent intent = new Intent("com.kajime.libtsy.broadcast");
                                intent.putExtra("category", "login");
                                LocalBroadcastManager.getInstance((Context)LibraryUpgradeDialog.this.activity).sendBroadcast(intent);
                                LibraryUpgradeDialog.this.dismiss();
                                LibraryUpgradeDialog.this.isShowUpgrade = false;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).execute(new Void[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onError(Throwable t) {
            Utils.hideLoading();
            try {
                LibraryUpgradeDialog.this.startTime = System.currentTimeMillis();
                LibraryUpgradeDialog.this.timerHandler.postDelayed(LibraryUpgradeDialog.this.timerRunnable, 500L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onCancel() {
            Utils.hideLoading();
            try {
                LibraryUpgradeDialog.this.startTime = System.currentTimeMillis();
                LibraryUpgradeDialog.this.timerHandler.postDelayed(LibraryUpgradeDialog.this.timerRunnable, 500L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public LibraryUpgradeDialog(Activity a) {
        super((Context)a, R.style.MobUpgradeDialog);
        this.activity = a;
    }

    public LibraryUpgradeDialog(Activity a, int themeResId) {
        super((Context)a, R.style.MobUpgradeDialog);
        this.activity = a;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.dialog_upgrade);
        Window dialog_window = this.getWindow();
        dialog_window.setFlags(1024, 1024);
        this.btnUpgrade = (Button)this.findViewById(R.id.btn_upgrade_facebook);
        this.btnRegisterEmail = (Button)this.findViewById(R.id.btn_register_email);
        this.btnUpgradeInfo = (Button)this.findViewById(R.id.btn_upgrade_info);
        this.btnCancel = (Button)this.findViewById(R.id.btn_cancel);
        this.txtAlert = (TextView)this.findViewById(R.id.txt_alert);
        this.txtConnect = (TextView)this.findViewById(R.id.txt_connect_with_facebook_tip);
        this.txtBonusFacebook = (TextView)this.findViewById(R.id.txt_mobcoin_facebook);
        this.txtBonusEmail = (TextView)this.findViewById(R.id.txt_mobcoin_email);
        this.txtBonusInfo = (TextView)this.findViewById(R.id.txt_mobcoin_info);
        this.txtAlert.setText((CharSequence)Res.string((Context)this.activity, R.string.notice));
        this.btnRegisterEmail.setText((CharSequence)Res.string((Context)this.activity, R.string.bind_account));
        this.btnUpgradeInfo.setText((CharSequence)Res.string((Context)this.activity, R.string.complete_now));
        this.btnCancel.setText((CharSequence)Res.string((Context)this.activity, R.string.remind_me));
        try {
            UserInfo userInfo = GameConfigManager.getInstance().getUserInfo();
            UserInfo.UserDaily userDaily = null;
            if (userInfo != null) {
                userDaily = userInfo.getUserDaily();
            }
            if (userDaily == null) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)userDaily.getTooltip())) {
                this.txtConnect.setVisibility(0);
                this.txtConnect.setText((CharSequence)userDaily.getTooltip());
            } else {
                this.txtConnect.setVisibility(8);
            }
            this.btnCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    LibraryUpgradeDialog.this.dismiss();
                    LibraryUpgradeDialog.this.isShowUpgrade = false;
                    if (LibraryUpgradeDialog.this.mOnCancelClickListener != null) {
                        LibraryUpgradeDialog.this.mOnCancelClickListener.onClick(v);
                    }
                }
            });
            int typeHello = userDaily.getTypeHello();
            if (typeHello == 2) {
                if (userDaily.getBonusFacebook() > 0) {
                    this.txtBonusFacebook.setText((CharSequence)("+" + userDaily.getBonusFacebook()));
                    this.txtBonusFacebook.setVisibility(0);
                }
                this.btnUpgrade.setVisibility(0);
                this.btnUpgrade.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (LibraryUpgradeDialog.this.timerHandler != null) {
                            LibraryUpgradeDialog.this.timerHandler.removeCallbacks(LibraryUpgradeDialog.this.timerRunnable);
                            LibraryUpgradeDialog.this.btnCancel.setText((CharSequence)Res.string((Context)LibraryUpgradeDialog.this.activity, R.string.remind_me));
                        }
                        Utils.showLoading(LibraryUpgradeDialog.this.activity, Res.string((Context)LibraryUpgradeDialog.this.activity, R.string.connecting_facebook));
                        FacebookManager.getInstance().login(LibraryUpgradeDialog.this.activity, LibraryUpgradeDialog.this.mFacebookCallback);
                    }
                });
            } else if (typeHello == 3) {
                if (userDaily.getBonusInfo() > 0) {
                    this.txtBonusInfo.setText((CharSequence)("+" + userDaily.getBonusInfo()));
                    this.txtBonusInfo.setVisibility(0);
                }
                final String fUrl = userDaily.getUpdateInfoDetails().getUrl();
                final int fType = userDaily.getUpdateInfoDetails().getType();
                this.btnUpgradeInfo.setVisibility(0);
                this.btnUpgradeInfo.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        LibraryUpgradeDialog.this.dismiss();
                        LibraryUpgradeDialog.this.isShowUpgrade = false;
                        Intent i = new Intent("com.kajime.libtsy.broadcast");
                        i.putExtra("category", "LibraryUpgradeDialog.btnUpgradeInfo");
                        LocalBroadcastManager.getInstance((Context)LibraryUpgradeDialog.this.activity).sendBroadcast(i);
                        if (fType == 2) {
                            Intent intent = new Intent("com.kajime.libtsy.broadcast");
                            intent.putExtra("category", "motrduyen");
                            intent.putExtra("data", "{url:'" + fUrl + "'}");
                            LocalBroadcastManager.getInstance((Context)LibraryUpgradeDialog.this.activity.getApplicationContext()).sendBroadcast(intent);
                        } else if (fType == 1) {
                            Intent intent = new Intent("com.kajime.libtsy.broadcast");
                            intent.putExtra("category", "dashboard");
                            intent.putExtra("data", "{items:[{action:'" + fUrl + "'}], autohide_header_bar:false, enable_side_menu:false}");
                            LocalBroadcastManager.getInstance((Context)LibraryUpgradeDialog.this.activity.getApplicationContext()).sendBroadcast(intent);
                        }
                    }
                });
            } else if (typeHello == 4) {
                if (userDaily.getBonusFacebook() > 0) {
                    this.txtBonusFacebook.setText((CharSequence)("+" + userDaily.getBonusFacebook()));
                    this.txtBonusFacebook.setVisibility(0);
                }
                if (userDaily.getBonusEmail() > 0) {
                    this.txtBonusEmail.setText((CharSequence)("+" + userDaily.getBonusEmail()));
                    this.txtBonusEmail.setVisibility(0);
                }
                this.btnUpgrade.setVisibility(0);
                this.btnUpgrade.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (LibraryUpgradeDialog.this.timerHandler != null) {
                            LibraryUpgradeDialog.this.timerHandler.removeCallbacks(LibraryUpgradeDialog.this.timerRunnable);
                            LibraryUpgradeDialog.this.btnCancel.setText((CharSequence)Res.string((Context)LibraryUpgradeDialog.this.activity, R.string.remind_me));
                        }
                        Utils.showLoading(LibraryUpgradeDialog.this.activity, Res.string((Context)LibraryUpgradeDialog.this.activity, R.string.connecting_facebook));
                        FacebookManager.getInstance().login(LibraryUpgradeDialog.this.activity, LibraryUpgradeDialog.this.mFacebookCallback);
                    }
                });
                final String fUrl = userDaily.getUpgradeEmailDetails().getUrl();
                final int fType = userDaily.getUpgradeEmailDetails().getType();
                this.btnRegisterEmail.setVisibility(0);
                this.btnRegisterEmail.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        LibraryUpgradeDialog.this.dismiss();
                        LibraryUpgradeDialog.this.isShowUpgrade = false;
                        if (fType == 2) {
                            Intent intent = new Intent("com.kajime.libtsy.broadcast");
                            intent.putExtra("category", "motrduyen");
                            intent.putExtra("data", "{url:'" + fUrl + "'}");
                            LocalBroadcastManager.getInstance((Context)LibraryUpgradeDialog.this.activity.getApplicationContext()).sendBroadcast(intent);
                        } else if (fType == 1) {
                            Intent intent = new Intent("com.kajime.libtsy.broadcast");
                            intent.putExtra("category", "dashboard");
                            intent.putExtra("data", "{items:[{action:'" + fUrl + "'}], autohide_header_bar:false, enable_side_menu:false}");
                            LocalBroadcastManager.getInstance((Context)LibraryUpgradeDialog.this.activity.getApplicationContext()).sendBroadcast(intent);
                        }
                    }
                });
            }
            this.setOnShowListener(new DialogInterface.OnShowListener(){

                public void onShow(DialogInterface dialog) {
                    LibraryUpgradeDialog.this.startTime = System.currentTimeMillis();
                    LibraryUpgradeDialog.this.timerHandler.postDelayed(LibraryUpgradeDialog.this.timerRunnable, 500L);
                    Intent intent = new Intent("com.kajime.libtsy.broadcast");
                    intent.putExtra("category", "float_button");
                    intent.putExtra("message", "hide");
                    LocalBroadcastManager.getInstance((Context)LibraryUpgradeDialog.this.activity).sendBroadcast(intent);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnCancelClickListener(View.OnClickListener listener) {
        this.mOnCancelClickListener = listener;
        if (this.btnCancel != null) {
            this.btnCancel.setOnClickListener(listener);
        }
    }

    private void handleException(Activity activity, String message) {
        try {
            Toast.makeText((Context)activity, (CharSequence)message, (int)1).show();
            Utils.hideLoading();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show() {
        try {
            this.isShowUpgrade = true;
            UserInfo userInfo = GameConfigManager.getInstance().getUserInfo();
            if (userInfo != null) {
                super.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isShowUpgrade() {
        return this.isShowUpgrade;
    }
}

