/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.gui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.kajime.libtsy.R;
import com.kajime.libtsy.api.GetPayItemTask;
import com.kajime.libtsy.component.FirebaseAnalyticsManager;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.gui.LibraryActivity;
import com.kajime.libtsy.js.CmdPayment;
import com.kajime.libtsy.model.Game;
import com.kajime.libtsy.model.MItemPayment;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.LibAppsflyerUtils;
import com.kajime.libtsy.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class LibraryPayDialogFragment
extends DialogFragment {
    private static final String TAG = LibraryPayDialogFragment.class.getSimpleName();
    private ImageButton btn_close;
    private ProgressBar progressBar;
    private Button btnReload;
    private GridView gridView;
    private View viewConnectionLost;
    ArrayList<MItemPayment> listItemPay = new ArrayList();
    int col;
    int row;
    private String state = "";
    BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                boolean isClosePayment = intent.getBooleanExtra("extra_close_form_payment", false);
                if (isClosePayment) {
                    LibraryPayDialogFragment.this.closePayment();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public LibraryPayDialogFragment() {
    }

    @SuppressLint(value={"ValidFragment"})
    public LibraryPayDialogFragment(String state) {
        this.state = state;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.payment_dialog_fragment, container, false);
        try {
            this.getDialog().getWindow().setFlags(1024, 1024);
            this.getDialog().requestWindowFeature(1);
            this.btn_close = (ImageButton)rootView.findViewById(R.id.btn_close_pay);
            this.gridView = (GridView)rootView.findViewById(R.id.grid_view_pay);
            this.viewConnectionLost = rootView.findViewById(R.id.layout_connection_lost);
            this.btnReload = (Button)rootView.findViewById(R.id.btn_reload);
            this.progressBar = (ProgressBar)rootView.findViewById(R.id.progressbar_payment_native);
            String columnGrid = GameConfigManager.getInstance().getGameConfig().getP_m().getP_d().getCol();
            this.col = Integer.parseInt(columnGrid);
            String rowGrid = GameConfigManager.getInstance().getGameConfig().getP_m().getP_d().getRow();
            this.row = Integer.parseInt(rowGrid);
            int orientation = this.getResources().getConfiguration().orientation;
            if (orientation == 1) {
                this.gridView.setNumColumns(this.row);
                this.initFormPayment(this.row, this.col);
            }
            if (orientation == 2) {
                this.gridView.setNumColumns(this.col);
                this.initFormPayment(this.col, this.row);
            }
            this.btn_close.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    LibraryPayDialogFragment.this.closePayment();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rootView;
    }

    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this.getActivity().getApplicationContext()).registerReceiver(this.receiver, new IntentFilter("intent_close_form_payment"));
    }

    public void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this.getActivity().getApplicationContext()).unregisterReceiver(this.receiver);
    }

    private void initFormPayment(final int col, final int row) {
        try {
            if (Utils.isOnline((Context)this.getActivity())) {
                this.progressBar.setVisibility(0);
                this.viewConnectionLost.setVisibility(8);
                new GetPayItemTask(this.getActivity(), this.state, new GetPayItemTask.Listener(){

                    @Override
                    public void onSuccess(ArrayList<MItemPayment> listItem) {
                        CmdPayment.getInstance().setState(LibraryPayDialogFragment.this.state);
                        LibraryPayDialogFragment.this.listItemPay = listItem;
                        PayGridViewItem adapter = new PayGridViewItem(LibraryPayDialogFragment.this.getActivity(), LibraryPayDialogFragment.this.listItemPay, col, row);
                        LibraryPayDialogFragment.this.gridView.setAdapter((ListAdapter)adapter);
                        LibAppsflyerUtils.getInstance().trackOpenFormPayment(LibraryPayDialogFragment.this.getActivity());
                    }

                    @Override
                    public void onFailure(Throwable t) {
                    }
                }).execute(new Void[0]);
            } else {
                this.viewConnectionLost.setVisibility(0);
                this.progressBar.setVisibility(8);
                this.btnReload.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int orientation = LibraryPayDialogFragment.this.getResources().getConfiguration().orientation;
                        if (orientation == 1) {
                            LibraryPayDialogFragment.this.initFormPayment(col, row);
                        }
                        if (orientation == 2) {
                            LibraryPayDialogFragment.this.initFormPayment(col, row);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closePayment() {
        LibAppsflyerUtils.getInstance().trackEvent((Context)this.getActivity(), "ft_payment_closed", null);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)this.getActivity(), "ft_payment_closed", null);
        this.dismiss();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, 0x1030010);
    }

    class PayGridViewItem
    extends BaseAdapter {
        private Activity mActivity;
        private ArrayList<MItemPayment> listItemPayment;
        private int col;
        int widthItem;
        int heghtItem;
        int width;
        int height;

        public PayGridViewItem(Activity activity, ArrayList<MItemPayment> listItemPayment, int col, int row) {
            this.mActivity = activity;
            this.listItemPayment = listItemPayment;
            this.width = this.getScreenWidthInPixel((Context)this.mActivity);
            this.height = this.getScreenHeightInPixel((Context)this.mActivity);
            this.widthItem = this.width / col;
            this.heghtItem = this.height / row;
        }

        public int getCount() {
            return this.listItemPayment.size();
        }

        public Object getItem(int position) {
            return this.listItemPayment.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            View view;
            LayoutInflater inflater = (LayoutInflater)this.mActivity.getSystemService("layout_inflater");
            if (convertView == null) {
                view = new View((Context)this.mActivity);
                view = inflater.inflate(R.layout.item_payment, null);
                try {
                    ImageView imgView = (ImageView)view.findViewById(R.id.img_item_pay);
                    Log.d((String)TAG, (String)("width : " + this.widthItem + " , heght: " + this.heghtItem));
                    LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.widthItem, this.heghtItem);
                    imgView.setLayoutParams((ViewGroup.LayoutParams)params);
                    Glide.with((Context)this.mActivity.getApplicationContext()).asBitmap().load(this.listItemPayment.get(position).getUrlPng()).apply(new RequestOptions().diskCacheStrategy(DiskCacheStrategy.ALL).fitCenter()).listener((RequestListener)new RequestListener<Bitmap>(){

                        public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                            return false;
                        }

                        public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource) {
                            if (PayGridViewItem.this.listItemPayment.size() - 1 == position) {
                                LibraryPayDialogFragment.this.progressBar.setVisibility(8);
                            }
                            return false;
                        }
                    }).into(imgView);
                    Game a = GameConfigManager.getInstance().getGameConfig();
                    boolean isSubmit = Boolean.parseBoolean(GameConfigManager.getInstance().getGameConfig().getIsSubmit());
                    if (isSubmit && this.listItemPayment.get(position).getCategoryItem().equals("xx02")) {
                        imgView.setVisibility(8);
                    }
                    imgView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (PayGridViewItem.this.listItemPayment == null) {
                                return;
                            }
                            if (((MItemPayment)PayGridViewItem.this.listItemPayment.get(position)).getCategoryItem().equals("xx01")) {
                                try {
                                    JSONObject json = new JSONObject();
                                    json.put("product_id", (Object)((MItemPayment)PayGridViewItem.this.listItemPayment.get(position)).getProductId());
                                    Log.d((String)TAG, (String)("json:" + json));
                                    CmdPayment.getInstance().khoidongNao(PayGridViewItem.this.mActivity, json.toString());
                                    HashMap<String, Object> eventValue = new HashMap<String, Object>();
                                    eventValue.put("product_id", ((MItemPayment)PayGridViewItem.this.listItemPayment.get(position)).getProductId());
                                    LibAppsflyerUtils.getInstance().trackEvent((Context)LibraryPayDialogFragment.this.getActivity(), "ft_payment_clicked", eventValue);
                                    FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)LibraryPayDialogFragment.this.getActivity(), "ft_payment_clicked", new HashMap<String, Object>(eventValue));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            if (((MItemPayment)PayGridViewItem.this.listItemPayment.get(position)).getCategoryItem().equals("xx02")) {
                                String url = ((MItemPayment)PayGridViewItem.this.listItemPayment.get(position)).getConfig().getUrl();
                                if (LibraryPayDialogFragment.this.state.length() != 0) {
                                    url = url + "?state=" + LibraryPayDialogFragment.this.state;
                                }
                                Log.d((String)TAG, (String)url);
                                if (((MItemPayment)PayGridViewItem.this.listItemPayment.get(position)).getConfig().getType().equals("webview")) {
                                    Intent intent = new Intent((Context)PayGridViewItem.this.mActivity, LibraryActivity.class);
                                    intent.putExtra(LibraryActivity.KEY_DATA, "[{'action':'" + url + "'}]");
                                    intent.putExtra(LibraryActivity.KEY_ENABLE_AUTOHIDE_HEADER_BAR, false);
                                    intent.putExtra(LibraryActivity.KEY_ENABLE_SIDE_MENU, false);
                                    PayGridViewItem.this.mActivity.startActivity(intent);
                                    LibraryPayDialogFragment.this.getDialog().dismiss();
                                } else {
                                    Intent i = new Intent("android.intent.action.VIEW");
                                    i.setData(Uri.parse((String)url));
                                    LibraryPayDialogFragment.this.startActivity(i);
                                }
                                LibraryPayDialogFragment.this.getDialog().dismiss();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                view = convertView;
            }
            return view;
        }

        public int getScreenWidthInPixel(Context context) {
            try {
                return context.getResources().getDisplayMetrics().widthPixels;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getScreenHeightInPixel(Context context) {
            try {
                return context.getResources().getDisplayMetrics().heightPixels - (int)(50.0f * DeviceUtils.getDensity((Context)this.mActivity));
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }
    }
}

