/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.gui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.TextView;
import com.kajime.libtsy.R;
import com.kajime.libtsy.gui.LibraryNotiFloatGestureView;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.Res;

public class LibraryNotiOverlayView {
    private static final String TAG = LibraryNotiOverlayView.class.getSimpleName();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Activity activity;
    private View rootView;
    private View layoutBottom;
    private View layoutFloat;
    private TextView txtDismiss;
    private LibraryNotiFloatGestureView floatArea;
    private boolean isOutsideBottomArea;
    private int boundWidth;
    private int boundHeight;
    private int relativePositionOnScreen;
    private int statusBarHeight;
    private String imageUrl = "";
    private float density;
    private LibraryNotiFloatGestureView.EventListener mButtonEventListener = new LibraryNotiFloatGestureView.EventListener(){

        @Override
        public void onTouchDown(MotionEvent event) {
            LibraryNotiOverlayView.this.isOutsideBottomArea = true;
        }

        @Override
        public void onTouchMove(MotionEvent event) {
            try {
                if (LibraryNotiOverlayView.this.isInBottomArea(event.getRawX(), event.getRawY())) {
                    if (LibraryNotiOverlayView.this.isOutsideBottomArea) {
                        LibraryNotiOverlayView.this.showLayoutBottom();
                    }
                    LibraryNotiOverlayView.this.isOutsideBottomArea = false;
                } else {
                    if (!LibraryNotiOverlayView.this.isOutsideBottomArea) {
                        LibraryNotiOverlayView.this.hideLayoutBottom();
                    }
                    LibraryNotiOverlayView.this.isOutsideBottomArea = true;
                }
                if (LibraryNotiOverlayView.this.isInDismissArea(event.getRawX(), event.getRawY())) {
                    LibraryNotiOverlayView.this.txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_active, 0, 0);
                    LibraryNotiOverlayView.this.txtDismiss.setTextColor(Color.rgb((int)194, (int)39, (int)45));
                } else {
                    LibraryNotiOverlayView.this.txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_normal, 0, 0);
                    LibraryNotiOverlayView.this.txtDismiss.setTextColor(Color.rgb((int)255, (int)255, (int)255));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onTouchUp(MotionEvent event) {
            try {
                LibraryNotiOverlayView.this.floatArea.moveToEdge(true);
                if (event != null) {
                    if (LibraryNotiOverlayView.this.isInDismissArea(event.getRawX(), event.getRawY())) {
                        LibraryNotiOverlayView.this.hideLayoutBottom();
                        LibraryNotiOverlayView.this.layoutFloat.setVisibility(8);
                        LibraryNotiOverlayView.this.floatArea.hide();
                    } else {
                        LibraryNotiOverlayView.this.hideLayoutBottom();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onClick(MotionEvent event) {
        }

        @Override
        public void onMove(int x, int y) {
            try {
                x = Math.max(0, Math.min(LibraryNotiOverlayView.this.boundWidth - LibraryNotiOverlayView.this.floatArea.getSizeInPixels(), x));
                y = Math.max(0, Math.min(LibraryNotiOverlayView.this.boundHeight - LibraryNotiOverlayView.this.relativePositionOnScreen - LibraryNotiOverlayView.this.floatArea.getSizeInPixels(), y));
                LibraryNotiOverlayView.this.layoutFloat.setX((float)x);
                LibraryNotiOverlayView.this.layoutFloat.setY((float)y);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public LibraryNotiOverlayView(Activity a, String imageUrl, String text) {
        activity = a;
        this.imageUrl = imageUrl;
        this.floatArea = new LibraryNotiFloatGestureView(activity, imageUrl, text);
        this.density = DeviceUtils.getDensity((Context)a);
        this.statusBarHeight = DeviceUtils.getStatusBarHeightInPixels((Context)activity);
        this.attachView();
        this.initView();
        this.hide();
    }

    private void attachView() {
        try {
            this.rootView = LayoutInflater.from((Context)activity).inflate(R.layout.noti_float_overlay_view, null);
            WindowManager windowManager = (WindowManager)activity.getApplicationContext().getSystemService("window");
            int LAYOUT_FLAG = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, LAYOUT_FLAG, 8, -2);
            params.gravity = 51;
            params.flags = 312;
            windowManager.addView(this.rootView, (ViewGroup.LayoutParams)params);
            this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                @SuppressLint(value={"NewApi"})
                public void onGlobalLayout() {
                    if (LibraryNotiOverlayView.this.rootView != null) {
                        LibraryNotiOverlayView.this.boundWidth = LibraryNotiOverlayView.this.rootView.getWidth();
                        LibraryNotiOverlayView.this.boundHeight = LibraryNotiOverlayView.this.rootView.getHeight();
                        LibraryNotiOverlayView.this.floatArea.setMovableWidth(LibraryNotiOverlayView.this.boundWidth);
                        LibraryNotiOverlayView.this.floatArea.setMovableHeight(LibraryNotiOverlayView.this.boundHeight);
                        Log.e((String)TAG, (String)("boundWidth:" + LibraryNotiOverlayView.this.boundWidth + "||boundHeight" + LibraryNotiOverlayView.this.boundHeight + "||"));
                        int[] locations = new int[2];
                        LibraryNotiOverlayView.this.rootView.getLocationOnScreen(locations);
                        LibraryNotiOverlayView.this.relativePositionOnScreen = locations[1];
                        LibraryNotiOverlayView.this.rootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initView() {
        try {
            this.layoutBottom = this.rootView.findViewById(R.id.layout_bottom_noti);
            this.layoutFloat = this.rootView.findViewById(R.id.layout_float_noti);
            this.txtDismiss = (TextView)this.rootView.findViewById(R.id.txt_dismiss_noti);
            this.floatArea.setEventListener(this.mButtonEventListener);
            this.floatArea.moveTo(0, 0);
            this.txtDismiss.setText((CharSequence)Res.string((Context)activity, R.string.dismiss));
            this.rootView.post(new Runnable(){

                @Override
                public void run() {
                    LibraryNotiOverlayView.this.layoutBottom.setY((float)(LibraryNotiOverlayView.this.boundHeight + LibraryNotiOverlayView.this.statusBarHeight - LibraryNotiOverlayView.this.relativePositionOnScreen) - 125.0f * LibraryNotiOverlayView.this.density);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isInBottomArea(float left, float top) {
        try {
            int dY = (int)((float)this.boundHeight - 100.0f * this.density);
            return top >= (float)dY || this.isInDismissArea(left, top);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isInDismissArea(float left, float top) {
        try {
            int dX = this.boundWidth / 2;
            int dY = (int)((float)this.boundHeight - 50.0f * this.density);
            double distance = Math.sqrt(Math.pow(left - (float)dX, 2.0) + Math.pow(top - (float)dY, 2.0));
            double maxDistance = Math.min(70.0f * this.density, (float)(this.boundWidth / 5));
            return distance <= maxDistance || top >= (float)dY && (double)left >= (double)dX - maxDistance && (double)left <= (double)dX + maxDistance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void showLayoutBottom() {
        try {
            this.layoutBottom.setVisibility(0);
            this.layoutBottom.animate().setDuration(200L).y((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen) - 125.0f * this.density);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideLayoutBottom() {
        try {
            this.layoutBottom.animate().setDuration(200L).y((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show() {
        try {
            this.layoutFloat.setVisibility(0);
            this.layoutBottom.setVisibility(8);
            this.floatArea.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hide() {
        try {
            this.layoutFloat.setVisibility(8);
            this.layoutBottom.setVisibility(8);
            this.floatArea.hide();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isShowing() {
        try {
            return this.layoutFloat.getVisibility() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void dismiss() {
        try {
            this.rootView.setVisibility(8);
            WindowManager windowManager = (WindowManager)activity.getApplicationContext().getSystemService("window");
            windowManager.removeView(this.rootView);
            if (this.floatArea != null) {
                this.floatArea.dismiss();
            }
            this.rootView = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

