/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.gui;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.Transformation;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.kajime.libtsy.R;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.Res;

public class LibraryNotiFloatGestureView {
    private static String TAG = LibraryNotiFloatGestureView.class.getSimpleName();
    private static final int ANIMAION_TIME_MOVE_TO_EDGE = 200;
    private static final int BUTTON_SIZE = 120;
    Activity activity;
    private View rootView;
    private View floatArea;
    private EventListener listener;
    private GestureDetector gestureDetector;
    private int buttonSize;
    private int movableWidth;
    private int movableHeight;
    private float deltaX;
    private float deltaY;
    private WindowManager windowManager;
    private WindowManager.LayoutParams params;
    private String text = "";
    private String imageUrl = "";
    private View.OnTouchListener mOnTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            boolean comsumed = true;
            try {
                LibraryNotiFloatGestureView.this.gestureDetector.onTouchEvent(event);
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        long timeTouchDown = System.currentTimeMillis();
                        LibraryNotiFloatGestureView.this.onTouchDown(event);
                        break;
                    }
                    case 1: {
                        LibraryNotiFloatGestureView.this.onTouchUp(event);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 2: {
                        LibraryNotiFloatGestureView.this.onTouchMove(event);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return comsumed;
        }
    };
    GestureListener mGestureListener = new GestureListener();

    LibraryNotiFloatGestureView(Activity a, String imageUrl, String text) {
        this.activity = a;
        this.text = text;
        this.imageUrl = imageUrl;
        float density = DeviceUtils.getDensity((Context)a);
        this.movableWidth = DeviceUtils.getScreenWidthInPixels((Context)a);
        this.movableHeight = DeviceUtils.getScreenHeightInPixels((Context)a);
        this.buttonSize = (int)(120.0f * density);
        this.gestureDetector = new GestureDetector((Context)a, (GestureDetector.OnGestureListener)new GestureListener());
        this.initView();
        this.attachView();
    }

    private void initView() {
        this.rootView = LayoutInflater.from((Context)this.activity).inflate(R.layout.float_area_noti, null);
        this.floatArea = this.rootView.findViewById(R.id.layout_float_noti);
        TextView txtFloatButton = (TextView)this.rootView.findViewById(R.id.tv_float_noti);
        if (this.text.length() != 0) {
            txtFloatButton.setText((CharSequence)this.text);
        } else {
            txtFloatButton.setText((CharSequence)"Ch\u01a1i qu\u00e1 180 ph\u00fat m\u1ed9t ng\u00e0y s\u1ebd \u1ea3nh h\u01b0\u1edfng x\u1ea5u \u0111\u1ebfn s\u1ee9c kh\u1ecfe.");
        }
        ImageView floatButton = (ImageView)this.rootView.findViewById(R.id.img_float_noti);
        if (this.imageUrl.length() != 0) {
            RequestOptions options = new RequestOptions().placeholder(R.drawable.logotuoi).error(R.drawable.logotuoi);
            Glide.with((Activity)this.activity).load(this.imageUrl).apply(options).into(floatButton);
        } else {
            floatButton.setImageResource(Res.drawableResource((Context)this.activity, R.drawable.logotuoi));
        }
        this.floatArea.getLayoutParams().width = this.buttonSize;
        this.floatArea.setOnTouchListener(this.mOnTouchListener);
    }

    private void attachView() {
        try {
            this.windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
            int LAYOUT_FLAG = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
            this.params = new WindowManager.LayoutParams(-2, -2, LAYOUT_FLAG, 8, -2);
            this.params.gravity = 51;
            this.params.x = 0;
            this.params.y = 0;
            this.windowManager.addView(this.rootView, (ViewGroup.LayoutParams)this.params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setEventListener(EventListener listener) {
        this.listener = listener;
    }

    void setMovableWidth(int width) {
        this.movableWidth = width;
    }

    void setMovableHeight(int height) {
        this.movableHeight = height;
    }

    public int getSize() {
        return 120;
    }

    int getSizeInPixels() {
        return this.buttonSize;
    }

    public int getX() {
        if (this.rootView == null) {
            return 0;
        }
        return this.params.x;
    }

    public int getY() {
        if (this.rootView == null) {
            return 0;
        }
        return this.params.y;
    }

    void moveTo(int x, int y) {
        this.moveTo(x, y, false);
    }

    private void moveTo(int x, int y, boolean isAnimated) {
        try {
            this.params.x = x;
            this.params.y = y;
            this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
            if (this.listener != null) {
                this.listener.onMove(this.params.x, this.params.y);
                this.listener.onTouchUp(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void moveToEdge(boolean isAnimated) {
        try {
            if (isAnimated) {
                Animation animation = new Animation(){

                    protected void applyTransformation(float interpolatedTime, Transformation t) {
                        super.applyTransformation(interpolatedTime, t);
                        try {
                            float left = ((LibraryNotiFloatGestureView)LibraryNotiFloatGestureView.this).params.x;
                            float right = (float)(LibraryNotiFloatGestureView.this.movableWidth - LibraryNotiFloatGestureView.this.buttonSize) - left;
                            ((LibraryNotiFloatGestureView)LibraryNotiFloatGestureView.this).params.x = left <= right ? (int)(left - left * interpolatedTime) : (int)(left - (left - (float)LibraryNotiFloatGestureView.this.movableWidth) * interpolatedTime);
                            LibraryNotiFloatGestureView.this.windowManager.updateViewLayout(LibraryNotiFloatGestureView.this.rootView, (ViewGroup.LayoutParams)LibraryNotiFloatGestureView.this.params);
                            if (LibraryNotiFloatGestureView.this.listener != null) {
                                LibraryNotiFloatGestureView.this.listener.onMove(((LibraryNotiFloatGestureView)LibraryNotiFloatGestureView.this).params.x, ((LibraryNotiFloatGestureView)LibraryNotiFloatGestureView.this).params.y);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                animation.setDuration(200L);
                animation.setInterpolator((Interpolator)new OvershootInterpolator(0.5f));
                this.floatArea.startAnimation(animation);
            } else {
                float left = this.params.x;
                float right = (float)(this.movableWidth - this.buttonSize) - left;
                this.params.x = left <= right ? 0 : this.movableWidth - this.buttonSize;
                this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
                if (this.listener != null) {
                    this.listener.onMove(this.params.x, this.params.y);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchDown(MotionEvent event) {
        try {
            this.deltaX = event.getX();
            this.deltaY = event.getY();
            if (this.listener != null) {
                this.listener.onTouchDown(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchMove(MotionEvent event) {
        try {
            float left = event.getRawX() - this.deltaX;
            float top = event.getRawY() - this.deltaY;
            left = Math.max(0.0f, Math.min((float)this.movableWidth, left));
            top = Math.max(0.0f, Math.min((float)this.movableHeight, top));
            this.params.x = (int)left;
            this.params.y = (int)top;
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)this.params);
            this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
            if (this.listener != null) {
                this.listener.onTouchMove(event);
                this.listener.onMove(this.params.x, this.params.y);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchUp(MotionEvent event) {
        if (this.listener != null) {
            this.listener.onTouchUp(event);
        }
    }

    public void show() {
        try {
            this.rootView.setVisibility(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void hide() {
        try {
            if (this.rootView != null) {
                this.rootView.setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        try {
            this.rootView.setVisibility(8);
            this.windowManager.removeView(this.rootView);
            this.rootView = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (LibraryNotiFloatGestureView.this.listener != null) {
                LibraryNotiFloatGestureView.this.listener.onClick(e);
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
        }
    }

    static interface EventListener {
        public void onTouchUp(MotionEvent var1);

        public void onTouchDown(MotionEvent var1);

        public void onTouchMove(MotionEvent var1);

        public void onClick(MotionEvent var1);

        public void onMove(int var1, int var2);
    }
}

