package com.kajime.libtsy.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;

import com.kajime.libtsy.R;
import com.kajime.libtsy.component.GameConfigManager;

public class Res {
	
	public static String string(Context context, int key) {
		try{
			String currentLang = Constants.LANG_MY;
			if (GameConfigManager.getInstance().getGameConfig() != null) {
				currentLang = GameConfigManager.getInstance().getGameConfig().getLang();
			}
			if (Constants.LANG_VI.equalsIgnoreCase(currentLang)) {

				if (R.string.hello == key) return "Xin chào";
				if (R.string.reload == key) return "Tải lại";
				if (R.string.connection_lost == key) return "Oops! Mất kết nối";
				if (R.string.something_went_wrong == key) return "Có lỗi xảy ra";
				if (R.string.connection_error == key) return "Lỗi kết nối";
				if (R.string.unable_to_connect == key) return "Không thể kết nối đến máy chủ";
				if (R.string.dialog_tips_title == key) return "Hãy theo hướng dẫn dưới đây để hiện nút";
				if (R.string.dont_ask_again == key) return "Không nhắc lại";
				if (R.string.dismiss == key) return "Ẩn";
				if (R.string.remind_me == key) return "Bỏ qua";
				if (R.string.retry == key) return "Thử lại";
				if (R.string.exit == key) return "Thoát";
				if (R.string.please_wait == key) return "Xin đợi";
				if (R.string.logging_in == key) return "Đang đăng nhập";
				if (R.string.connecting_facebook == key) return "Đang kết nối tài khoản Facebook";
				if (R.string.connecting_google == key) return "Đang kết nối tài khoản Google";
				if (R.string.connecting_google_play == key) return "Đang kết nối tài khoản Google Play";
				if (R.string.connecting_server == key) return "Đang kết nối";
				if (R.string.copied == key) return "Đã copy!";
				if (R.string.complete_now == key) return "Hoàn thiện ngay";
				if (R.string.notice == key) return "Thông báo";
				if (R.string.bind_account == key) return "Nối TK ngay";
				if (R.string.draw_over_apps_title == key) return "Chú ý";
				if (R.string.draw_over_apps_message == key) return "Bạn cần cung cấp quyền để game hoạt động tốt nhất";
				if (R.string.open_with_browser == key) return "Bạn sẽ được chuyển ra ngoài app. Đồng ý tiếp tục?";
				if (R.string.yes == key) return "Đồng ý";
				if (R.string.no == key) return "Không";
			} else if (Constants.LANG_EN.equalsIgnoreCase(currentLang)) {

				if (R.string.hello == key) return "Hello";
				if (R.string.reload == key) return "Reload";
				if (R.string.connection_lost == key) return "Oops! Connection lost";
				if (R.string.something_went_wrong == key) return "Oops! Something went wrong";
				if (R.string.connection_error == key) return "Connection error";
				if (R.string.unable_to_connect == key) return "Unable to connect to server";
				if (R.string.dialog_tips_title == key) return "You can show up the button as following";
				if (R.string.dont_ask_again == key) return "Don't ask again";
				if (R.string.dismiss == key) return "Dismiss";
				if (R.string.remind_me == key) return "Remind me";
				if (R.string.retry == key) return "Retry";
				if (R.string.exit == key) return "Exit";
				if (R.string.please_wait == key) return "Please wait";
				if (R.string.logging_in == key) return "Logging in";
				if (R.string.connecting_facebook == key) return "Connecting to your Facebook account";
				if (R.string.connecting_google == key) return "Connecting to your Google account";
				if (R.string.connecting_google_play == key) return "Connecting to your Google Play account";
				if (R.string.connecting_server == key) return "Connecting to server";
				if (R.string.copied == key) return "Copied!";
				if (R.string.complete_now == key) return "Complete now";
				if (R.string.notice == key) return "Notice";
				if (R.string.bind_account == key) return "Bind account";
				if (R.string.draw_over_apps_title == key) return "Notice";
				if (R.string.draw_over_apps_message == key) return "You have to grant Draw Over Apps permission for our game to perform full features";

			}else if (Constants.LANG_CN.equalsIgnoreCase(currentLang)) {

				if (R.string.hello == key) return "你好";
				if (R.string.reload == key) return "重新下载";
				if (R.string.connection_lost == key) return "链接断线";
				if (R.string.something_went_wrong == key) return "出错";
				if (R.string.connection_error == key) return "链接出错";
				if (R.string.unable_to_connect == key) return "无法链接服务器";
				if (R.string.dialog_tips_title == key) return "请按照下面的说明来显示按钮";
				if (R.string.dont_ask_again == key) return "不在提醒";
				if (R.string.dismiss == key) return "屏蔽";
				if (R.string.remind_me == key) return "跳过";
				if (R.string.retry == key) return "重试";
				if (R.string.exit == key) return "退出";
				if (R.string.please_wait == key) return "请稍等";
				if (R.string.logging_in == key) return "正在登陆";
				if (R.string.connecting_facebook == key) return "正在链接Facebook账号";
				if (R.string.connecting_google == key) return "正在链接Google账号";
				if (R.string.connecting_google_play == key) return "正在链接Google Play账号";
				if (R.string.connecting_server == key) return "正在链接";
				if (R.string.copied == key) return "已复制";
				if (R.string.complete_now == key) return "马上完善";
				if (R.string.notice == key) return "通知";
				if (R.string.bind_account == key) return "马上链接账号";
				if (R.string.draw_over_apps_title == key) return "备注";
				if (R.string.draw_over_apps_message == key) return "请提供权限，让游戏最好地运行";
				if (R.string.open_with_browser == key) return "您会转到外挂应用。同意继续？";
				if (R.string.yes == key) return "同意";
				if (R.string.no == key) return "取消";
			}else if (Constants.LANG_ID.equalsIgnoreCase(currentLang)) {

				if (R.string.hello == key) return "Halo";
				if (R.string.reload == key) return "Memuat ulang";
				if (R.string.something_went_wrong == key) return "Oops! Terjadi kesalahan";
				if (R.string.connection_error == key) return "Koneksi error";
				if (R.string.unable_to_connect == key) return "Tidak dapat terhubung ke server";
				if (R.string.dialog_tips_title == key) return "Tampilkan tombol";
				if (R.string.dont_ask_again == key) return "Jangan tanya lagi";
				if (R.string.dismiss == key) return "Abaikan";
				if (R.string.remind_me == key) return "Ingatkan";
				if (R.string.retry == key) return "Coba lagi";
				if (R.string.exit == key) return "Keluar";
				if (R.string.please_wait == key) return "Harap tunggu";
				if (R.string.logging_in == key) return "Masuk";
				if (R.string.connecting_facebook == key) return "Terhubung ke akun Facebook";
				if (R.string.connecting_google == key) return "Terhubung ke akun Google";
				if (R.string.connecting_google_play == key) return "Terhubung ke akun Google Play";
				if (R.string.connecting_server == key) return "Terhubung ke server";
				if (R.string.copied == key) return "Disalin!";
				if (R.string.complete_now == key) return "Selesai";
				if (R.string.notice == key) return "Pemberitahuan";
				if (R.string.bind_account == key) return "Ikat akun";
				if (R.string.draw_over_apps_title == key) return "Notice";
				if (R.string.draw_over_apps_message == key) return "You have to grant Draw Over Apps permission for our game to perform full features";

			}else if (Constants.LANG_MY.equalsIgnoreCase(currentLang)){
				if (R.string.hello == key) return "မင်္ဂလာပါ";
				if (R.string.reload == key) return "ပြန်လည်ချိတ်ဆက်";
				if (R.string.connection_lost == key) return "ကွန်ယက်ချိတ်ဆက်မှုပြတ်တောက်";
				if (R.string.something_went_wrong == key) return "တစ်စုံတခု မှားယွင်း";
				if (R.string.connection_error == key) return "ကွန်ယက်ချိတ်ဆက်မှု error";
				if (R.string.unable_to_connect == key) return "ဆာဗာသို့ ချိတ်ဆက်၍မရပါ";
				if (R.string.dialog_tips_title == key) return "အောက်ပါနည်းလမ်းအတိုင်း Control စနစ်အား ဖော်ကြည့်နိုင်ပါသည်";
				if (R.string.dont_ask_again == key) return "ထပ်မံ မပြရန်";
				if (R.string.dismiss == key) return "ဖျောက်ရန် ဤ နေရာသို့ရွှေ့ပါ";
				if (R.string.remind_me == key) return "သတိပေးချက်ရယူ";
				if (R.string.retry == key) return "ထပ်မံကြိုးစား";
				if (R.string.exit == key) return "ထွက်";
				if (R.string.please_wait == key) return "ခေတ္တ စောင့်ပါ";
				if (R.string.logging_in == key) return "Login ဝင်နေသည်";
				if (R.string.connecting_facebook == key) return "Facebook အကောင့် သို့ ချိတ်ဆက်နေပါသည်";
				if (R.string.connecting_google == key) return "Google အကောင့် သို့ချိတ်ဆက်နေပါသည်";
				if (R.string.connecting_google_play == key) return "Google Play အကောင့် သို့ ချိတ်ဆက်နေပါသည်";
				if (R.string.connecting_server == key) return "ဆာဗာသို့ ချိတ်ဆက်နေပါသည်";
				if (R.string.copied == key) return "ကူးယူပြီး!";
				if (R.string.open_with_browser == key) return "app မှထွက်နေပါသည် . ဆက်လက်မည်လား?";
				if (R.string.yes == key) return "Yes";
				if (R.string.no == key) return "No";

//				if (R.string.copy == key) return "ကူးယူ";
				if (R.string.complete_now == key) return "အောင်မြင်သည်";
				if (R.string.notice == key) return "မှတ်ချက်";
				if (R.string.bind_account == key) return "အကောင့် ချိတ်ဆက်ရန်";
//				if (R.string.attention_overlay == key) return "မှတ်ချက်";
//				if (R.string.attention_permission == key) return "သတိ";
//				if (R.string.attention_message == key) return "ဂိမ်းအချက်အလက်များ သွင်းရန်အတွက် read and write ဖုန်း permission လိုအပ်သည်";
				if (R.string.draw_over_apps_message == key) return "လုပ်ဆောင်ချက်များ အားလုံးအသုံးပြုနိုင်ရန်အတွက် Draw Over Apps ဖုန်း permission လိုအပ်ပါသည်";
//				if (R.string.hide == key) return "ဖျောက်";
				if (R.string.cancel == key) return "Cancel";
//				if (R.string.warning == key) return "သတိ";
//				if (R.string.message_warning == key) return "အကောင်းဆုံး အတွေ့အကြုံရရှိရန်အတွက် ဖုန်း permission များလိုအပ်ပါသည်";
//				if (R.string.do_you_want_close == key) return "ပိတ်မည် သေချာပါသလား?";
//				if (R.string.message_exit == key) return "ထွက်မည်သေချာပါသလား ?";
//				if (R.string.close == key) return "ပိတ်";
				if (R.string.alert_image_validate == key) return "ဓါတ်ပုံ 3 ပုံ အထိ ရွေးချယ်နိုင်ပါသည်";
//				if (R.string.images_selected == key) return "ရွေးချယ်ထား";
//				if (R.string.logout == key) return "Logout";
//				if (R.string.title_force_logout == key) return "      ချိတ်ဆက်မှုပြတ်တောက်.\nဆက်လက်လုပ်ဆောင်ရန် ဂိမ်းကို ပြန်လည်စတင်ပါ";

			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return "";
	}
	
	public static int drawableResource(Context context, int id) {
		String currentLang = Constants.LANG_MY;
		if (GameConfigManager.getInstance().getGameConfig() != null) {
			currentLang = GameConfigManager.getInstance().getGameConfig().getLang();
		}
		if (Constants.LANG_MY.equalsIgnoreCase(currentLang)) {
//			if (R.drawable.logo_sm == id) return R.drawable.logo_sm_vn;
//			if (R.drawable.gcm_sm == id) return R.drawable.gcm_sm_vn;
			if (R.drawable.bar_header == id) return R.drawable.bar_header_vn;
//			if (R.drawable.float_hide_tips_animation == id) return R.drawable.float_hide_tips_animation_vn;

		}
		return id;
	}
	
	public static Drawable drawable(Context context, int id) {
		return ContextCompat.getDrawable(context, drawableResource(context, id));
	}

}
