package com.kajime.libtsy.js;

import android.app.Activity;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;

import com.facebook.AccessToken;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.kajime.libtsy.component.EventClientManager;
import com.kajime.libtsy.component.FacebookManager;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.component.GoogleAuthManager;
import com.kajime.libtsy.gui.LibraryWebFragment;
import com.kajime.libtsy.model.MAccessToken;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.LibAppsflyerUtils;
import com.kajime.libtsy.utils.Preference;
import com.kajime.libtsy.utils.Res;
import com.kajime.libtsy.utils.Utils;
import com.kajime.libtsy.R;
import com.kajime.libtsy.api.PostTask;
import com.kajime.libtsy.api.PostTask.Callback;
import com.kajime.libtsy.gui.LibraryHaveBackButtonFragment;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Set;


final class CmdLogin {

	private static final String TAG = CmdLogin.class.getSimpleName();
	private static CmdLogin INSTANCE;

	private CmdLogin() {}
	
	public static CmdLogin getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new CmdLogin();
		}
		return INSTANCE;
	}

	void vaosingtc(final Activity activity, LibraryWebFragment webFragment, String params) {
		try{
			JSONObject json = new JSONObject(params);
			String user = json.getString("User");
			JSONObject jsonUser = new JSONObject(user);
			int is_register = 0;
			if (jsonUser.has("is_register"))
					is_register = jsonUser.getInt("is_register");
			String register_name = "";
			if (jsonUser.has("register_name"))
				register_name = jsonUser.getString("register_name");
			Log.i(TAG, "vaosingtc :"  + is_register + " , "+ register_name);

			if(is_register == 1){
				LibAppsflyerUtils.getInstance().trackRegisterSuccess(activity , register_name);
			}else{
				LibAppsflyerUtils.getInstance().trackLoginSuccessFromWeb(activity , register_name);
			}
			Utils.hideLoading();
			MAccessToken accessToken = MAccessToken.parse(params);
			GameConfigManager.getInstance().setAccessToken(accessToken.getToken());
			new Thread(new Runnable() {
				@Override
				public void run() {
					EventClientManager.getInstance(activity).setMaxthoongbaos(accessToken.getToken());
				}
			}).start();

			Intent intent = new Intent(Constants.INTENT_FILTER);
			intent.putExtra("category", "login");
			LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	void vaosignKhach(final Activity activity, LibraryWebFragment webFragment, String params) {
		Log.i(TAG, "vaosignKhach");
		try {
			Utils.showLoading(activity, Res.string(activity, R.string.logging_in));
			String mac_address = DeviceUtils.getUniqueDeviceID(activity);
			String key = Utils.getSHACheckSum(mac_address + "abc");

			HashMap<String , Object> map = new HashMap<>();
			map.put("TYPE_LOGIN" , "Login PlayNow");
			LibAppsflyerUtils.getInstance().trackLoginClick(activity , LibAppsflyerUtils.TRACK_LOGIN_CLICKED, map );

			HashMap<String, String> postParams = new HashMap<String, String>();
			postParams.put("mac_address", mac_address);
			postParams.put("key", key);
			webFragment.postUrlWithMobHeaders(Constants.URL_RECEIVE_MAC_ADDRESS, postParams, new PostTask.Callback() {

				@Override
				public void onSuccess(String response) {
					Utils.hideLoading();
					if(Preference.getInt(activity , Constants.REGISTER_PLAY_NOW , 0) == 0){
						LibAppsflyerUtils.getInstance().trackRegisterSuccess(activity , "play_now");
						Preference.save(activity , Constants.REGISTER_PLAY_NOW , 1);
					}
				}

				@Override
				public void onFailure(Throwable e) {
					e.printStackTrace();
					handleException(activity, Res.string(activity, R.string.something_went_wrong));
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
			handleException(activity, Res.string(activity, R.string.something_went_wrong));
		}
	}

	void mobLoginFacebook(final Activity activity, final LibraryWebFragment webFragment, String params) {
		Log.i(TAG, "vaofbnhanh:" + params);
		Utils.showLoading(activity, "", Res.string(activity, R.string.connecting_facebook), false);

		HashMap<String , Object> map = new HashMap<>();
		map.put("TYPE_LOGIN" ,"Login FB");
		LibAppsflyerUtils.getInstance().trackLoginClick(activity , LibAppsflyerUtils.TRACK_LOGIN_CLICKED, map);
		
		FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback() {

			@Override
			public void onSuccess(AccessToken accessToken,
					Set<String> recentlyGrantedPermissions,
					Set<String> recentlyDeniedPermissions) {

				try {
					HashMap<String, String> postParams = new HashMap<String, String>();
					postParams.put("access_token", accessToken.getToken());
					webFragment.postUrlWithMobHeaders(Constants.URL_RECEIVE_ACCESS_TOKEN, postParams, new Callback() {
						
						@Override
						public void onSuccess(String response) {
							Utils.hideLoading();
							if(Preference.getInt(activity , Constants.REGISTER_FACE_BOOK , 0) == 0){
								LibAppsflyerUtils.getInstance().trackRegisterSuccess(activity , "facebook_login");
								Preference.save(activity , Constants.REGISTER_FACE_BOOK , 1);
							}
						}
						
						@Override
						public void onFailure(Throwable e) {
							Utils.hideLoading();
						}
					});
				} catch (Exception e) {
					Log.e(TAG,"Error: " + e.getMessage());
					handleException(activity, Res.string(activity, R.string.something_went_wrong));
					Utils.hideLoading();
				}
				
			}

			@Override
			public void onCancel() {
				Utils.hideLoading();
			}

			@Override
			public void onError(Throwable t) {
				Log.e(TAG,"Error: " + t.getMessage());
				Utils.hideLoading();
				handleException(activity, Res.string(activity, R.string.something_went_wrong));
			}

		});
	}

	void mobUpgradeFacebook(final Activity activity, final LibraryWebFragment webFragment, final LibraryHaveBackButtonFragment dialogSocialFragment, String params) {
		Log.i(TAG, "nangcapMatSach:" + params);
		Utils.showLoading(activity, Res.string(activity, R.string.connecting_facebook));

		FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback() {

			@Override
			public void onSuccess(AccessToken accessToken,
					Set<String> recentlyGrantedPermissions,
					Set<String> recentlyDeniedPermissions) {
				try {
					Utils.hideLoading();
					HashMap<String, String> postParams = new HashMap<String, String>();
					postParams.put("token", accessToken.getToken());
					if (dialogSocialFragment!=null) {
						dialogSocialFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams, null);
						dialogSocialFragment.dismiss();
					}
					else if (webFragment != null) {
						webFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
					}

				} catch (Exception e) {
					handleException(activity, Res.string(activity, R.string.something_went_wrong));
				} 
			
			}

			@Override
			public void onCancel() {
				Utils.hideLoading();
			}

			@Override
			public void onError(Throwable t) {
				Utils.hideLoading();
			}
		});
	}

	void mobLoginGooglePlay(final Activity activity, final LibraryWebFragment webFragment, String params) {
		Log.i(TAG, "mobLoginGooglePlay");
		if(!Utils.isOnline(activity)){
			handleException(activity, Res.string(activity, R.string.connection_lost));
			return;
		}

		if(!GoogleAuthManager.getInstance().isGoogleServiceAvailable(activity)){
			Log.d(TAG, "Google Play Service is out of date. Request update...");
			return;
		}
		Utils.showLoading(activity, "", Res.string(activity, R.string.connecting_google_play), true);

		GoogleAuthManager.getInstance().login(activity,new GoogleAuthManager.GooglePlusResultCallback() {


			@Override
			public void onLoginSuccess(GoogleSignInAccount account, String mToken) {
				Log.d(TAG, "Google Token: " + mToken);

				try {
					HashMap<String , Object> map = new HashMap<>();
					map.put("TYPE_LOGIN" , "Login PlayNow");
					LibAppsflyerUtils.getInstance().trackLoginClick(activity , LibAppsflyerUtils.TRACK_LOGIN_CLICKED, map );

					HashMap<String, String> postParams = new HashMap<String, String>();
					postParams.put("id_token", mToken);
					webFragment.postUrlWithMobHeaders(Constants.URL_LOGIN_GOOGLE_ACCOUNT,
							postParams, new PostTask.Callback() {
								@Override
								public void onSuccess(String response) {
									Log.d(TAG, "Google Login Success");
									getFullResponse(response);
									Utils.hideLoading();

									if(Preference.getInt(activity , Constants.REGISTER_GOOGLE_SIGNIN , 0) == 0){
										LibAppsflyerUtils.getInstance().trackRegisterSuccess(activity , "google_signin");
										Preference.save(activity , Constants.REGISTER_GOOGLE_SIGNIN , 1);
									}

								}

								@Override
								public void onFailure(Throwable e) {
									Log.wtf("onFailure", e.getLocalizedMessage());
									Utils.hideLoading();
								}
							});

				} catch (Exception e) {
					e.printStackTrace();
					handleException(activity, Res.string(activity, R.string.something_went_wrong));
					e.printStackTrace();
					Utils.hideLoading();
				}
				Log.wtf("mobLoginGooglePlay", "onLoginSuccess: Token: " + mToken + " Email: " + account.getEmail());
			}

			@Override
			public void onLoginError(String mess) {
//				Log.wtf("mobLoginGooglePlay", "Error: " + mess);
				Log.e(TAG , "Sign in google error");
				if(!TextUtils.isEmpty(mess)){
					handleException(activity, mess);
				}

				Utils.hideLoading();

			}

		});

	}
	private void getFullResponse(String sb){
		try {
			if (sb.length() > 4000) {
				Log.wtf("onResponse", "sb.length = " + sb.length());
				int chunkCount = sb.length() / 4000;     // integer division
				for (int i = 0; i <= chunkCount; i++) {
					int max = 4000 * (i + 1);
					if (max >= sb.length()) {
						Log.wtf("onResponse", "chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i));
					} else {
						Log.wtf("onResponse", "chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i, max));
					}
				}
			} else {
				Log.wtf(TAG, sb.toString());
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	void mobLoginGoogleAccount(Activity activity, LibraryWebFragment webFragment, String params) {
		Log.i(TAG, "mobLoginGoogleAccount");
	}
	
	private void handleException(final Activity activity, final String message) {
		Utils.hideLoading();
		activity.runOnUiThread(new Runnable() {
			
			@Override
			public void run() {
				Toast.makeText(activity, message, Toast.LENGTH_LONG).show();
			}
		});
		
		Intent intent = new Intent(Constants.INTENT_FILTER);
		intent.putExtra("category", "login");
		intent.putExtra("status", false);
		intent.putExtra("message", message);
		LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
	}
}
