package com.kajime.libtsy.gui;

import android.app.Activity;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.facebook.AccessToken;
import com.kajime.libtsy.model.UserInfo;
import com.kajime.libtsy.R;
import com.kajime.libtsy.api.UpgradeToFacebookTask;
import com.kajime.libtsy.component.EventClientManager;
import com.kajime.libtsy.component.FacebookManager;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.LoginResponse;
import com.kajime.libtsy.model.MAccessToken;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.Res;
import com.kajime.libtsy.utils.Utils;

import java.util.Set;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LibraryUpgradeDialog extends Dialog {
	
//	private static final String TAG = LibraryUpgradeDialog.class.getSimpleName();

	private Activity activity;
	private TextView txtAlert, txtBonusFacebook, txtBonusEmail, txtBonusInfo, txtConnect;
	private Button btnUpgrade, btnRegisterEmail, btnUpgradeInfo, btnCancel;
	
	private boolean isShowUpgrade = false;
	long startTime = 0;
    Handler timerHandler = new Handler();
    Runnable timerRunnable = new Runnable() {

        @Override
        public void run() {
            try {
				long millis = System.currentTimeMillis() - startTime;
				int seconds = (int) (millis / 1000);
				seconds = seconds % 60;

				if (seconds <= 10) {
					if (btnCancel != null) {
						btnCancel.setText(Res.string(activity, R.string.remind_me) + " (" + (10 - seconds) + "s)");
					}
					timerHandler.postDelayed(this, 1000);
				} else {
					if (isShowing()) {
						mOnCancelClickListener.onClick(btnCancel);
						dismiss();
						isShowUpgrade = false;
					}
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}
    };
	
	public LibraryUpgradeDialog(Activity a) {
		super(a, R.style.MobUpgradeDialog);
		this.activity = a;
	}
	
	public LibraryUpgradeDialog(Activity a, int themeResId) {
		super(a, R.style.MobUpgradeDialog);
		this.activity = a;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		setContentView(R.layout.dialog_upgrade);
		
		Window dialog_window = getWindow();
		dialog_window.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);

		btnUpgrade = (Button) findViewById(R.id.btn_upgrade_facebook);
		btnRegisterEmail = (Button) findViewById(R.id.btn_register_email);
		btnUpgradeInfo = (Button) findViewById(R.id.btn_upgrade_info);
		btnCancel = (Button) findViewById(R.id.btn_cancel);
		txtAlert = (TextView) findViewById(R.id.txt_alert);
		txtConnect = (TextView) findViewById(R.id.txt_connect_with_facebook_tip);
		txtBonusFacebook = (TextView) findViewById(R.id.txt_mobcoin_facebook);
		txtBonusEmail = (TextView) findViewById(R.id.txt_mobcoin_email);
		txtBonusInfo = (TextView) findViewById(R.id.txt_mobcoin_info);

		txtAlert.setText(Res.string(activity, R.string.notice));
		btnRegisterEmail.setText(Res.string(activity, R.string.bind_account));
		btnUpgradeInfo.setText(Res.string(activity, R.string.complete_now));
		btnCancel.setText(Res.string(activity, R.string.remind_me));

		try {
			UserInfo userInfo = GameConfigManager.getInstance().getUserInfo();
			UserInfo.UserDaily userDaily = null;
			if(userInfo != null){
				userDaily = userInfo.getUserDaily();
			}

			if(userDaily == null){
				return;
			}

			if (!TextUtils.isEmpty(userDaily.getTooltip())) {
				txtConnect.setVisibility(View.VISIBLE);
				txtConnect.setText(userDaily.getTooltip());
			} else {
				txtConnect.setVisibility(View.GONE);
			}

			btnCancel.setOnClickListener(new View.OnClickListener() {
				public void onClick(View v) {
					dismiss();
					isShowUpgrade = false;
					if (mOnCancelClickListener != null) {
						mOnCancelClickListener.onClick(v);
					}
				}
			});

			int typeHello = userDaily.getTypeHello();
			// 2 : upgrade facebook
			// 3 : update personal info
			// 4 : upgrade facebook + register email
			if (typeHello == 2) {

				if (userDaily.getBonusFacebook() > 0) {
					txtBonusFacebook.setText("+" + userDaily.getBonusFacebook());
					txtBonusFacebook.setVisibility(View.VISIBLE);
				}

				btnUpgrade.setVisibility(View.VISIBLE);
				btnUpgrade.setOnClickListener(new View.OnClickListener() {
					public void onClick(View v) {

						if (timerHandler != null) {
							timerHandler.removeCallbacks(timerRunnable);
							btnCancel.setText(Res.string(activity, R.string.remind_me));
						}
						Utils.showLoading(activity, Res.string(activity, R.string.connecting_facebook));

						FacebookManager.getInstance().login(activity, mFacebookCallback);
					}
				});
			} else if (typeHello == 3) {

				if (userDaily.getBonusInfo() > 0) {
					txtBonusInfo.setText("+" + userDaily.getBonusInfo());
					txtBonusInfo.setVisibility(View.VISIBLE);
				}

				final String fUrl = userDaily.getUpdateInfoDetails().getUrl();
				final int fType = userDaily.getUpdateInfoDetails().getType();
				btnUpgradeInfo.setVisibility(View.VISIBLE);
				btnUpgradeInfo.setOnClickListener(new View.OnClickListener() {
					public void onClick(View v) {
						dismiss();
						isShowUpgrade = false;
						Intent i = new Intent(Constants.INTENT_FILTER);
						i.putExtra("category", "LibraryUpgradeDialog.btnUpgradeInfo");
						LocalBroadcastManager.getInstance(activity).sendBroadcast(i);
						if (fType == 2) {
							Intent intent = new Intent(Constants.INTENT_FILTER);
							intent.putExtra("category", "motrduyen");
							intent.putExtra("data", "{url:'" + fUrl + "'}");
							LocalBroadcastManager.getInstance(activity.getApplicationContext())
									.sendBroadcast(intent);
						} else if (fType == 1) {
							Intent intent = new Intent(Constants.INTENT_FILTER);
							intent.putExtra("category", "dashboard");
							intent.putExtra("data", "{items:[{action:'" + fUrl + "'}], autohide_header_bar:false, enable_side_menu:false}");
							LocalBroadcastManager.getInstance(activity.getApplicationContext())
									.sendBroadcast(intent);
						}

					}
				});
			} else if (typeHello == 4) {

				if (userDaily.getBonusFacebook() > 0) {
					txtBonusFacebook.setText("+" + userDaily.getBonusFacebook());
					txtBonusFacebook.setVisibility(View.VISIBLE);
				}

				if (userDaily.getBonusEmail() > 0) {
					txtBonusEmail.setText("+" + userDaily.getBonusEmail());
					txtBonusEmail.setVisibility(View.VISIBLE);
				}

				btnUpgrade.setVisibility(View.VISIBLE);
				btnUpgrade.setOnClickListener(new View.OnClickListener() {
					public void onClick(View v) {

						if (timerHandler != null) {
							timerHandler.removeCallbacks(timerRunnable);
							btnCancel.setText(Res.string(activity, R.string.remind_me));
						}
						Utils.showLoading(activity, Res.string(activity, R.string.connecting_facebook));

						FacebookManager.getInstance().login(activity, mFacebookCallback);
					}
				});

				final String fUrl = userDaily.getUpgradeEmailDetails().getUrl();
				final int fType = userDaily.getUpgradeEmailDetails().getType();
				btnRegisterEmail.setVisibility(View.VISIBLE);
				btnRegisterEmail.setOnClickListener(new View.OnClickListener() {
					public void onClick(View v) {
						dismiss();
						isShowUpgrade = false;
						if (fType == 2) {
							Intent intent = new Intent(Constants.INTENT_FILTER);
							intent.putExtra("category", "motrduyen");
							intent.putExtra("data", "{url:'" + fUrl + "'}");
							LocalBroadcastManager.getInstance(activity.getApplicationContext())
									.sendBroadcast(intent);
						} else if (fType == 1) {
							Intent intent = new Intent(Constants.INTENT_FILTER);
							intent.putExtra("category", "dashboard");
							intent.putExtra("data", "{items:[{action:'" + fUrl + "'}], autohide_header_bar:false, enable_side_menu:false}");
							LocalBroadcastManager.getInstance(activity.getApplicationContext())
									.sendBroadcast(intent);
						}
					}
				});
			}

			setOnShowListener(new OnShowListener() {

				@Override
				public void onShow(DialogInterface dialog) {
					startTime = System.currentTimeMillis();
					timerHandler.postDelayed(timerRunnable, 500);

					Intent intent = new Intent(Constants.INTENT_FILTER);
					intent.putExtra("category", "float_button");
					intent.putExtra("message", "hide");
					LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
				}
			});
		}catch (Exception e){
			e.printStackTrace();
		}
		
	}
	
	View.OnClickListener mOnCancelClickListener;
	public void setOnCancelClickListener(View.OnClickListener listener) {
		mOnCancelClickListener = listener;
		if (btnCancel != null) {
			btnCancel.setOnClickListener(listener);
		}
	}

	private FacebookManager.LoginCallback mFacebookCallback = new FacebookManager.LoginCallback() {
		
		@Override
		public void onSuccess(AccessToken accessToken,
				Set<String> recentlyGrantedPermissions,
				Set<String> recentlyDeniedPermissions) {

			try {
				new UpgradeToFacebookTask(accessToken.getToken(), new Callback<LoginResponse>() {

					@Override
					public void onFailure(Call<LoginResponse> call, Throwable e) {
						handleException(activity, e.getMessage());
						try{
							startTime = System.currentTimeMillis();
							timerHandler.postDelayed(timerRunnable, 500);
						}catch (Exception e1){
							e.printStackTrace();
						}
					}

					@Override
					public void onResponse(Call<LoginResponse> call, Response<LoginResponse> response) {
						try {
							LoginResponse loginResponse = response.body();
							if (loginResponse.getError() != 0) {
								handleException(activity, loginResponse.getMessage());
								try{
									startTime = System.currentTimeMillis();
									timerHandler.postDelayed(timerRunnable, 500);
								}catch (Exception e){
									e.printStackTrace();
								}
							} else {
								MAccessToken accessToken = loginResponse.getAccessToken();
								GameConfigManager.getInstance().setAccessToken(accessToken.getToken());
                                new Thread(new Runnable() {
									@Override
									public void run() {
										EventClientManager.getInstance(activity).setMaxthoongbaos(accessToken.getToken());
									}
								}).start();

								Intent intent = new Intent(Constants.INTENT_FILTER);
								intent.putExtra("category", "login");
								LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);

								dismiss();
								isShowUpgrade = false;
							}
						}catch (Exception e){
							e.printStackTrace();
						}
					}
				}).execute();
			}catch (Exception e){
				e.printStackTrace();
			}
		}
		
		@Override
		public void onError(Throwable t) {
			Utils.hideLoading();
			try{
				startTime = System.currentTimeMillis();
				timerHandler.postDelayed(timerRunnable, 500);
			}catch (Exception e){
				e.printStackTrace();
			}
		}
		
		@Override
		public void onCancel() {
			Utils.hideLoading();
            try{
				startTime = System.currentTimeMillis();
                timerHandler.postDelayed(timerRunnable, 500);
            }catch (Exception e){
                e.printStackTrace();
            }
		}
	};
	
	
	private void handleException(Activity activity, String message) {
		try {
			Toast.makeText(activity, message, Toast.LENGTH_LONG).show();
			Utils.hideLoading();
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	@Override
		public void show() {
		try {
			isShowUpgrade = true;
			UserInfo userInfo = GameConfigManager.getInstance().getUserInfo();
			if(userInfo != null){
				super.show();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	public boolean isShowUpgrade(){
		return isShowUpgrade;
	}
}
