package com.kajime.libtsy.gui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.Toast;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.kajime.libtsy.api.GetPayItemTask;
import com.kajime.libtsy.component.FirebaseAnalyticsManager;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.js.CmdPayment;
import com.kajime.libtsy.model.Game;
import com.kajime.libtsy.model.MItemPayment;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.LibAppsflyerUtils;
import com.kajime.libtsy.utils.Utils;
import com.kajime.libtsy.R;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by Pc 02 on 12/26/2017.
 */

public class LibraryPayDialogFragment extends DialogFragment {

    private static final String TAG = LibraryPayDialogFragment.class.getSimpleName();
    private ImageButton btn_close;
    private ProgressBar progressBar;
    private Button btnReload;
    private GridView gridView;
    private View viewConnectionLost;
    ArrayList<MItemPayment> listItemPay = new ArrayList<>();
    int col , row;
    private String state  = "";

    public LibraryPayDialogFragment() {
    }

    @SuppressLint("ValidFragment")
    public LibraryPayDialogFragment(String state) {
        this.state = state;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        final View rootView = inflater.inflate(R.layout.payment_dialog_fragment, container, false);
        try {
            getDialog().getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
            getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
            btn_close = (ImageButton) rootView.findViewById(R.id.btn_close_pay);
            gridView = (GridView) rootView.findViewById(R.id.grid_view_pay);
            viewConnectionLost = rootView.findViewById(R.id.layout_connection_lost);
            btnReload = (Button) rootView.findViewById(R.id.btn_reload);
            progressBar = (ProgressBar) rootView.findViewById(R.id.progressbar_payment_native);

            String columnGrid = GameConfigManager.getInstance().getGameConfig().getP_m().getP_d().getCol();
            col = Integer.parseInt(columnGrid);
            String rowGrid = GameConfigManager.getInstance().getGameConfig().getP_m().getP_d().getRow();
            row = Integer.parseInt(rowGrid);
            int orientation = getResources().getConfiguration().orientation;
            if (orientation == Configuration.ORIENTATION_PORTRAIT) {
                gridView.setNumColumns(row);
                initFormPayment(row, col);
            }
            if (orientation == Configuration.ORIENTATION_LANDSCAPE) {
                gridView.setNumColumns(col);
                initFormPayment(col, row);
            }
            btn_close.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    closePayment();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
        return rootView;
    }

    @Override
    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(
                getActivity().getApplicationContext()).registerReceiver(
                receiver,
                new IntentFilter(Constants.INTENT_CLOSE_PAYMENT));
    }
    @Override
    public void onPause() {
        // TODO Auto-generated method stub
        super.onPause();
        LocalBroadcastManager.getInstance(
                getActivity().getApplicationContext()).unregisterReceiver(receiver);
    }

    BroadcastReceiver receiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            // TODO Auto-generated method stub
            try{
                boolean isClosePayment = intent.getBooleanExtra(Constants.INTENT_EXTRA_CLOSE_PAYMENT, false);
                if(isClosePayment) closePayment();
            } catch (Exception e) {
                // TODO: handle exception
                e.printStackTrace();
            }
        }

    };

    private void initFormPayment(final int col, final int row) {
        try {
            if (Utils.isOnline(getActivity())) {
                progressBar.setVisibility(View.VISIBLE);
                viewConnectionLost.setVisibility(View.GONE);
                new GetPayItemTask(getActivity(), state, new GetPayItemTask.Listener() {
                    @Override
                    public void onSuccess(ArrayList<MItemPayment> listItem) {
                        CmdPayment.getInstance().setState(state);
                        listItemPay = listItem;
                        PayGridViewItem adapter = new PayGridViewItem(getActivity(), listItemPay, col, row);
                        gridView.setAdapter(adapter);
                        LibAppsflyerUtils.getInstance().trackOpenFormPayment(getActivity());
                    }

                    @Override
                    public void onFailure(Throwable t) {
                    }
                }).execute();
            } else {
                viewConnectionLost.setVisibility(View.VISIBLE);
                progressBar.setVisibility(View.GONE);
                btnReload.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        int orientation = getResources().getConfiguration().orientation;
                        if (orientation == Configuration.ORIENTATION_PORTRAIT) {
                            initFormPayment(col, row);
                        }
                        if (orientation == Configuration.ORIENTATION_LANDSCAPE) {
                            initFormPayment(col, row);
                        }
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void closePayment() {
        LibAppsflyerUtils.getInstance().trackEvent(getActivity(), LibAppsflyerUtils.TRACK_PAYMENT_CLOSE, null);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(getActivity() , LibAppsflyerUtils.TRACK_PAYMENT_CLOSE , null);
        dismiss();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setStyle(STYLE_NO_TITLE , android.R.style.Theme_Translucent_NoTitleBar);
    }


    class PayGridViewItem extends BaseAdapter {
        private Activity mActivity;
        private ArrayList<MItemPayment> listItemPayment;
        private int col;
        int widthItem, heghtItem, width, height;

        public PayGridViewItem(Activity activity,
                               ArrayList<MItemPayment> listItemPayment, int col, int row) {
            this.mActivity = activity;
            this.listItemPayment = listItemPayment;
            width = getScreenWidthInPixel(mActivity);
            height = getScreenHeightInPixel(mActivity);
            widthItem = ((int) (width / col));
            heghtItem = (int) (height / row);
        }

        @Override
        public int getCount() {
            return listItemPayment.size();
        }

        @Override
        public Object getItem(int position) {
            return listItemPayment.get(position);
        }

        @Override
        public long getItemId(int position) {
            return 0;
        }

        @Override
        public View getView(final int position, View convertView, ViewGroup parent) {
            LayoutInflater inflater = (LayoutInflater) mActivity.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            View view;
            if (convertView == null) {
                view = new View(mActivity);
                view = inflater.inflate(R.layout.item_payment, null);
                try {
                    ImageView imgView = (ImageView) view.findViewById(R.id.img_item_pay);

                    Log.d(TAG, "width : " + widthItem + " , heght: " + heghtItem);
                    LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(widthItem, heghtItem);
                    imgView.setLayoutParams(params);
                    Glide.with(mActivity.getApplicationContext()).asBitmap()
                            .load(listItemPayment.get(position).getUrlPng())
                            .apply(new RequestOptions()
                                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                                    .fitCenter())
                            .listener(new RequestListener<Bitmap>() {
                                @Override
                                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                                    return false;
                                }

                                @Override
                                public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource) {
                                    if (listItemPayment.size() - 1 == position)
                                        progressBar.setVisibility(View.GONE);
                                    return false;
                                }
                            })

                            .into(imgView);

                    //TODO get isSubmit from config, test = false
                    Game a = GameConfigManager.getInstance().getGameConfig();
                    boolean isSubmit = Boolean.parseBoolean(GameConfigManager.getInstance().getGameConfig().getIsSubmit());

                    if (isSubmit == true) {
                        if (listItemPayment.get(position).getCategoryItem().equals("xx02")) {
                            imgView.setVisibility(View.GONE);
                        }
                    }
                    imgView.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            //iab payment
                            if (listItemPayment == null) return;
                            if (listItemPayment.get(position).getCategoryItem().equals("xx01")) {
                                try {
                                    JSONObject json = new JSONObject();
                                    json.put("product_id", listItemPayment.get(position).getProductId());
                                    Log.d(TAG, "json:" + json);
                                    CmdPayment.getInstance().khoidongNao(mActivity, json.toString());
//                                    Toast.makeText(mActivity, CmdPayment.getInstance().getState(), Toast.LENGTH_SHORT).show();
                                    HashMap<String, Object> eventValue = new HashMap<>();
                                    eventValue.put("product_id", listItemPayment.get(position).getProductId());
                                    LibAppsflyerUtils.getInstance().trackEvent(getActivity(), LibAppsflyerUtils.TRACK_PAYMENT_CLICK, eventValue);
                                    FirebaseAnalyticsManager.getInstance().firebaseEventTrack(getActivity() , LibAppsflyerUtils.TRACK_PAYMENT_CLICK , new HashMap<>(eventValue));
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                            if (listItemPayment.get(position).getCategoryItem().equals("xx02")) {
//                                String url = Constants.URL_PAYMENT;
                                String url = listItemPayment.get(position).getConfig().getUrl();
                                if (state.length() != 0) {
                                    url = url + "?state=" + state;
                                }
                                Log.d(TAG, url);
                                if (listItemPayment.get(position).getConfig().getType().equals("webview")) {
                                    Intent intent = new Intent(mActivity, LibraryActivity.class);
                                    intent.putExtra(LibraryActivity.KEY_DATA, "[{'action':'" + url + "'}]");
                                    intent.putExtra(LibraryActivity.KEY_ENABLE_AUTOHIDE_HEADER_BAR, false);
                                    intent.putExtra(LibraryActivity.KEY_ENABLE_SIDE_MENU, false);
                                    mActivity.startActivity(intent);
                                    getDialog().dismiss();
                                }else {
                                    Intent i = new Intent(Intent.ACTION_VIEW);
                                    i.setData(Uri.parse(url));
                                    startActivity(i);
                                }
                                getDialog().dismiss();
                            }
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }

            } else {
                view = (View) convertView;
            }
            return view;
        }

        public int getScreenWidthInPixel(Context context) {
            try {
                return context.getResources().getDisplayMetrics().widthPixels;
            } catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getScreenHeightInPixel(Context context) {
            try {
                return context.getResources().getDisplayMetrics().heightPixels - (int) (50 * DeviceUtils.getDensity(mActivity));
            } catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }
    }
}
