package com.kajime.libtsy.gui;

import android.animation.Animator;
import android.animation.Animator.AnimatorListener;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.ViewPager.SimpleOnPageChangeListener;
import android.support.v7.app.AppCompatActivity;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.ArrayAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.kajime.libtsy.LibrarySDK;
import com.kajime.libtsy.component.EventClientManager;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.LibAppsflyerUtils;
import com.kajime.libtsy.utils.NotificationUtils;
import com.kajime.libtsy.utils.Res;
import com.kajime.libtsy.utils.Utils;
import com.kajime.libtsy.R;
import com.facebook.FacebookSdk;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LibraryActivity extends AppCompatActivity {

	private static String TAG = LibraryActivity.class.getSimpleName();
	public static String KEY_DATA = "data";
	public static String KEY_ENABLE_AUTOHIDE_HEADER_BAR = "autohide_header_bar";
	public static String KEY_ENABLE_SIDE_MENU = "enable_side_menu";
	public static String KEY_ENABLE_TITLE = "enable_title";
	public static String KEY_IS_PAYMENT_FORM = "is_payment_form";
	public static String KEY_IS_LOGIN_FORM = "is_login_form";
	public static String KEY_IS_DASHBOARD_FORM = "is_dashboard_form";

	public static boolean shouldReload = false;

	private RelativeLayout layoutRoot;
	private View layoutMain, layoutContent;
	private ImageButton btnBack, btnClose;
	private SideMenuAdapter lvAdapter;
	private LibraryPagerFragment fragContent;
	private MobPagerAdapter adapter;

	private float density;

	private int currentPage;
	private boolean isEnableAutohideHeaderBar = false, isEnableSideMenu = true, isEnableTitle = true;
	private boolean isScrollAnimating;
	private boolean isLockingHeaderBar;
	private boolean isLoginForm = false, isDashboardForm = false,
			isPaymentForm = false;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_mobile);

		FacebookSdk.sdkInitialize(getApplicationContext());

		Bundle bundle = getIntent().getExtras();
		if (bundle != null) {
			isEnableAutohideHeaderBar = bundle.getBoolean(
					KEY_ENABLE_AUTOHIDE_HEADER_BAR, true);
			isEnableSideMenu = bundle.getBoolean(KEY_ENABLE_SIDE_MENU, true);
			isEnableTitle = bundle.getBoolean(KEY_ENABLE_SIDE_MENU, true);
			isLoginForm = bundle.getBoolean(KEY_IS_LOGIN_FORM);
			isDashboardForm = bundle.getBoolean(KEY_IS_DASHBOARD_FORM);
			isPaymentForm = bundle.getBoolean(KEY_IS_PAYMENT_FORM);
		}

		layoutRoot = (RelativeLayout) findViewById(R.id.layout_root);
		layoutMain = findViewById(R.id.layout_main);
		layoutContent = findViewById(R.id.layout_content);

		btnBack = (ImageButton) findViewById(R.id.btn_back);
		btnClose = (ImageButton) findViewById(R.id.btn_close);

		try{
			density = DeviceUtils.getDensity(this);


			initHeaderBar();

			// CONTENT
			fragContent = new LibraryPagerFragment(this);
			fragContent.addOnPageChangeListener(mOnPageChangeListener);
			fragContent.setWebEventListener(mWebEventListener);

			FragmentManager fm = getSupportFragmentManager();
			FragmentTransaction ft = fm.beginTransaction();
			ft.add(layoutContent.getId(), fragContent, TAG_FRAGMENT);
			ft.commit();
			String data = "";
			try {
				data = getIntent().getExtras().getString(KEY_DATA);
				JSONArray items = new JSONArray(data);
				loadUrls(items);
			} catch (Exception e) {
				e.printStackTrace();
			}

		}catch (Exception e){
			e.printStackTrace();
		}
		if(isLoginForm) LibAppsflyerUtils.getInstance().trackOpenFormLogin(this);
	}

	@Override
	protected void onResume() {
		super.onResume();
		try{
			LocalBroadcastManager.getInstance(this).registerReceiver(
					mBroadcastReceiver, new IntentFilter(Constants.INTENT_FILTER));
			Intent intent = new Intent(Constants.INTENT_FILTER);
			intent.putExtra("category", "float_button");
			intent.putExtra("message", "hide");
			LocalBroadcastManager.getInstance(this).sendBroadcast(intent);
			if (shouldReload) {
				reload();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	@Override
	protected void onPause() {
		try{
			LocalBroadcastManager.getInstance(this).unregisterReceiver(
					mBroadcastReceiver);
		}catch (Exception e){
			e.printStackTrace();
		}
		super.onPause();
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		try{
			LibrarySDK.getInstance().onActivityResult(requestCode, resultCode, data);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

//	@TargetApi(19)
//	public void onWindowFocusChanged(boolean hasFocus) {
//		try{
//			if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
//				if (hasFocus) {
//					getWindow().getDecorView().setSystemUiVisibility(
//							View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
//									| View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
//									| View.SYSTEM_UI_FLAG_FULLSCREEN
//									| View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
//				}
//			}
//		}catch (Exception e){
//			e.printStackTrace();
//		}
//	}

	@Override
	public void onBackPressed() {
		try{
			Log.i(TAG, "onBackPressed:" + currentPage);
			LibraryWebFragment fragWeb = adapter.getItem(currentPage);
			if (fragWeb.canGoBack()) {
				fragWeb.goBack();
			} else {
				LibrarySDK.getInstance().close();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private String TAG_FRAGMENT = "fragment_web";

	public void loadUrls(JSONArray items) {
		try{
			if (adapter == null) {
				adapter = new MobPagerAdapter(getSupportFragmentManager());
			}
			currentPage = 0;
			JSONArray revItems = new JSONArray();
			for (int i = items.length() - 1; i >= 0; i--) {
				try {
					JSONObject item = items.getJSONObject(i);
					revItems.put(item);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			for (int i = revItems.length() - 1; i >= 0; i--) {
				try {
					JSONObject item = revItems.getJSONObject(i);
					if(item.has("id")){
						if (NotificationUtils.hasNtf(this, item.getInt("id"))) {
							currentPage = i;
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			try {
				adapter.setItems(revItems);
				fragContent.setAdapter(adapter, currentPage);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void reload() {
		try{
			shouldReload = false;
			for (int i = 0; i < adapter.getCount(); i++) {
				LibraryWebFragment frag = (LibraryWebFragment) adapter.getItem(i);
				frag.reload();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void initHeaderBar() {
		try{
			btnBack.setOnClickListener(new OnClickListener() {

				@Override
				public void onClick(View v) {
					onBackPressed();
				}
			});
			btnClose.setOnClickListener(new OnClickListener() {

				@Override
				public void onClick(View v) {
					try {
						// Log.d(TAG, "isForm : " + isLoginForm + "," +
						// isDashboardForm + " ," + isPaymentForm);
						if (isLoginForm) {
							// Log.d(TAG, "FORM LOGIN");
							LibAppsflyerUtils.getInstance().trackEvent(
									getApplicationContext(),
									LibAppsflyerUtils.TRACK_LOGIN_CLOSED, null);
							new Thread(new Runnable() {
								@Override
								public void run() {
									EventClientManager.getInstance(LibraryActivity.this).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, LibAppsflyerUtils.TRACK_LOGIN_CLOSED, null);
								}
							}).start();
							isLoginForm = false;
//						} else if (isDashboardForm) {
//							// Log.d(TAG, "FORM DASHBOARD");
//							AppsFlyerLib.getInstance().trackEvent(
//									getApplicationContext(),
//									Constants.STR_EVENT_CLOSE_DASHBOARD, null);
//							new Thread(new Runnable() {
//								@Override
//								public void run() {
//									EventClientManager.getInstance(LibraryActivity.this).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, Constants.STR_EVENT_CLOSE_DASHBOARD, null);
//								}
//							}).start();
//							isDashboardForm = false;
						} else if (isPaymentForm) {
							// Log.d(TAG, "FORM PAYMENT");
							LibAppsflyerUtils.getInstance().trackEvent(
									getApplicationContext(),
									LibAppsflyerUtils.TRACK_PAYMENT_CLOSE, null);
							new Thread(new Runnable() {
								@Override
								public void run() {
									EventClientManager.getInstance(LibraryActivity.this).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, LibAppsflyerUtils.TRACK_PAYMENT_CLOSE, null);
								}
							}).start();
							isPaymentForm = false;
						}
					} catch (Exception e) {
						// TODO: handle exception
						e.printStackTrace();
						isDashboardForm = false;
						isLoginForm = false;
						isPaymentForm = false;
					}

					LibrarySDK.getInstance().close();
				}
			});
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private SimpleOnPageChangeListener mOnPageChangeListener = new SimpleOnPageChangeListener() {

		@Override
		public void onPageSelected(int position) {
			try {
				if (position != currentPage) {
					currentPage = position;
//					prgBar.setVisibility(View.GONE);
					updateHeaderBar(position);

					LibraryWebFragment fragWeb = adapter.getItem(currentPage);

					mWebEventListener.onScrollChanged(fragWeb.getWebView(),
							fragWeb.getScrollX(), fragWeb.getScrollY(),
							fragWeb.getScrollX(), fragWeb.getScrollY());
				}
				int itemId = (int) adapter.getItemId(position);
				if (NotificationUtils.hasNtf(LibraryActivity.this, itemId)) {
					NotificationUtils.removeNtf(LibraryActivity.this, itemId);
					LibraryActivity.this.runOnUiThread(new Runnable() {

						@Override
						public void run() {
							fragContent.notifyTabsChanged();
						}
					});
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}
	};

	private LibraryWebFragment.EventListener mWebEventListener = new LibraryWebFragment.EventListener() {

		@Override
		public void onPageStarted(WebView view, String url, Bitmap favicon) {
			try {
				LibraryActivity.this.runOnUiThread(new Runnable() {

					@Override
					public void run() {
						LibraryWebFragment fragWeb = (LibraryWebFragment) adapter
								.getItem(currentPage);
						if (fragContent.countTabs() > 1 && !fragWeb.canGoBack()) {
							fragContent.showTabs(true);
							isEnableAutohideHeaderBar = true;
						} else {
							fragContent.hideTabs(true);
							isEnableAutohideHeaderBar = false;
						}
//						btnShare.setVisibility(View.GONE);
					}
				});
				view.addJavascriptInterface(LibraryActivity.this, "android");
			}catch (Exception e){
				e.printStackTrace();
			}
		}

		@Override
		public void onProgressChanged(WebView view, int progress) {
			try {
				int pos = Integer.parseInt((String) view.getTag());
				if (pos == currentPage) {
					updateHeaderBar(pos);
//					progress = Math.max(1, progress);
//					prgBar.setProgress(progress);
//					if (progress == 100) {
//						hideProgressBar();
//					} else {
//						showProgressBar();
//					}
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}

		@Override
		public void onPageFinished(WebView view, String url) {
			try {
				int pos = Integer.parseInt((String) view.getTag());
				if (pos == currentPage) {
					updateHeaderBar(pos);
//					hideProgressBar();
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}

		@Override
		public void onScrollChanged(WebView view, int l, int t, int oldl,
									int oldt) {
			try {
				if (!isEnableAutohideHeaderBar)
					return;
				if (isLockingHeaderBar)
					return;
				LibraryWebView webView = (LibraryWebView) view;
				int maxt = webView.computeVerticalScrollRange();
			}catch (Exception e){
				e.printStackTrace();
			}
		}

		@Override
		public void onSizeChanged(WebView view, int w, int h, int oldw, int oldh) {
		}

	};

	private AnimatorListener mHeaderAnimatorListener = new AnimatorListener() {

		@Override
		public void onAnimationStart(Animator animator) {
			try {
				isScrollAnimating = true;
				LibraryActivity.this.runOnUiThread(new Runnable() {

					@Override
					public void run() {
						((ViewGroup) layoutMain).updateViewLayout(
								layoutContent,
								new RelativeLayout.LayoutParams(
										LayoutParams.MATCH_PARENT, layoutMain
										.getHeight()));
					}
				});
			}catch (Exception e){
				e.printStackTrace();
			}
		}

		@Override
		public void onAnimationRepeat(Animator animator) {
		}

		@Override
		public void onAnimationEnd(Animator animator) {
			try {
				LibraryActivity.this.runOnUiThread(new Runnable() {

					@Override
					public void run() {
						((ViewGroup) layoutMain)
								.updateViewLayout(
										layoutContent,
										new RelativeLayout.LayoutParams(
												LayoutParams.MATCH_PARENT,
												(layoutMain.getHeight())));
						fragContent.updateTabs();
						isScrollAnimating = false;
					}
				});
			}catch (Exception e){
				e.printStackTrace();
			}
		}

		@Override
		public void onAnimationCancel(Animator animator) {
		}
	};
	private boolean isShowingOfferWall;

	private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver() {

		@Override
		public void onReceive(Context context, Intent intent) {
			try {
				String category = intent.getStringExtra("category");
				Log.d(TAG, "mBroadcastReceiver category: " + category);
				if ("mobOpenOfferWall".equalsIgnoreCase(category)) {
					isShowingOfferWall = true;
				} else if ("float_button".equalsIgnoreCase(category)) {
					// do Nothing
				} else {
					isShowingOfferWall = false;
				}
				if ("gcm".equalsIgnoreCase(category)) {
					String strId = intent.getStringExtra("id");
					if (strId != null) {
						fragContent.notifyTabsChanged();
					}
				} else if ("dashboard".equalsIgnoreCase(category)) {
					try {
						fragContent.hideTabs(false);
					} catch (Exception e) {
						e.printStackTrace();
					}
					try {
						String strUrls = intent.getStringExtra("urls");
						JSONArray urls = new JSONArray(strUrls);
						loadUrls(urls);
					} catch (Exception e) {
						e.printStackTrace();
					}
				} else if ("finish_facebook_upgrade".equalsIgnoreCase(category)) {
					finish();
				} else if ("dashboard_close".equalsIgnoreCase(category)) {
					finish();
				}else if ("reload".equalsIgnoreCase(category)) {
					reload();
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}
	};

	private void updateHeaderBar(int pos) {
		try {
			final LibraryWebFragment fragWeb = (LibraryWebFragment) adapter
					.getItem(pos);
			if (fragWeb != null && fragWeb.isAdded()) {
				this.runOnUiThread(new Runnable() {

					@Override
					public void run() {
						String title = fragWeb.getTitle();
						if (title.contains(Constants.DOMAIN_NAME)
								|| title.equalsIgnoreCase("about:blank")
								|| title.equalsIgnoreCase("website not available")
								|| title.contains("data:text/html")
								|| title.startsWith("http://")
								|| title.startsWith("https://")) {
							title = "";
						}
						if (!Utils.isOnline(getApplicationContext())) {
							title = "Website not available";
						}

//						txtTitle.setText(title);
						if (fragWeb.canGoBack()) {
							btnBack.setVisibility(View.VISIBLE);
//							btnMenu.setVisibility(View.GONE);
						} else {
							btnBack.setVisibility(View.GONE);
//							if (isEnableSideMenu) {
//								btnMenu.setVisibility(View.VISIBLE);
//							}
						}
					}
				});

				String inject = ""
						+ "if (typeof getShareUrl === 'function') {							"
						+ "	try {															"
						+ "		window.android.onGetShareUrl(getShareUrl());				"
						+ "	} catch (err) {													"
						+ "		window.android.onGetShareUrl('');							"
						+ "		console.log(err);											"
						+ "	}																" + "} else {															"
						+ "	window.android.onGetShareUrl('');								"
						+ "}																	";
				fragWeb.invokeJavascript(inject);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void showProgressBar() {
		try {
			LibraryActivity.this.runOnUiThread(new Runnable() {

				@Override
				public void run() {
					try {
//						prgBar.setVisibility(View.VISIBLE);
					}catch (Exception e){
						e.printStackTrace();
					}
				}
			});
		}catch (Exception e){
			e.printStackTrace();
		}
	}

//	private void hideProgressBar() {
//		try {
//			new Handler().postDelayed(new Runnable() {
//
//				@Override
//				public void run() {
//					LibraryActivity.this.runOnUiThread(new Runnable() {
//
//						@Override
//						public void run() {
//							try {
//								prgBar.setVisibility(View.GONE);
//							}catch (Exception e){
//								e.printStackTrace();
//							}
//						}
//					});
//				}
//			}, 500);
//		}catch (Exception e){
//			e.printStackTrace();
//		}
//	}

	// private OfferWall offerWall;
	private boolean isOfferWallOpened = false;

	@JavascriptInterface
	public void onGetShareUrl(String value) {
		try {
			JSONObject obj = new JSONObject(value);
			final String shareUrl = obj.getString("url");
			final String shareTitle = obj.getString("title");
//			btnShare.setOnClickListener(new OnClickListener() {
//
//				@Override
//				public void onClick(View v) {
//					Intent intent = new Intent(Intent.ACTION_SEND);
//					intent.setType("text/plain");
//					intent.putExtra(Intent.EXTRA_TEXT, shareUrl);
//					intent.putExtra(android.content.Intent.EXTRA_SUBJECT,
//							shareTitle);
//					startActivity(Intent.createChooser(intent, "Share"));
//				}
//			});
			this.runOnUiThread(new Runnable() {

				@Override
				public void run() {
//					if (TextUtils.isEmpty(shareUrl)) {
//						btnShare.setVisibility(View.GONE);
//					} else {
//						btnShare.setVisibility(View.VISIBLE);
//					}
				}
			});
		} catch (JSONException e) {
//			this.runOnUiThread(new Runnable() {
//
//				@Override
//				public void run() {
//					btnShare.setVisibility(View.GONE);
//				}
//			});
		}
	}

	private class SideMenuModel {
		private int id;
		private int[] ids;
		private String iconUrl;
		private String label;
		private String command;
		private String params;
		// private ArrayList<MobUrl> dataset;
		private JSONArray items;

		public int[] getIds() {
			return ids;
		}

		public void setIds(int[] ids) {
			this.ids = ids;
		}

		int type = DEFAULT;

		public SideMenuModel(int id, String imageUrl, String label) {
			this(id, imageUrl, label, DEFAULT);
		}

		public SideMenuModel(int id, String imageUrl, String label, int type) {
			this.id = id;
			this.iconUrl = imageUrl;
			this.label = label;
			this.type = type;
		}

		public int getId() {
			return id;
		}

		public void setType(int type) {
			this.type = type;
		}

		public void setItems(JSONArray items) {
			this.items = items;
		}

		public void setAction(String command, String params) {
			this.command = command;
			this.params = params;
		}

		public String getCommand() {
			return command;
		}

		public String getParams() {
			return params;
		}

		public boolean isTabbed() {
			return (items != null && items.length() > 1);
		}

		public boolean hasNtf() {
			if (NotificationUtils.hasNtf(LibraryActivity.this, id)) {
				return true;
			}
			if (isTabbed()) {
				for (int i = 0; i < items.length(); i++) {
					try {
						JSONObject item = items.getJSONObject(i);
						int id = item.getInt("id");
						if (NotificationUtils.hasNtf(LibraryActivity.this, id)) {
							return true;
						}
					} catch (JSONException e) {
						e.printStackTrace();
					}
				}
			}
			return false;
		}

		public JSONArray getItems() {
			return items;
		}

		public String getLabel() {
			return label;
		}

		static final int DEFAULT = 0;
		static final int EXTERNAL = 1;
	}

	private class SideMenuAdapter extends ArrayAdapter<SideMenuModel> {

		private Activity context;
		private List<SideMenuModel> items;

		public SideMenuAdapter(Activity activity, List<SideMenuModel> items) {
			super(activity, R.layout.sidemenu_item);
			this.context = activity;
			this.items = items;
		}

		@Override
		public SideMenuModel getItem(int position) {
			return items.get(position);
		}

		@Override
		public int getCount() {
			return items.size();
		}

		@SuppressLint("InflateParams")
		@Override
		public View getView(int position, View convertView, ViewGroup parent) {
			LayoutInflater inflator = context.getLayoutInflater();
			View v = inflator.inflate(R.layout.sidemenu_item, null);
			ImageView imageView = (ImageView) v.findViewById(R.id.image);
			imageView.setScaleType(ImageView.ScaleType.FIT_XY);
			TextView textView = (TextView) v.findViewById(R.id.label);
			ImageView imageView2 = (ImageView) v.findViewById(R.id.image2);

			textView.setText(items.get(position).label);
			Glide.with(getApplicationContext()).load(items.get(position).iconUrl)
					.into(imageView);
			switch (items.get(position).type) {
				case SideMenuModel.EXTERNAL:
					imageView2.setImageResource(R.drawable.ic_external_sm);
					imageView2.setVisibility(View.VISIBLE);
					break;
				case SideMenuModel.DEFAULT:
				default:
					imageView2.setVisibility(View.GONE);
					break;
			}
			// if (items.get(position).hasNtf()) {
			try {
				for (int i = 0; i < items.get(position).getIds().length; i++) {
					if (NotificationUtils.hasNtf(context, items.get(position)
							.getIds()[i])) {
						imageView2.setImageResource(R.drawable.ic_notification);
						imageView2.setVisibility(View.VISIBLE);
					}
				}
				if (NotificationUtils.hasNtf(context, items.get(position).getId())) {
					imageView2.setImageResource(R.drawable.ic_notification);
					imageView2.setVisibility(View.VISIBLE);
				}
			}catch (Exception e){
				e.printStackTrace();
			}
			return v;
		}
	}

	private class MobPagerAdapter extends FragmentPagerAdapter {

		private ArrayList<LibraryWebFragment> fragments;
		private FragmentManager fm;
		private JSONArray items;
		{
			fragments = new ArrayList<LibraryWebFragment>();
		}

		public MobPagerAdapter(FragmentManager fm) {
			super(fm);
			this.fm = fm;
		}

		public void setItems(JSONArray items) {
			releaseFragments();
			this.items = items;
			fragments = new ArrayList<LibraryWebFragment>();
			for (int i = 0; i < items.length(); i++) {
				try {
					JSONObject item = items.getJSONObject(i);
					String url = item.getString("action");
					LibraryWebFragment frag = new LibraryWebFragment(url);
					frag.setEventListener(mWebEventListener);
					frag.setWebViewTag(i + "");
					fragments.add(frag);
				} catch (JSONException e) {
					e.printStackTrace();
					Log.d(TAG, "crash on function setItems");
				}
			}
		}

		@Override
		public LibraryWebFragment getItem(int position) {
			try {
				return fragments.get(position);
			} catch (Exception e) {
				return null;
			}
		}

		@Override
		public long getItemId(int position) {
			try {
				return items.getJSONObject(position).getInt("id");
			} catch (Exception e) {
				return -1;
			}
		}

		@Override
		public int getCount() {
			try {
				return fragments.size();
			}catch (Exception e){
				e.printStackTrace();
				return 0;
			}
		}

		@Override
		public int getItemPosition(Object item) {
			return POSITION_NONE;
		}

		@Override
		public CharSequence getPageTitle(int position) {
			try {
				JSONObject item = items.getJSONObject(position);
				int id = item.getInt("id");
				if (item.has("title")) {
					String title = item.getString("title").toUpperCase(
							Locale.ENGLISH);
					if (NotificationUtils.hasNtf(LibraryActivity.this, id)) {

						Drawable image = Res.drawable(LibraryActivity.this,
								R.drawable.ic_notification_tab_strip);
						image.setBounds(0, 0, image.getIntrinsicWidth(),
								image.getIntrinsicHeight());
						SpannableString sb = new SpannableString(title + "  ");
						ImageSpan imageSpan = new ImageSpan(image,
								ImageSpan.ALIGN_BASELINE);
						sb.setSpan(imageSpan, title.length() + 1,
								title.length() + 2,
								Spannable.SPAN_INCLUSIVE_INCLUSIVE);
						return sb;
					}
					return title;
				} else {
					return "Tab " + position;
				}
			} catch (Exception e) {
				return "Tab " + position;
			}
		}

		private void releaseFragments() {
			try {
				if (fragments != null) {
					for (LibraryWebFragment frag : fragments) {
						frag.stopLoading();
						fm.beginTransaction().remove(frag).commit();
					}
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}
	}
}
