package com.kajime.libtsy.api;

import android.content.Context;
import android.util.Base64;

import com.kajime.libtsy.LibrarySDK;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.EncodedResponse;
import com.kajime.libtsy.model.LoginResponse;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.EncryptionUtils;
import com.kajime.libtsy.utils.LibAppsflyerUtils;
import com.kajime.libtsy.utils.Preference;
import com.kajime.libtsy.utils.Utils;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.HashSet;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

class RestfulApi {

	private static final String API_BASE_URL = "http://mars.navaqeta.com";
	
	private static RestfulApi INSTANCE;
	
	private PlfRestService restService;
	private static Retrofit retrofit;
		
	public static RestfulApi getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new RestfulApi();
		}
		return INSTANCE;
	}
	
	private RestfulApi() {
		OkHttpClient httpClient = getCommonClient();
		
		retrofit = new Retrofit.Builder()
			.baseUrl(API_BASE_URL)
			.addConverterFactory(GsonConverterFactory.create())
			.client(httpClient)
			.build();

		restService = retrofit.create(PlfRestService.class);
	}
	
	static OkHttpClient getCommonClient() {
		
		CookieManager cookieManager = new CookieManager();
		cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);

		OkHttpClient httpClient = new OkHttpClient.Builder()
			.addInterceptor(new Interceptor() {
			    @Override
			    public okhttp3.Response intercept(Chain chain) throws IOException {

			    	Context context = LibrarySDK.getApplicationContext();
			    	GameConfigManager config = GameConfigManager.getInstance();

			    	Request.Builder builder = chain.request()
			        		.newBuilder()
			        		.addHeader(Constants.NGUY_THIETBI_TEEN, Utils.stringNormalize(DeviceUtils.getDevice()))
			        		.addHeader(Constants.NGUY_THIETBI_HEEJDDIEEUFHANHF, Utils.stringNormalize(DeviceUtils.getOSInfo()))
			        		.addHeader(Constants.NGUY_THIETBI_DDOOJPHAANGIAIR, Utils.stringNormalize(DeviceUtils.getResolution(context)))
			        		.addHeader(Constants.NGUY_THUWVIEENJ_PHIEENBANR, Utils.stringNormalize(Utils.getSDKVersion(context)))
			        		.addHeader(Constants.NGUY_APP_PHIEENBANR, Utils.stringNormalize(Utils.getGameVersion(context)))
			        		.addHeader(Constants.NGUY_APP_PHIEENBANR_CODE, Utils.stringNormalize(Utils.getGameVersionCode(context)))
			        		.addHeader(Constants.NGUY_MANGJ, Utils.stringNormalize(Utils.getNetwork(context)))
			        		.addHeader(Constants.NGUY_CHIEUF_THIEETSBIJ, Utils.stringNormalize(DeviceUtils.getScreenOrientation(context) + ""))
			        		.addHeader(Constants.NGUY_NHAFPHAANPHOOIS, Utils.stringNormalize(Utils.getReferrer(context)))
							.addHeader(Constants.NGUY_THUWVIEENJ_NGOONNGUWX , Utils.stringNormalize(DeviceUtils.getLanguage()))
							.addHeader(Constants.NGUY_AD_MAX , Utils.stringNormalize(DeviceUtils.getAdvertisingID(context)));

					if(GameConfigManager.getInstance().getAppKey(context) != null){
						builder.addHeader(Constants.NGUY_THUWVIEENJ_CHIAFKHOAS, Utils.stringNormalize(GameConfigManager.getInstance().getAppKey(context)));
					}

			    	if (config.getAccessToken() != null) {
			    		builder.addHeader(Constants.NGUY_TAIKHOAN_MAXTHOONGBAOS, Utils.stringNormalize(config.getAccessToken()));
			    	}

			    	if (config.getCharacterInfo().getRoleId() != null) {
			    		builder.addHeader(Constants.NGUY_NHANVAT_MAX, Utils.stringNormalize(config.getCharacterInfo().getRoleId()));
			    	}

			    	if (config.getCharacterInfo().getAreaId() != null) {
			    		builder.addHeader(Constants.NGUY_MAYCHU_MAX, Utils.stringNormalize(config.getCharacterInfo().getAreaId()));
			    	}

			    	if (config.getCharacterInfo().getRoleName() != null) {
			    		builder.addHeader(Constants.NGUY_NHANVAT_TEEN, Utils.stringNormalize(config.getCharacterInfo().getRoleName()));
			    	}

					if (config.getCharacterInfo().getAreaName() != null) {
						builder.addHeader(Constants.NGUY_MAYCHU_TEEN, Utils.stringNormalize(config.getCharacterInfo().getAreaName()));
					}
					if (LibAppsflyerUtils.getInstance().getAppsflyerId(context) != null) {
						builder.addHeader(Constants.NGUY_AF_MAX, LibAppsflyerUtils.getInstance().getAppsflyerId(context));
					}


			        Request request = builder.build();
			        return chain.proceed(request);
			    }
			})
			.addInterceptor(new Interceptor() {
				@Override
				public Response intercept(Chain chain) throws IOException {
					Context c = LibrarySDK.getApplicationContext();
					Request.Builder builder = chain.request().newBuilder();
					HashSet<String> preferences = (HashSet<String>) Preference
							.getStringSet(c, Constants.SHARED_PREF_COOKIES,
									new HashSet<String>());
					for (String cookie : preferences) {
						builder.addHeader("Cookie", cookie);
					}

					return chain.proceed(builder.build());
				}
			})
			.addInterceptor(new Interceptor() {
				@Override
				public Response intercept(Chain chain) throws IOException {
					Response originalResponse = chain.proceed(chain.request());

					if (!originalResponse.headers("Set-Cookie").isEmpty()) {
						Context c = LibrarySDK.getApplicationContext();
						HashSet<String> cookies = new HashSet<String>();

						for (String header : originalResponse.headers("Set-Cookie")) {
							cookies.add(header);
						}

						Preference.save(c, Constants.SHARED_PREF_COOKIES, cookies);
					}

					return originalResponse;
				}
			})
			.build();
		return httpClient;
	}

	static String decode(String responseBody) {
		try {
			JSONObject objEncode = new JSONObject(responseBody);
			if (objEncode.has("data")) {
				String data = objEncode.getString("data");
				byte[] decodeFromBase64 = Base64.decode(data, Base64.DEFAULT);
				return EncryptionUtils.decryptionDataBlowfish(decodeFromBase64);
			}
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return null;
	}


	public Call<ResponseBody> saveEventClient(String data){
		return restService.saveEventClient(data);
	}

	public Call<EncodedResponse> getInfoBeforeAuthen(String sign) {
		return restService.getInfoBeforeAuthen(sign);
	}

	public Call<EncodedResponse> getInfoAfterAuthen(String sign) {
		return restService.getInfoAfterAuthen(sign);
	}

	public Call<ResponseBody> saveGCM(String regId) {
		return restService.saveGCM(regId);
	}

	public Call<ResponseBody> saveCharacter(String roleId, String areaId, String roleName, String areaName) {
		return restService.saveCharacter(roleId, areaId, roleName, areaName);
	}

	public Call<ResponseBody> processGooglePayment(String receipt, String state) {
		return restService.googleRetrieveReceipt(receipt, state);
	}

	public Call<LoginResponse> upgradeToFacebook(String token) {
		return restService.upgradeToFacebook(token, "true");
	}

	public Call<EncodedResponse> getPayItem(String state) {
		return restService.getPayItem(state);
	}

	public Call<EncodedResponse> getIngameNotiList() {
		return restService.getIngameNoti();
	}

	private interface PlfRestService {
		@FormUrlEncoded
		@POST("/plf/VictoricaTds/clientLuu.json")
		Call<ResponseBody> saveEventClient(
				@Field("data") String data
		);

		@GET("/plf/VictoricaTds/starts.json")
		Call<EncodedResponse> getInfoBeforeAuthen(
				@Query("sign") String sign
		);

		@POST("/plf/VictoricaTds/ends.json")
		Call<EncodedResponse> getInfoAfterAuthen(
				@Query("sign") String sign
		);

		@FormUrlEncoded
		@POST("/plf/VictoricaTds/luuTkFCM.json")
		Call<ResponseBody> saveGCM(
				@Field("regid") String regId
		);

		@FormUrlEncoded
		@POST("/plf/VictoricaTds/luuChar.json")
		Call<ResponseBody> saveCharacter(
				@Field("roleid") String roleId,
				@Field("areaid") String areaId,
				@Field("rolename") String roleName,
				@Field("areaname") String areaName
		);

		@FormUrlEncoded
		@POST("/plf/VictoricaTds/gonap.json")
		Call<ResponseBody> googleRetrieveReceipt(
				@Field("transaction_receipt") String receipt,
				@Query("state") String state
		);

		@FormUrlEncoded
		@POST("/plf/userInfos/tofacebook")
		Call<LoginResponse> upgradeToFacebook(
				@Field("token") String token,
				@Field("native") String isJson
		);

		@GET("/plf/Playmans/ellay.json")
		Call<EncodedResponse> getPayItem(
				@Query("state") String state
		);

		@GET("/plf/games/push_ms.json")
		Call<EncodedResponse> getIngameNoti(
		);
	}
	
}
