package com.kajime.libtsy.api;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;

import com.kajime.libtsy.LibrarySDK;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.EncodedResponse;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.EncryptionUtils;
import com.kajime.libtsy.utils.LibAppsflyerUtils;
import com.kajime.libtsy.utils.Utils;

import java.io.IOException;
import java.util.Map;

import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostTask extends AsyncTask<Void, Void, Void> {

	private String url;
	private Map<String, String> postParams;
	private boolean isEncrypted;
	private Callback callback;
	private boolean isInviteFriend = false;
	private String accountId;
	private Activity mActivity;

	public PostTask(String url) {
		this.url = url;
	}

	public PostTask(String url, boolean isEncrypted) {
		this.url = url;
		this.isEncrypted = isEncrypted;
	}

	public PostTask(String url, Map<String, String> postParams, boolean isEncrypted) {
		this.url = url;
		this.postParams = postParams;
		this.isEncrypted = isEncrypted;
	}

	public PostTask(Activity activity, String url, Map<String, String> postParams, boolean isEncrypted, Callback callback) {
		this.mActivity = activity;
		this.url = url;
		this.postParams = postParams;
		this.isEncrypted = isEncrypted;
		this.callback = callback;
	}
	public PostTask(Activity activity, String url, Map<String, String> postParams, boolean isEncrypted, boolean isInviteFriend ,
                    String accountId, Callback callback ) {
		this.mActivity = activity;
		this.url = url;
		this.postParams = postParams;
		this.isEncrypted = isEncrypted;
		this.callback = callback;
		this.isInviteFriend = isInviteFriend;
		this.accountId = accountId;
	}
	public void setCallback(Callback callback) {
		this.callback = callback;
	}

	@Override
	protected Void doInBackground(Void... params) {
		try {
			Context c = LibrarySDK.getApplicationContext();
			OkHttpClient client = RestfulApi.getCommonClient();

			RequestBody formBody;
			if (postParams == null) {
				formBody = RequestBody.create(null, new byte[0]);
			} else {
				FormBody.Builder builder = new FormBody.Builder();
				for (String key : postParams.keySet()) {
					builder.add(key, postParams.get(key));
				}
				formBody = builder.build();
			}
			GameConfigManager config = GameConfigManager.getInstance();
			if (isEncrypted) {
				Uri uri = Uri.parse(url);
				if (uri.getQueryParameter("sign") == null) {
					if(isInviteFriend){
						url = uri
								.buildUpon()
								.appendQueryParameter("sign", EncryptionUtils.getSignedString(c, accountId))
								.build()
								.toString();
					}else{
						url = uri
								.buildUpon()
								.appendQueryParameter("sign", EncryptionUtils.getSignedString(c))
								.build()
								.toString();
					}

				}
				Request request = new Request.Builder()
					.url(url)
					.method("POST", formBody)
						.addHeader(Constants.NGUY_THIETBI_TEEN, Utils.stringNormalize(DeviceUtils.getDevice()))
						.addHeader(Constants.NGUY_THIETBI_HEEJDDIEEUFHANHF, Utils.stringNormalize(DeviceUtils.getOSInfo()))
						.addHeader(Constants.NGUY_THIETBI_DDOOJPHAANGIAIR, Utils.stringNormalize(DeviceUtils.getResolution(mActivity)))
						.addHeader(Constants.NGUY_THUWVIEENJ_PHIEENBANR, Utils.stringNormalize(Utils.getSDKVersion(mActivity)))
						.addHeader(Constants.NGUY_THUWVIEENJ_CHIAFKHOAS, Utils.stringNormalize(config.getAppKey(c)))
						.addHeader(Constants.NGUY_APP_PHIEENBANR, Utils.stringNormalize(Utils.getGameVersion(mActivity)))
						.addHeader(Constants.NGUY_APP_PHIEENBANR_CODE, Utils.stringNormalize(Utils.getGameVersionCode(mActivity)))
						.addHeader(Constants.NGUY_MANGJ, Utils.stringNormalize(Utils.getNetwork(mActivity)))
						.addHeader(Constants.NGUY_TAIKHOAN_MAXTHOONGBAOS, Utils.stringNormalize(config.getAccessToken()))
						.addHeader(Constants.NGUY_NHANVAT_MAX, Utils.stringNormalize(config.getCharacterInfo().getRoleId()))
						.addHeader(Constants.NGUY_MAYCHU_MAX, Utils.stringNormalize(config.getCharacterInfo().getAreaId()))
						.addHeader(Constants.NGUY_NHANVAT_TEEN, Utils.stringNormalize(config.getCharacterInfo().getRoleName()))
						.addHeader(Constants.NGUY_MAYCHU_TEEN, Utils.stringNormalize(config.getCharacterInfo().getAreaName()))
						.addHeader(Constants.NGUY_CHIEUF_THIEETSBIJ, Utils.stringNormalize(DeviceUtils.getScreenOrientation(mActivity) + ""))
						.addHeader(Constants.NGUY_THUWVIEENJ_NGOONNGUWX, Utils.stringNormalize(DeviceUtils.getLanguage()))
						.addHeader(Constants.NGUY_AD_MAX, Utils.stringNormalize(DeviceUtils.getAdvertisingID(mActivity)))
						.addHeader(Constants.NGUY_NHAFPHAANPHOOIS, Utils.stringNormalize(Utils.getReferrer(mActivity)))
						.addHeader(Constants.NGUY_AF_MAX, LibAppsflyerUtils.getInstance().getAppsflyerId(mActivity))
					.build();
				String result = client.newCall(request).execute().body().string();
				if(isInviteFriend){
					if(callback != null){
						callback.onSuccess("success");
					}
				}else{
					EncodedResponse response = EncodedResponse.parse(result);
					if (callback != null) {
						callback.onSuccess(response.getDecodedData());
					}
				}

			} else {
				Request request = new Request.Builder()
					.url(url)
						.addHeader(Constants.NGUY_THIETBI_TEEN, Utils.stringNormalize(DeviceUtils.getDevice()))
						.addHeader(Constants.NGUY_THIETBI_HEEJDDIEEUFHANHF, Utils.stringNormalize(DeviceUtils.getOSInfo()))
						.addHeader(Constants.NGUY_THIETBI_DDOOJPHAANGIAIR, Utils.stringNormalize(DeviceUtils.getResolution(mActivity)))
						.addHeader(Constants.NGUY_THUWVIEENJ_PHIEENBANR, Utils.stringNormalize(Utils.getSDKVersion(mActivity)))
						.addHeader(Constants.NGUY_THUWVIEENJ_CHIAFKHOAS, Utils.stringNormalize(config.getAppKey(c)))
						.addHeader(Constants.NGUY_APP_PHIEENBANR, Utils.stringNormalize(Utils.getGameVersion(mActivity)))
						.addHeader(Constants.NGUY_APP_PHIEENBANR_CODE, Utils.stringNormalize(Utils.getGameVersionCode(mActivity)))
						.addHeader(Constants.NGUY_MANGJ, Utils.stringNormalize(Utils.getNetwork(mActivity)))
						.addHeader(Constants.NGUY_TAIKHOAN_MAXTHOONGBAOS, Utils.stringNormalize(config.getAccessToken()))
						.addHeader(Constants.NGUY_NHANVAT_MAX, Utils.stringNormalize(config.getCharacterInfo().getRoleId()))
						.addHeader(Constants.NGUY_MAYCHU_MAX, Utils.stringNormalize(config.getCharacterInfo().getAreaId()))
						.addHeader(Constants.NGUY_NHANVAT_TEEN, Utils.stringNormalize(config.getCharacterInfo().getRoleName()))
						.addHeader(Constants.NGUY_MAYCHU_TEEN, Utils.stringNormalize(config.getCharacterInfo().getAreaName()))
						.addHeader(Constants.NGUY_CHIEUF_THIEETSBIJ, Utils.stringNormalize(DeviceUtils.getScreenOrientation(mActivity) + ""))
						.addHeader(Constants.NGUY_THUWVIEENJ_NGOONNGUWX, Utils.stringNormalize(DeviceUtils.getLanguage()))
						.addHeader(Constants.NGUY_AD_MAX, Utils.stringNormalize(DeviceUtils.getAdvertisingID(mActivity)))
						.addHeader(Constants.NGUY_NHAFPHAANPHOOIS, Utils.stringNormalize(Utils.getReferrer(mActivity)))
						.addHeader(Constants.NGUY_AF_MAX, LibAppsflyerUtils.getInstance().getAppsflyerId(mActivity))
					.method("POST", formBody)
					.build();
				String response = client.newCall(request).execute().body().string();
				if (callback != null) {
					callback.onSuccess(response);
				}
			}

		} catch (IOException e) {
			e.printStackTrace();
			if (callback != null) {
				callback.onFailure(e);
			}
		}
		return null;
	}
	

	public interface Callback {
		public void onSuccess(String response);
		public void onFailure(Throwable e);
	}

}