package com.kajime.libtsy.api;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.kajime.libtsy.LibrarySDK;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.EncodedResponse;
import com.kajime.libtsy.model.UserInfo;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.EncryptionUtils;
import com.kajime.libtsy.utils.NotificationUtils;
import com.kajime.libtsy.utils.Preference;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GetInfoAfterAuthenTask extends AsyncTask<Void, Void, Void> {

    private Listener callback;

    public GetInfoAfterAuthenTask(Listener callback) {
        this.callback = callback;
    }

    @Override
    protected Void doInBackground(Void... params) {
        Context c = LibrarySDK.getApplicationContext();
        String sign = EncryptionUtils.getSignedString(c);

        RestfulApi api = RestfulApi.getInstance();
        Call<EncodedResponse> call = api.getInfoAfterAuthen(sign);
        call.enqueue(new Callback<EncodedResponse>() {

            @Override
            public void onResponse(Call<EncodedResponse> call, Response<EncodedResponse> response) {

                try {
                    Context c = LibrarySDK.getApplicationContext();
                    UserInfo userInfo = null;
//                    Log.d("TAG", "code : " + response.code());
                    if (response.code() == 200 && response.body() != null) {

                        String responseBody = response.body().getDecodedData();
                        try {
                            JSONObject json = new JSONObject(responseBody);
                            if (json.has("saveLogin")) {
                                String saveLogin = json.getString("saveLogin");

//                                if (saveLogin.equals("true") || saveLogin.equals("1")) {

                                    if (json.has("userInfo")) {
                                        String userInfoStr = json.getString("userInfo");
                                        userInfo = UserInfo.parse(userInfoStr);
                                    }

                                    if (json.has("ntf")) {
                                        String ntf = json.getString("ntf");
                                        JSONArray ntfs = new JSONArray(ntf);
                                        for (int i = 0; i < ntfs.length(); i++) {
                                            JSONObject ntfObj = ntfs.getJSONObject(i);
                                            if (ntfObj.has("id") && ntfObj.has("noti")
                                                    && ntfObj.getBoolean("noti")) {
                                                NotificationUtils.addNtf(c, ntfObj.getInt("id"));
                                                GameConfigManager.getInstance().setHasUnreadNotifications(true);
                                            }
                                        }
                                    } else {
                                        GameConfigManager.getInstance().setHasUnreadNotifications(false);
                                    }

                                if (json.has("show_pu")) {
                                    Boolean isShowPopup = json.getBoolean("show_pu");
                                    GameConfigManager.getInstance().setShowPopup(isShowPopup);
                                }

                                if (json.has("show_qc")) {
                                    Boolean isShowAd = false;
                                    try{
                                        isShowAd = json.getBoolean("show_qc");
                                    }catch (Exception e){
                                        Log.d("AfterAuthen", "onResponse: show_qc not boolean");
                                        if(json.getInt("show_qc")==0){
                                            isShowAd = false;
                                        }else{
                                            isShowAd = true;
                                        }
                                    }
                                    GameConfigManager.getInstance().setShowAd(isShowAd);
                                }

                                    if (json.has("enable_dashboard")) {
                                        boolean value = json.getBoolean("enable_dashboard");
                                        Preference.save(c,
                                                Constants.SHARED_PREF_DB_ENABLED,
                                                value);
                                    } else {
                                        Preference.remove(c, Constants.SHARED_PREF_DB_ENABLED);
                                    }

                                if (json.has("new_link")) {
                                    GameConfigManager.getInstance().setNewsEventUrl(json.getString("new_link"));
                                }
//                                }
                            }
                        } catch (JSONException e) {
                            if (callback != null) {
                                callback.onFailure(e);
                            }
                        }

                        if (callback != null) {
                            callback.onSuccess(userInfo);
                        }

                    } else {
                        if (callback != null) {
                            Log.d("TAG", "ERROR when " + response.code());
                            callback.onFailure(new Exception());
                        }
                    }
                }catch (Exception e){
                    if (callback != null) {
                        callback.onFailure(e);
                    }
                    e.printStackTrace();
                }
            }

            @Override
            public void onFailure(Call<EncodedResponse> call, Throwable t) {
                if (callback != null) {
                    callback.onFailure(t);
                }
            }
        });
        return null;
    }

    public interface Listener {
        public void onSuccess(UserInfo userInfo);

        public void onFailure(Throwable t);
    }

}