/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.utils.debug;

import android.content.Context;
import android.content.res.AssetManager;
import java.io.InputStream;
import java.util.Properties;

public class DebugConfigs {
    private static final String TAG = "AD-SDK";
    private static final String PROPERTY_DEBUG = "debug";
    private static final String PROPERTY_TAG = "tag";
    private static final String CONFIG_FILE_NAME = "configs.properties";
    private static Properties properties = new Properties();

    public static boolean isDebugEnable(Context context) {
        try {
            Properties properties = DebugConfigs.getProperties(context);
            if (properties.isEmpty()) {
                return false;
            }
            return "true".equals(properties.getProperty(PROPERTY_DEBUG));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getTag(Context context) {
        try {
            Properties properties = DebugConfigs.getProperties(context);
            if (properties.isEmpty()) {
                return TAG;
            }
            if (properties.contains(PROPERTY_TAG)) {
                return properties.getProperty(PROPERTY_TAG);
            }
            return TAG;
        }
        catch (Exception e) {
            return TAG;
        }
    }

    private static Properties getProperties(Context context) throws Exception {
        if (!properties.isEmpty()) {
            return properties;
        }
        properties.load(context.getClassLoader().getResourceAsStream("META-INF/configs.properties"));
        if (!properties.isEmpty()) {
            return properties;
        }
        AssetManager assetManager = context.getAssets();
        InputStream inputStream = assetManager.open(CONFIG_FILE_NAME);
        properties.load(inputStream);
        return properties;
    }
}

