/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.model;

import android.util.Log;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MItemPayment {
    @SerializedName(value="xt")
    private String categoryItem;
    @SerializedName(value="product_id")
    private String productId;
    @SerializedName(value="ig")
    private String urlPng;
    @SerializedName(value="config")
    private Config config;

    public static ArrayList<MItemPayment> parse(String json) {
        ArrayList<MItemPayment> list = new ArrayList<MItemPayment>();
        if (json != null) {
            try {
                JSONArray jsonArray = new JSONArray(json);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    MItemPayment item = new MItemPayment();
                    JSONObject jsonObj = jsonArray.getJSONObject(i);
                    if (jsonObj.has("xt")) {
                        item.setCategoryItem(jsonObj.getString("xt").toString());
                    }
                    if (jsonObj.has("product_id")) {
                        item.setProductId(jsonObj.getString("product_id").toString());
                    }
                    if (jsonObj.has("ig")) {
                        item.setUrlPng(jsonObj.getString("ig").toString());
                    }
                    if (jsonObj.has("config")) {
                        String strConfig = jsonObj.getString("config");
                        JSONObject jsonConfig = new JSONObject(strConfig);
                        Config config = new Config();
                        Log.d((String)"TAG", (String)jsonConfig.toString());
                        if (jsonConfig.has("type")) {
                            String type = jsonConfig.getString("type");
                            config.setType(type);
                        }
                        if (jsonConfig.has("url")) {
                            String url = jsonConfig.getString("url");
                            config.setUrl(url);
                        }
                        item.setConfig(config);
                    }
                    list.add(item);
                }
                return list;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return list;
            }
        }
        return list;
    }

    public String getCategoryItem() {
        return this.categoryItem;
    }

    public void setCategoryItem(String categoryItem) {
        this.categoryItem = categoryItem;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getUrlPng() {
        return this.urlPng;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setUrlPng(String urlPng) {
        this.urlPng = urlPng;
    }

    public static class Config {
        @SerializedName(value="type")
        private String type;
        @SerializedName(value="url")
        private String url;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

