/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.component;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.google.ads.conversiontracking.AdWordsAutomatedUsageReporter;
import com.kajim.adssdk.AdsManager;
import com.kajime.libtsy.LibrarySDK;
import com.kajime.libtsy.component.FacebookManager;
import com.kajime.libtsy.component.GoogleAnalyticsManager;
import com.kajime.libtsy.component.GoogleAuthManager;
import com.kajime.libtsy.model.CharacterInfo;
import com.kajime.libtsy.model.Game;
import com.kajime.libtsy.model.UserInfo;
import com.kajime.libtsy.utils.Preference;

public final class GameConfigManager {
    private static final String TAG = GameConfigManager.class.getSimpleName();
    public static final String SHARED_PREF_MACCESS_TOKEN = "shared_pref_maccess_token";
    private static GameConfigManager INSTANCE;
    public static final String SHARED_PREF_APPKEY = "shared_pref_appkey";
    private String appkey;
    private Game gameConfig;
    private UserInfo userInfo;
    private CharacterInfo characterInfo;
    private String accessToken;
    private boolean hasUnreadNotifications;
    private String newsEventUrl = "";
    private boolean isShowPopup = false;
    private Boolean isShowQc = false;
    private String linkShowPopup;

    public static GameConfigManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GameConfigManager();
        }
        return INSTANCE;
    }

    public Boolean getShowAd() {
        return this.isShowQc;
    }

    public void setShowAd(Boolean showQc) {
        this.isShowQc = showQc;
    }

    public boolean isShowPopup() {
        return this.isShowPopup;
    }

    public void setShowPopup(boolean showPopup) {
        this.isShowPopup = showPopup;
    }

    public String getLinkShowPopup() {
        return this.linkShowPopup;
    }

    public void setLinkShowPopup(String linkShowPopup) {
        this.linkShowPopup = linkShowPopup;
    }

    public String getAppKey(Context context) {
        if (this.appkey == null || this.appkey.isEmpty()) {
            try {
                this.appkey = Preference.getString(context, SHARED_PREF_APPKEY);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.appkey;
    }

    public Boolean getShowPopup() {
        return this.isShowPopup;
    }

    public void setShowPopup(Boolean showPopup) {
        this.isShowPopup = showPopup;
    }

    public void setAppKey(Context context, String appkey) {
        this.appkey = appkey;
        try {
            Preference.save(context, SHARED_PREF_APPKEY, appkey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Game getGameConfig() {
        return this.gameConfig;
    }

    public void setGameConfig(Game gameConfig) {
        try {
            this.gameConfig = gameConfig;
            this.initLang(gameConfig.getLang());
            this.initGoogleAuth();
            this.initFacebook(gameConfig.getFacebookId());
            this.initGoogleAnalytics(new String[]{gameConfig.getGoogleAnalyticsId(), gameConfig.getGoogleAnalyticsIdTotal(), gameConfig.getGoogleAnalyticsIdLocal()});
            this.initAdwords(gameConfig.getAdwords());
            this.initAds(gameConfig.getAdsConfig());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAds(Game.AdsConfig config) {
        try {
            AdsManager.setApiKey((String)config.getApiKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void clearUserInfo() {
        this.userInfo = null;
    }

    public CharacterInfo getCharacterInfo() {
        if (this.characterInfo == null) {
            this.characterInfo = new CharacterInfo();
        }
        return this.characterInfo;
    }

    public void setCharacterInfo(CharacterInfo characterInfo) {
        this.characterInfo = characterInfo;
    }

    public void clearCharacterInfo() {
        this.characterInfo = null;
    }

    public String getAccessToken() {
        if (this.accessToken == null) {
            this.accessToken = "";
            try {
                Activity a = LibrarySDK.activity;
                this.accessToken = a != null ? Preference.getString((Context)a, SHARED_PREF_MACCESS_TOKEN) : Preference.getString(LibrarySDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        Activity a = LibrarySDK.activity;
        try {
            if (a != null) {
                Preference.save((Context)a, SHARED_PREF_MACCESS_TOKEN, accessToken);
            } else {
                Preference.save(LibrarySDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN, accessToken);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.accessToken = accessToken;
    }

    public void clearAccessToken() {
        try {
            Activity a = LibrarySDK.activity;
            if (a != null) {
                Preference.remove((Context)a, SHARED_PREF_MACCESS_TOKEN);
            } else {
                Preference.remove(LibrarySDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.accessToken = null;
    }

    public void clearLogin() {
        this.clearUserInfo();
        this.clearCharacterInfo();
        this.clearAccessToken();
    }

    public boolean isHasUnreadNotifications() {
        return this.hasUnreadNotifications;
    }

    public void setHasUnreadNotifications(boolean hasUnreadNotifications) {
        this.hasUnreadNotifications = hasUnreadNotifications;
    }

    public void clearUnreadNotifications() {
        this.hasUnreadNotifications = false;
    }

    public String getFacebookId() {
        return this.gameConfig.getFacebookId();
    }

    private void initFacebook(String facebookAppId) {
        try {
            Log.i((String)TAG, (String)"initFacebook");
            Activity a = LibrarySDK.activity;
            FacebookManager.getInstance().init(a.getApplicationContext(), facebookAppId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initGoogleAuth() {
        try {
            Activity a = LibrarySDK.activity;
            GoogleAuthManager.getInstance().init(a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initGoogleAnalytics(String id2) {
        this.initGoogleAnalytics(new String[]{id2});
    }

    private void initGoogleAnalytics(String[] ids) {
        try {
            Activity a = LibrarySDK.activity;
            if (a != null) {
                GoogleAnalyticsManager.getInstance().init(a.getApplicationContext());
            } else {
                GoogleAnalyticsManager.getInstance().init(LibrarySDK.getApplicationContext());
            }
            for (String id2 : ids) {
                GoogleAnalyticsManager.getInstance().addTracker(id2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAdwords(Game.AdwordsConfig config) {
        try {
            if (config != null) {
                Activity a = LibrarySDK.activity;
                String conversionId = config.getConversionId();
                if (a != null) {
                    AdWordsAutomatedUsageReporter.enableAutomatedUsageReporting((Context)a.getApplicationContext(), (String)conversionId);
                } else {
                    AdWordsAutomatedUsageReporter.enableAutomatedUsageReporting((Context)LibrarySDK.getApplicationContext(), (String)conversionId);
                }
                Log.d((String)TAG, (String)"initAdwords: config null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initLang(String lang) {
        try {
            if ("vie".equalsIgnoreCase(lang) || "vi".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("vie");
            } else if ("eng".equalsIgnoreCase(lang) || "en".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("eng");
            } else if ("mya".equalsIgnoreCase(lang) || "my".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("mya");
            } else if ("es_es".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("es_es");
            } else if ("zh".equalsIgnoreCase(lang) || "zh_cn".equalsIgnoreCase(lang) || "zh_tw".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("zh_cn");
            } else if ("th".equalsIgnoreCase(lang) || "tha".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("tha");
            } else if ("ind".equalsIgnoreCase(lang) || "id".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("ind");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getNewsEventUrl() {
        return this.newsEventUrl;
    }

    public void setNewsEventUrl(String newsEventUrl) {
        this.newsEventUrl = newsEventUrl;
    }
}

