/*
 * Decompiled with CFR 0.152.
 */
package com.kajime.libtsy.api;

import android.content.Context;
import android.util.Base64;
import com.kajime.libtsy.LibrarySDK;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.EncodedResponse;
import com.kajime.libtsy.model.LoginResponse;
import com.kajime.libtsy.utils.DeviceUtils;
import com.kajime.libtsy.utils.EncryptionUtils;
import com.kajime.libtsy.utils.LibAppsflyerUtils;
import com.kajime.libtsy.utils.Preference;
import com.kajime.libtsy.utils.Utils;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.HashSet;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

class RestfulApi {
    private static final String API_BASE_URL = "http://mars.navaqeta.com";
    private static RestfulApi INSTANCE;
    private PlfRestService restService;
    private static Retrofit retrofit;

    public static RestfulApi getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RestfulApi();
        }
        return INSTANCE;
    }

    private RestfulApi() {
        OkHttpClient httpClient = RestfulApi.getCommonClient();
        retrofit = new Retrofit.Builder().baseUrl(API_BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(httpClient).build();
        this.restService = (PlfRestService)retrofit.create(PlfRestService.class);
    }

    static OkHttpClient getCommonClient() {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        OkHttpClient httpClient = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Context context = LibrarySDK.getApplicationContext();
                GameConfigManager config = GameConfigManager.getInstance();
                Request.Builder builder = chain.request().newBuilder().addHeader("tsy-tresgsd", Utils.stringNormalize(DeviceUtils.getDevice())).addHeader("tsy-fasdfla", Utils.stringNormalize(DeviceUtils.getOSInfo())).addHeader("tsy-peqplpv", Utils.stringNormalize(DeviceUtils.getResolution(context))).addHeader("tsy-alaspfbb", Utils.stringNormalize(Utils.getSDKVersion(context))).addHeader("tsy-pdpkll", Utils.stringNormalize(Utils.getGameVersion(context))).addHeader("tsy-rwpelb", Utils.stringNormalize(Utils.getGameVersionCode(context))).addHeader("tsy-plpvadfga", Utils.stringNormalize(Utils.getNetwork(context))).addHeader("tsy-fsdfarwoo", Utils.stringNormalize(DeviceUtils.getScreenOrientation(context) + "")).addHeader("tsy-kkykykre", Utils.stringNormalize(Utils.getReferrer(context))).addHeader("tsy-apkgpfdo", Utils.stringNormalize(DeviceUtils.getLanguage())).addHeader("tsy-lfasldfkla", Utils.stringNormalize(DeviceUtils.getAdvertisingID(context)));
                if (GameConfigManager.getInstance().getAppKey(context) != null) {
                    builder.addHeader("X-Request", Utils.stringNormalize(GameConfigManager.getInstance().getAppKey(context)));
                }
                if (config.getAccessToken() != null) {
                    builder.addHeader("tsy-tofaae", Utils.stringNormalize(config.getAccessToken()));
                }
                if (config.getCharacterInfo().getRoleId() != null) {
                    builder.addHeader("tsy-asraf", Utils.stringNormalize(config.getCharacterInfo().getRoleId()));
                }
                if (config.getCharacterInfo().getAreaId() != null) {
                    builder.addHeader("tsy-fasvqwwqe", Utils.stringNormalize(config.getCharacterInfo().getAreaId()));
                }
                if (config.getCharacterInfo().getRoleName() != null) {
                    builder.addHeader("tsy-dfafasdf", Utils.stringNormalize(config.getCharacterInfo().getRoleName()));
                }
                if (config.getCharacterInfo().getAreaName() != null) {
                    builder.addHeader("tsy-daccwe", Utils.stringNormalize(config.getCharacterInfo().getAreaName()));
                }
                if (LibAppsflyerUtils.getInstance().getAppsflyerId(context) != null) {
                    builder.addHeader("tsy-asfkkkfsde", LibAppsflyerUtils.getInstance().getAppsflyerId(context));
                }
                Request request = builder.build();
                return chain.proceed(request);
            }
        }).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Context c = LibrarySDK.getApplicationContext();
                Request.Builder builder = chain.request().newBuilder();
                HashSet preferences = (HashSet)Preference.getStringSet(c, "shared_pref_cookies", new HashSet<String>());
                for (String cookie : preferences) {
                    builder.addHeader("Cookie", cookie);
                }
                return chain.proceed(builder.build());
            }
        }).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                if (!originalResponse.headers("Set-Cookie").isEmpty()) {
                    Context c = LibrarySDK.getApplicationContext();
                    HashSet<String> cookies = new HashSet<String>();
                    for (String header : originalResponse.headers("Set-Cookie")) {
                        cookies.add(header);
                    }
                    Preference.save(c, "shared_pref_cookies", cookies);
                }
                return originalResponse;
            }
        }).build();
        return httpClient;
    }

    static String decode(String responseBody) {
        try {
            JSONObject objEncode = new JSONObject(responseBody);
            if (objEncode.has("data")) {
                String data = objEncode.getString("data");
                byte[] decodeFromBase64 = Base64.decode((String)data, (int)0);
                return EncryptionUtils.decryptionDataBlowfish(decodeFromBase64);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Call<ResponseBody> saveEventClient(String data) {
        return this.restService.saveEventClient(data);
    }

    public Call<EncodedResponse> getInfoBeforeAuthen(String sign) {
        return this.restService.getInfoBeforeAuthen(sign);
    }

    public Call<EncodedResponse> getInfoAfterAuthen(String sign) {
        return this.restService.getInfoAfterAuthen(sign);
    }

    public Call<ResponseBody> saveGCM(String regId) {
        return this.restService.saveGCM(regId);
    }

    public Call<ResponseBody> saveCharacter(String roleId, String areaId, String roleName, String areaName) {
        return this.restService.saveCharacter(roleId, areaId, roleName, areaName);
    }

    public Call<ResponseBody> processGooglePayment(String receipt, String state) {
        return this.restService.googleRetrieveReceipt(receipt, state);
    }

    public Call<LoginResponse> upgradeToFacebook(String token) {
        return this.restService.upgradeToFacebook(token, "true");
    }

    public Call<EncodedResponse> getPayItem(String state) {
        return this.restService.getPayItem(state);
    }

    public Call<EncodedResponse> getIngameNotiList() {
        return this.restService.getIngameNoti();
    }

    private static interface PlfRestService {
        @FormUrlEncoded
        @POST(value="/plf/VictoricaTds/clientLuu.json")
        public Call<ResponseBody> saveEventClient(@Field(value="data") String var1);

        @GET(value="/plf/VictoricaTds/starts.json")
        public Call<EncodedResponse> getInfoBeforeAuthen(@Query(value="sign") String var1);

        @POST(value="/plf/VictoricaTds/ends.json")
        public Call<EncodedResponse> getInfoAfterAuthen(@Query(value="sign") String var1);

        @FormUrlEncoded
        @POST(value="/plf/VictoricaTds/luuTkFCM.json")
        public Call<ResponseBody> saveGCM(@Field(value="regid") String var1);

        @FormUrlEncoded
        @POST(value="/plf/VictoricaTds/luuChar.json")
        public Call<ResponseBody> saveCharacter(@Field(value="roleid") String var1, @Field(value="areaid") String var2, @Field(value="rolename") String var3, @Field(value="areaname") String var4);

        @FormUrlEncoded
        @POST(value="/plf/VictoricaTds/gonap.json")
        public Call<ResponseBody> googleRetrieveReceipt(@Field(value="transaction_receipt") String var1, @Query(value="state") String var2);

        @FormUrlEncoded
        @POST(value="/plf/userInfos/tofacebook")
        public Call<LoginResponse> upgradeToFacebook(@Field(value="token") String var1, @Field(value="native") String var2);

        @GET(value="/plf/Playmans/ellay.json")
        public Call<EncodedResponse> getPayItem(@Query(value="state") String var1);

        @GET(value="/plf/games/push_ms.json")
        public Call<EncodedResponse> getIngameNoti();
    }
}

