package com.kajime.libtsy.notification;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Vibrator;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;

import com.bumptech.glide.Glide;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;

import java.util.Map;

import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.NotificationUtils;
import com.kajime.libtsy.utils.Preference;
import com.kajime.libtsy.utils.Res;
import com.kajime.libtsy.R;
import com.kajime.libtsy.gui.LibraryActivity;

public class LibraryFirebaseMessagingService extends FirebaseMessagingService {

    private static final String TAG = LibraryFirebaseMessagingService.class
            .getSimpleName();
    public LibraryFirebaseMessagingService() {
    }

    protected int getDrawableSmall(Context c) {
        return Res.drawableResource(c, R.drawable.transparent);
    }

    @SuppressLint("MissingPermission")
    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        try {
            Context context = getApplicationContext();
            Log.i(TAG, "onMessage: " + remoteMessage);
            if (remoteMessage.getData().size() <= 0) return; // Vibrate for 30 ms
            Map<String, String> map = remoteMessage.getData();
            String title = map.get("title");
            String message = map.get("message");
            String id = map.get("id");
            String url = map.get("url");
            String timer = map.get("timer");
            String link = map.get("link");
//        String openDashboard = extras.getString("open_dashboard");

            if (link != null) {
                Preference.save(context, Constants.DEEPLINK, link);
            } else if (url != null) {
                Preference.save(context, Constants.DEEPLINK, url);
                Preference.save(context, LibraryActivity.KEY_ENABLE_TITLE, false);
            }

            Log.i(TAG, "id: " + id);
            Log.i(TAG, "title: " + title);
            Log.i(TAG, "message: " + message);
            Log.i(TAG, "url: " + url);
            Log.i(TAG, "timer: " + timer);

            //hiendv: load url image to cache first
            if (url != null) {
                Glide.with(context.getApplicationContext())
                        .load(url)
                        .downloadOnly(512, 256);
            }

            // Send broadcast
            Intent intent = new Intent(Constants.INTENT_FILTER);
            intent.putExtra("category", "gcm");
            intent.putExtra("id", id);
            intent.putExtra("title", title);
            intent.putExtra("mesage", message);
            LocalBroadcastManager.getInstance(context).sendBroadcast(intent);

            GameConfigManager.getInstance().setHasUnreadNotifications(true);
            try {
                if (!TextUtils.isEmpty(id)) {
                    NotificationUtils.addNtf(context, Integer.parseInt(id));
                }
            }catch (Exception e){
                e.printStackTrace();
            }

            if (!TextUtils.isEmpty(title)
                    || !TextUtils.isEmpty(message)) {
                if (url != null) {
                    NotificationUtils.getInstance(context)
                            .setMainClass(null)
                            .setMessage(message)
                            .setTitle(title)
                            .setImageUrl(url)
                            .setLink(link)
                            .setId(id)
                            .setSmallIcon(getDrawableSmall(context))
                            .showNotificationWithImage();
                } else {
                    NotificationUtils.getInstance(context)
                            .setMainClass(null)
                            .setMessage(message)
                            .setTitle(title)
                            .setLink(link)
                            .setId(id)
                            .setSmallIcon(getDrawableSmall(context))
                            .showNotification();
                }
                Vibrator v = (Vibrator) context
                        .getSystemService(Context.VIBRATOR_SERVICE);
                if (v != null)
                    v.vibrate(30);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
