package com.kajime.libtsy.notification;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.appsflyer.AppsFlyerLib;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;

import com.kajime.libtsy.api.RegisterTokenAndTask;

public class LibraryFirebaseInstanceIDService extends FirebaseInstanceIdService{
    private String TAG = "LibraryFirebaseInstanceIDService";
    private static LibraryFirebaseInstanceIDService INSTANCE;

    public static LibraryFirebaseInstanceIDService getInstance(){
        if(INSTANCE == null) INSTANCE = new LibraryFirebaseInstanceIDService();
        return INSTANCE;
    }
    @Override
    public void onTokenRefresh() {
        // Get updated InstanceID token.
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();
        Log.i(TAG, "Refreshed token: " + refreshedToken);
        sendRegistrationToServer(getApplicationContext(), refreshedToken);
    }

    public void sendRegistrationToServer(Context activity, String refreshedToken) {
        Log.i(TAG, "sendToken/RegId to server: " + refreshedToken);
        AppsFlyerLib.getInstance().updateServerUninstallToken(activity, refreshedToken);
        if (!TextUtils.isEmpty(refreshedToken)) {
            (new RegisterTokenAndTask(refreshedToken)).execute();
        }
    }

}