package com.kajime.libtsy.api;

import android.os.AsyncTask;
import android.text.TextUtils;

import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.model.CharacterInfo;

import java.io.IOException;

import okhttp3.ResponseBody;
import retrofit2.Call;

public class SaveCharacterTask extends AsyncTask<Void, Void, Void> {
	
	private String roleId;
	private String areaId;
	private String roleName;
	private String areaName;

	public SaveCharacterTask(String areaId, String areaName, String roleId, String roleName) {
		this.roleId = roleId;
		this.areaId = areaId;
		this.roleName = roleName;
		this.areaName = areaName;
	}

	@Override
	protected Void doInBackground(Void... params) {
		try {
			CharacterInfo charInfo = new CharacterInfo();
			charInfo.setAreaId(areaId);
			charInfo.setAreaName(areaName);
			charInfo.setRoleId(roleId);
			charInfo.setRoleName(roleName);
			GameConfigManager.getInstance().setCharacterInfo(charInfo);

			if (!TextUtils.isEmpty(areaId) && !TextUtils.isEmpty(roleId)) {
				RestfulApi api = RestfulApi.getInstance();
				Call<ResponseBody> call = api.saveCharacter(roleId, areaId, roleName, areaName);
				call.execute();
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}
}