package com.kajime.libtsy.api;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.kajime.libtsy.LibrarySDK;
import com.kajime.libtsy.model.EncodedResponse;
import com.kajime.libtsy.model.MItemPayment;
import com.kajime.libtsy.utils.EncryptionUtils;

import java.util.ArrayList;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Pc 02 on 12/26/2017.
 */

public class GetPayItemTask extends AsyncTask<Void, Void, Void> {
    private Listener callback;
    private Activity mActivity;
    private String state;

    public GetPayItemTask(Activity activity, String state, Listener callback) {
        this.callback = callback;
        this.mActivity = activity;
        this.state = state;
    }

    @Override
    protected Void doInBackground(Void... params) {
        try {
            RestfulApi api = RestfulApi.getInstance();
            Call<EncodedResponse> call = api.getPayItem(state);
            call.enqueue(new Callback<EncodedResponse>() {
                @Override
                public void onResponse(Call<EncodedResponse> call, Response<EncodedResponse> response) {
                    try {
                        Log.d("TAG", "response :" + response.body());
                        if (response.isSuccessful()) {
                            String responseBody = response.body().getDecodedData();
//                            Log.e("TAG", "response :" +responseBody);
                            ArrayList<MItemPayment> listItemPay = new ArrayList<MItemPayment>();
                            listItemPay = MItemPayment.parse(responseBody);
                            if (listItemPay != null)
                                for (int i = 0; i < listItemPay.size(); i++) {
                                    Glide.with(mActivity).asBitmap().load(listItemPay.get(i).getUrlPng())
                                            .apply(new RequestOptions()
                                                    .centerCrop()
                                                    .diskCacheStrategy(DiskCacheStrategy.ALL))
                                            .into(100, 100);
                                }
                            if (callback != null) {
                                callback.onSuccess(listItemPay);
                            }
                        } else {
                            if (callback != null) {
                                callback.onFailure(new Exception());
                            }
                        }
                    } catch (Exception e) {
                        if (callback != null) {
                            callback.onFailure(e);
                        }
                    }
                }

                @Override
                public void onFailure(Call<EncodedResponse> call, Throwable t) {
                    if (callback != null) {
                        callback.onFailure(t);
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public interface Listener {
        public void onSuccess(ArrayList<MItemPayment> listItem);

        public void onFailure(Throwable t);
    }

}
