package com.kajime.libtsy;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.app.Application.ActivityLifecycleCallbacks;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.provider.Settings;
import android.support.annotation.RequiresApi;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.webkit.CookieSyncManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.appsflyer.AFInAppEventParameterName;
import com.appsflyer.AFInAppEventType;
import com.appsflyer.AppsFlyerLib;
import com.google.firebase.iid.FirebaseInstanceId;
import com.kajim.adssdk.AdListener;
import com.kajim.adssdk.PopupAd;
import com.kajime.libtsy.component.EventClientManager;
import com.kajime.libtsy.component.FacebookManager;
import com.kajime.libtsy.component.GameConfigManager;
import com.kajime.libtsy.component.GoogleAuthManager;
import com.kajime.libtsy.gui.LibrarySDKTimerTask;
import com.kajime.libtsy.gui.LibraryUpgradeDialog;
import com.kajime.libtsy.model.Game;
import com.kajime.libtsy.model.IngameNoti;
import com.kajime.libtsy.model.MUrl;
import com.kajime.libtsy.model.UserInfo;
import com.kajime.libtsy.model.giftimage.GifData;
import com.kajime.libtsy.notification.LibraryFirebaseInstanceIDService;
import com.kajime.libtsy.utils.Constants;
import com.kajime.libtsy.utils.GifHelper;
import com.kajime.libtsy.utils.LibAppsflyerUtils;
import com.kajime.libtsy.utils.Preference;
import com.kajime.libtsy.utils.Res;
import com.kajime.libtsy.api.GetInfoAfterAuthenTask;
import com.kajime.libtsy.api.GetInfoBeforeAuthenTask;
import com.kajime.libtsy.api.GetIngameNotificationTask;
import com.kajime.libtsy.api.LogoutTask;
import com.kajime.libtsy.api.SaveCharacterTask;
import com.kajime.libtsy.gui.DialogInGameFragment;
import com.kajime.libtsy.gui.DialogRequestIpFragment;
import com.kajime.libtsy.gui.DialogSocialFragment;
import com.kajime.libtsy.gui.LibraryActivity;
import com.kajime.libtsy.gui.LibraryHaveBackButtonFragment;
import com.kajime.libtsy.gui.LibraryNotiOverlayView;
import com.kajime.libtsy.gui.LibraryPayDialogFragment;
import com.kajime.libtsy.js.CmdDashboard;
import com.kajime.libtsy.js.CmdPayment;
import com.kajime.libtsy.utils.Utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONTokener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.concurrent.ExecutionException;

@SuppressWarnings("deprecation")
public class LibrarySDK {

    private static final String TAG = LibrarySDK.class.getSimpleName();
    private static final long DEFAULT_SPEED = 6;
    private static final long PERIOD_TO_SEND_REQUEST_GET_NOTI = 600000; //10 minitues 600000 milisec
    private static final long PERIOD_BETWEEN_TWO_NOTIFICATION = 5000;
    private static LibrarySDK INSTANCE;

    public static Activity activity;
    public static Activity currentActivity;
    public static Context applicationContext;
    private static LibraryNotiOverlayView notiFloatButton;


    private LibListener mListener;

    private static boolean shouldShowPopup;
    private static boolean isFirstTimeRequestIp = true;

    private ArrayList<String> queuePopups = new ArrayList<String>();


    private String deeplinkData = "";
    private boolean justResumeFromMobActivity = false;
    private StatusAd adStatus = StatusAd.AD_INIT;
    private boolean isShowAds = true;
    private PopupAd popupAd;
    private static final String POPUP_ADS = "popup_ads";
    private boolean loginProcessDone = false;

    // Scroll Text
    @SuppressLint("StaticFieldLeak")
    private static View viewNotice;
    private int scrollRepeatCount = 0;
    private ArrayList<TextView> scrollTextViews;
    private int scrollTextViewIndex = 0;

    private ObjectAnimator scrollTextAnimation;
    private boolean isTextScrolling = false;
    private FrameLayout scrollTextLayout;
    private LibrarySDKTimerTask scrollTextTimerTask;
    private Timer scrollTextTimer;
    private long startPointOfOneScrollingTextNow = 0;
    private long durationOfOneScrollingTextNow = 0;

    // IP Check
    private OnFirstCheck onFirstCheck;
    private boolean isLogout = false;

    // Tham dinh
    private String validationImageUrl = "";
    private String validationText = "";

    private LibrarySDK() {
    }

    public static LibrarySDK getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LibrarySDK();
        }
        return INSTANCE;
    }

    private AdListener adListener = new AdListener() {
        @Override
        public void onAdOpened() {
            Log.d(TAG, "onAdOpened ");
            adStatus = StatusAd.AD_OPENED;
        }

        @Override
        public void onAdLoadedError(int arg0, String errorMessage) {
            Log.d(TAG, "Load ad error: " + errorMessage);
            adStatus = StatusAd.AD_ERROR;
        }

        @Override
        public void onAdLoaded() {
            Log.d(TAG, "Ads loaded!");
            adStatus = StatusAd.AD_LOADED;
            queuePopups.add(POPUP_ADS);
            if(popupAd!=null){
                popupAd.show();
                adStatus = StatusAd.AD_SHOWING;
            }
        }

        @Override
        public void onAdClosed() {
            Log.d(TAG, "onAdClosed");
            adStatus = StatusAd.AD_CLOSED;
        }
    };

    public void checkBeforeInit(Activity activity, String appkey) {
        try {
            Log.i(TAG, "LibrarySDK");
            LibrarySDK.activity = activity;
            Preference.save(activity, Constants.SHARED_PREF_MAIN_ACTIVITY,
                    activity.getClass().getName());
            GameConfigManager.getInstance().setAppKey(activity, appkey);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                canDraw = Settings.canDrawOverlays(activity);
            }
            new Thread(new Runnable() {
                @Override
                public void run() {
                    EventClientManager.getInstance(activity).setChiafkhoas(appkey);
                    firstCheckRequestIp(appkey);
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(Activity activity, String appkey) {
        applicationContext = activity.getApplicationContext();
        Intent intent = activity.getIntent();
        if (intent != null) {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                String link = intent.getExtras().getString("link");
                String url = intent.getExtras().getString("url");
                if (link != null) {
                    if (link.contains("http")) {
                        deeplinkData = "[{'action':'" + link + "'}]";
                    } else {
                        deeplinkData = "[{'action':'" + "http://" + Constants.DOMAIN_NAME + link + "'}]";
                    }
                    Preference.remove(activity, Constants.DEEPLINK);
                } else if (url != null) {
                    if (url.contains("http")) {
                        deeplinkData = "[{'action':'" + url + "'}]";
                    } else {
                        deeplinkData = "[{'action':'" + "http://" + Constants.DOMAIN_NAME + url + "'}]";
                    }
                    Preference.remove(activity, Constants.DEEPLINK);
                }
            }
        }
        if (mListener == null) {
            setLibListener(new LibListener() {

                @Override
                public void onPaySuccessful(String userId, String orderId,
                                            String orderProduct, String orderInfo,
                                            String orderTime, String platformPrice,
                                            String gamePrice, String state, String game_role_id,
                                            String game_area_id, String is_sandbox) {
                }

                @Override
                public void onLoginSuccessful(String accountID,
                                              String accessToken) {
                    try {
                        AppsFlyerLib.getInstance().setCustomerUserId(GameConfigManager.getInstance().getUserInfo().getUser().getUserId());
                        Log.d(TAG, "onLoginSuccessful: appsflyer UID: " + AppsFlyerLib.getInstance().getAppsFlyerUID(getApplicationContext()));
                        startTimerCheckNotificationInGame();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onError(int errorCode, String message) {
                }
            });
        }
        try {
            GameConfigManager.getInstance().setAppKey(activity, appkey);
            EventClientManager.getInstance(activity).setChiafkhoas(appkey);

            activity.getApplication().unregisterActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
            activity.getApplication().registerActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
            activity.getApplication().unregisterComponentCallbacks(mComponentCallbacks);
            activity.getApplication().registerComponentCallbacks(mComponentCallbacks);

            // activity.onCreate()
            LocalBroadcastManager.getInstance(activity.getApplicationContext())
                    .registerReceiver(mGlobalMessageReceiver, new IntentFilter(Constants.INTENT_FILTER));

            CookieSyncManager.createInstance(activity.getApplicationContext());
        } catch (Exception e) {
            e.printStackTrace();
        }
        popupAd = new PopupAd(activity);

        if(adStatus != StatusAd.AD_LOADING || adStatus != StatusAd.AD_OPENED){
            popupAd.setAdListener(adListener);
        }


    }


    public static Context getApplicationContext() {
        if (activity == null && applicationContext != null) {
            return applicationContext;
        }
        if (activity == null && currentActivity != null) {
            return currentActivity.getApplicationContext();
        }
        return activity.getApplicationContext();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.i(TAG, "onActivityResult:requestCode=" + requestCode
                + ";resultCode=" + resultCode);
        try {
            switch (requestCode) {
                case Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES:
                    GoogleAuthManager.getInstance().onActivityResult(requestCode, resultCode, data);
                    break;
                case Constants.REQUEST_CODE_FACEBOOK_LOGIN:
                case Constants.REQUEST_CODE_FACEBOOK_SHARE:
                case Constants.REQUEST_CODE_FACEBOOK_INVITE:
                    FacebookManager.getInstance().onActivityResult(requestCode,
                            resultCode, data);
                    break;
                case Constants.REQUEST_CODE_FACEBOOK_INVITE_GAME:
                    FacebookManager.getInstance().onActivityResult(requestCode,
                            resultCode, data);
                    break;
                case Constants.REQUEST_CODE_GOOGLE_IN_APP_BILLING:
                    CmdPayment.getInstance().handleResult(activity, requestCode,
                            resultCode, data);
                    break;
                case Constants.REQUEST_OVERLAY_PERMISSION:
                    requestOverlayPermission(activity);
                    break;
                case Constants.REQUEST_CODE_PICKER:
                    CmdDashboard.getInstance().handleResult(activity, requestCode,
                            resultCode, data);
                default:
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isDialogRequestShowing = false;
    private void requestOverlayPermission(Activity activity) {
        try {
            if (activity != null) {
                if (!isGrantedPermission(activity)) {
                    if (!isDialogRequestShowing)
                        showDialogRequestOverlayPermission();
                }
                else {
                    showNotiFloatButton();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showNotiFloatButton() {
        if (isShowingNotiFloatButton())
            return;
        if (notiFloatButton==null)
            notiFloatButton = new LibraryNotiOverlayView(activity, validationImageUrl, validationText);
        notiFloatButton.show();
    }

    private void hideNotiFloatButton() {
        if (notiFloatButton != null && activity!=null && notiFloatButton.isShowing()) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (notiFloatButton != null) {
                        notiFloatButton.hide();
                    }
                }
            });
        }
    }

    private boolean isShowingNotiFloatButton() {
        return notiFloatButton != null && notiFloatButton.isShowing();
    }

    private void showDialogRequestOverlayPermission() {
        try {
            AlertDialog.Builder builder;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                builder = new AlertDialog.Builder(activity, android.R.style.Theme_Material_Light_Dialog_Alert);
            } else {
                builder = new AlertDialog.Builder(activity);
            }

            builder.setTitle(activity.getString(R.string.attention))
                    .setMessage(activity.getString(R.string.overlay_messeage))
                    .setPositiveButton(android.R.string.yes, new DialogInterface.OnClickListener() {
                        @RequiresApi(api = Build.VERSION_CODES.M)
                        public void onClick(DialogInterface dialog, int which) {
                            Intent intent = null;
                            canDraw = Settings.canDrawOverlays(activity);
                            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                                AppOpsManager opsManager = (AppOpsManager) activity.getSystemService(Context.APP_OPS_SERVICE);
                                onOpChangedListener = new AppOpsManager.OnOpChangedListener() {

                                    @Override
                                    public void onOpChanged(String op, String packageName) {
                                        PackageManager packageManager = activity.getPackageManager();
                                        String myPackageName = activity.getPackageName();
                                        if (myPackageName.equals(packageName) &&
                                                AppOpsManager.OPSTR_SYSTEM_ALERT_WINDOW.equals(op)) {
                                            canDraw = !canDraw;
                                        }
                                    }
                                };
                                assert opsManager != null;
                                opsManager.startWatchingMode(AppOpsManager.OPSTR_SYSTEM_ALERT_WINDOW,
                                        null, onOpChangedListener);
                            }
                            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M ) {
                                intent = new Intent(Settings.ACTION_MANAGE_OVERLAY_PERMISSION,
                                        Uri.parse("package:" + activity.getPackageName()));
                            }
                            dialog.dismiss();
                            isDialogRequestShowing = false;
                            (activity).startActivityForResult(intent, Constants.REQUEST_OVERLAY_PERMISSION);
                        }
                    })
                    .setCancelable(false)
                    .setIcon(activity.getApplicationInfo().icon)
                    .show();
            isDialogRequestShowing = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private boolean canDraw;
    private AppOpsManager.OnOpChangedListener onOpChangedListener = null;

    private boolean isGrantedPermission(Activity activity) {
        boolean isGrandted = false;
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            isGrandted = true;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            isGrandted =  canDraw;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            isGrandted =  Settings.canDrawOverlays(activity);
        }
        return isGrandted;
    }

    @TargetApi(19)
    public void onWindowFocusChanged(boolean hasFocus) {
        try {
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
                if (hasFocus) {
                    activity.getWindow()
                            .getDecorView()
                            .setSystemUiVisibility(
                                    View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                                            | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                                            | View.SYSTEM_UI_FLAG_FULLSCREEN
                                            | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void login() {
        try {
            Log.i(TAG, "login");
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (isLoggedIn()) {
                return;
            }
            loginProcessDone = false;
            if (!isLoggedIn() && activity != null) {
                Intent intent = new Intent(activity, LibraryActivity.class);
                intent.putExtra(LibraryActivity.KEY_DATA, "[{'action':'" + Constants.URL_USER + "'}]");
                intent.putExtra(LibraryActivity.KEY_ENABLE_AUTOHIDE_HEADER_BAR, false);
                intent.putExtra(LibraryActivity.KEY_ENABLE_SIDE_MENU, false);
                intent.putExtra(LibraryActivity.KEY_IS_DASHBOARD_FORM, true);
                activity.startActivity(intent);
                try {
                    LibAppsflyerUtils.getInstance().trackOpenFormLogin(activity);
                    long timeOpenFormLogin = System.currentTimeMillis();
                    long startTime = Preference.getLong(activity ,Constants.START_SESSION , 0);
                    long deltaTime = timeOpenFormLogin - startTime;
                    if(!isLogout) LibAppsflyerUtils.getInstance().trackLoadTime(activity , deltaTime);
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            EventClientManager.getInstance(activity.getApplicationContext()).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, LibAppsflyerUtils.TRACK_LOGIN_CLICKED, null);
                        }
                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                handleLogin();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logout(boolean forceLogout) {
        loginProcessDone = true;
        logout();
    }

    public void logout() {
        try {
            if (!loginProcessDone) {
                return;
            }
            Log.i(TAG, "logout");
            new LogoutTask().execute();
            queuePopups.clear();
            LibAppsflyerUtils.getInstance().trackingLogout(currentActivity);
            isLogout = true;
            new Thread(new Runnable() {
                @Override
                public void run() {
                    EventClientManager.getInstance(activity).saveEventClient(EventClientManager.SAVE_EVENT_END_SESSION, LibAppsflyerUtils.TRACK_EVENT_LOGOUT, null);
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isJsonArray(String strData) {
        Object json = null;
        boolean isJSONArray = false;
        try {
            json = new JSONTokener(strData).nextValue();
            isJSONArray = json instanceof JSONArray;
            Log.d(TAG, "isJSONArray: " + isJSONArray);
        } catch (JSONException e) {
            Log.d(TAG, "isJSONArray: catch exception");
            e.printStackTrace();
        }
        return isJSONArray;
    }

    public void payment() {
        payment("");
    }

    public void payment(String state) {
        try {
            Log.i(TAG, "payment:" + state);
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (!isLoggedIn()) {
                Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
            } else {
                FragmentManager fm = activity.getFragmentManager();
                LibraryPayDialogFragment dialogFragment = new LibraryPayDialogFragment(state);
                dialogFragment.show(fm, "dialog_payment");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public String[] funShow() {
        String[] funShow = new String[2];
        try {
            UserInfo.User users = GameConfigManager.getInstance().getUserInfo().getUser();
            if (users.getVip() != null) {
                funShow[0] = users.getVip();
            }
            if (users.getVipImage() != null) {
                funShow[1] = users.getVipImage();
            } else {
                funShow[0] = "";
                funShow[1] = "";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return funShow;
    }

    public void topRankUrl(String url) {
        try {
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (!isLoggedIn()) {
                Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
            } else {
                showFragmentHaveBackButton(url, false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void customUrl(String url) {
        try {
            Log.e("Url", url);
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (!isLoggedIn()) {
                Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
            } else {
                showFragment(url, false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showNewsAndEvent() {
        try {
//            String url = GameConfigManager.getInstance().getNewsEventUrl();
            String url = Constants.URL_DASHBOARD;
            Log.d(TAG, "newsEvent: " +url);
            if (!url.isEmpty()) {
                Intent intent = new Intent(activity, LibraryActivity.class);
                intent.putExtra(LibraryActivity.KEY_DATA, "[{'action':'" + url + "'}]");
                intent.putExtra(LibraryActivity.KEY_ENABLE_AUTOHIDE_HEADER_BAR, false);
                intent.putExtra(LibraryActivity.KEY_ENABLE_SIDE_MENU, false);
                intent.putExtra(LibraryActivity.KEY_IS_LOGIN_FORM, true);
                activity.startActivity(intent);
            } else {
                Log.e(TAG, "newsEvent: dont have url");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isShowSocialDialog = false;

    private void showFragment(String url, boolean isEncrypted) {
        try {
            if (url != null && !url.equals("")) {
                FragmentManager fm = activity.getFragmentManager();
                DialogSocialFragment fr = (DialogSocialFragment) fm
                        .findFragmentByTag(Constants.TAG_FRAGMENT);
                isShowSocialDialog = true;
                if (fr == null) {
                    fr = new DialogSocialFragment(new MUrl(url, isEncrypted));
                    fr.setOnDismissListener(new DialogInterface.OnDismissListener() {

                        @Override
                        public void onDismiss(DialogInterface dialog) {
                            isShowSocialDialog = false;
//                            if (currentTime > 0) startAnimation();
                        }
                    });
                    FragmentTransaction fragmentTransaction = fm.beginTransaction();
                    fragmentTransaction.add(fr, Constants.TAG_FRAGMENT);
                    // fragmentTransaction.commit();
                    fragmentTransaction.commitAllowingStateLoss();
                } else {
                    try {
                        fr.loadUrlWithMobHeaders(new MUrl(url, isEncrypted));
                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Log.d(TAG, "url null");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showFragmentHaveBackButton(String url, boolean isEncrypted) {
        try {
            if (url != null && !url.equals("")) {
                FragmentManager fm = activity.getFragmentManager();
                LibraryHaveBackButtonFragment fr = (LibraryHaveBackButtonFragment) fm
                        .findFragmentByTag(Constants.TAG_FRAGMENT2);
                isShowSocialDialog = true;
                if (fr == null) {
                    fr = new LibraryHaveBackButtonFragment(new MUrl(url, isEncrypted));
                    fr.setOnDismissListener(new DialogInterface.OnDismissListener() {

                        @Override
                        public void onDismiss(DialogInterface dialog) {
                            isShowSocialDialog = false;
                        }
                    });
                    FragmentTransaction fragmentTransaction = fm.beginTransaction();
                    fragmentTransaction.add(fr, Constants.TAG_FRAGMENT);
                    // fragmentTransaction.commit();
                    fragmentTransaction.commitAllowingStateLoss();
                } else {
                    try {
                        fr.loadUrlWithMobHeaders(new MUrl(url, isEncrypted));
                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Log.d(TAG, "url null");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        close(true);
    }

    private void close(boolean check) {
        try {
            Intent i = new Intent(Constants.INTENT_FILTER);
            i.putExtra("category", "dashboard_close");
            LocalBroadcastManager.getInstance(activity).sendBroadcast(i);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showPopup() {
        loginProcessDone = true;
        try {
            if(GameConfigManager.getInstance().getShowPopup()){
                Log.i(TAG, "showPopup: url popup = " + Constants.URL_POPUP);
                //test
                //customUrl("http://esa.casematie.com/plf//Humans/webibc");
                customUrlWithBackButton(Constants.URL_POPUP);
            }else if(GameConfigManager.getInstance().getShowAd()){
                //TODO show ads
                Log.d(TAG, "showPopup: false => show ads");
                if(popupAd == null){
                    popupAd = new PopupAd(activity);
                    if(adStatus != StatusAd.AD_LOADING || adStatus != StatusAd.AD_OPENED){
                        popupAd.setAdListener(adListener);
                        popupAd.loadAd();
                    }
                }

                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if(isLoggedIn()){
                            if(adStatus == StatusAd.AD_LOADED){
                                adStatus = StatusAd.AD_SHOWING;
                                popupAd.show();
                            }else{
                                popupAd.loadAd();
                            }
                        }
                    }
                }, 1000);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void customUrlWithBackButton(String url) {
        try {
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (!isLoggedIn()) {
                Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
            } else {
                showFragmentHaveBackButton(url, false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUserConfig(String mAreaId, String mAreaName, String mRoleId, String mRoleName) {
        try {
            Log.i(TAG, "setUserConfig: area_id=" + mAreaId + ";role_id=" + mRoleId
                    + ";area_name=" + mAreaName + ";role_name=" + mRoleName);
            (new SaveCharacterTask(mAreaId, mAreaName, mRoleId, mRoleName))
                    .execute();
            EventClientManager.getInstance(activity).setNhanvat_max(mRoleId);
            EventClientManager.getInstance(activity).setNhanvat_teen(mRoleName);
            EventClientManager.getInstance(activity).setMaychu_max(mAreaId);
            EventClientManager.getInstance(activity).setMaychu_teen(mAreaName);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isLoggedIn() {
        return !TextUtils.isEmpty(GameConfigManager.getInstance()
                .getAccessToken());
    }

    private void handleLogin() {
        try {
            (new GetInfoAfterAuthenTask(new GetInfoAfterAuthenTask.Listener() {

                @Override
                public void onSuccess(UserInfo userInfo) {
                    try {
                        GameConfigManager.getInstance().setUserInfo(userInfo);

                        if (userInfo != null) {

                            String accountId = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
                            String accessToken = GameConfigManager.getInstance().getAccessToken();
                            mListener.onLoginSuccessful(
                                    accountId,
                                    accessToken);
                            showPopup();
                            String firebaseToken = FirebaseInstanceId.getInstance().getToken();
                            Log.i(TAG, "Firebase Token/regId: " + firebaseToken);
                            LibraryFirebaseInstanceIDService.getInstance().sendRegistrationToServer(activity,firebaseToken);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    logout(true);
                    mListener.onError(LibListener.ERROR_LOGIN,
                            "Unable to login toserver");
                }
            })).execute();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isUpgradeDialog = false;

    public void callShowPopup() {
        showPopup();
    }


    private LibraryUpgradeDialog dialog;
    LibListener mDefaultListener = new LibListener() {

        @Override
        public void onLoginSuccessful(String accID, String token) {
            try {
                AppsFlyerLib.getInstance().setCustomerUserId(GameConfigManager.getInstance().getUserInfo().getUser().getUserId());
//                Log.d(TAG, "onLoginSuccessful: appsflyer userid: "+AppsFlyerLib.getInstance().getAppUserId());
                Log.d(TAG, "onLoginSuccessful: appsflyer UID: " + AppsFlyerLib.getInstance().getAppsFlyerUID(getApplicationContext()));
            } catch (Exception e) {
                e.printStackTrace();
            }
            LibAppsflyerUtils.getInstance().trackLoginSuccess(currentActivity);
            new Thread(new Runnable() {
                @Override
                public void run() {
                    EventClientManager.getInstance(activity).saveEventClient(EventClientManager.SAVE_EVENT_START_SESSION,  LibAppsflyerUtils.TRACK_LOGIN_SUCCESS_AFTER_AUTH, null);
                }
            }).start();
        }

        @Override
        public void onPaySuccessful(String userId, String orderId,
                                    String orderProduct, String orderInfo, String orderTime,
                                    String platformPrice, String gamePrice, String state,
                                    String game_role_id, String game_area_id, String is_sandbox) {

            try {
                double price = 0.01 * Double.parseDouble(platformPrice);
                final HashMap<String, Object> eventValue = new HashMap<String, Object>();
                eventValue.put(AFInAppEventParameterName.REVENUE, price);
                eventValue.put(AFInAppEventParameterName.CONTENT_TYPE,
                        "category_rev");
                eventValue.put(AFInAppEventParameterName.CONTENT_ID, "123456");
                eventValue.put(AFInAppEventParameterName.CURRENCY, "USD");
                eventValue.put(Constants.AF_ORDER_ID, orderId);
                LibAppsflyerUtils.getInstance().trackPaymentSuccess(currentActivity , eventValue);

                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        EventClientManager.getInstance(activity).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, AFInAppEventType.PURCHASE, eventValue);
                    }
                }).start();
            } catch (Exception e) {
                e.printStackTrace();
            }
            // close();
        }

        @Override
        public void onError(int errorCode, String message) {
            try {
                Log.d(TAG, "onError LibListener: " + message);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private int countShowHello = 0;

    public void setLibListener(LibListener listener) {
        final LibListener fl = listener;
        LibListener onLoginListener = new LibListener() {

            @Override
            public void onLoginSuccessful(String accID, String token) {
                try {
                    try {
                        AppsFlyerLib.getInstance().setCustomerUserId(GameConfigManager.getInstance().getUserInfo().getUser().getUserId());
//                        Log.d(TAG, "onLoginSuccessful: appsflyer userid: "+AppsFlyerLib.getInstance().getAppUserId());
                        Log.d(TAG, "onLoginSuccessful: appsflyer UID: " + AppsFlyerLib.getInstance().getAppsFlyerUID(getApplicationContext()));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    countShowHello = 1;
                    Log.i(TAG, "OnLoginListener::onLoginSuccessful");
                    Log.i(TAG, "accountID = " + accID + "; accessToken = " + token);
                    startTimerCheckNotificationInGame();

                    close(false);
                    doLoadPopupAds();

                    try {
                        LibAppsflyerUtils.getInstance().trackLoginSuccess(activity);
                        new Thread(new Runnable() {
                            @Override
                            public void run() {
                                EventClientManager.getInstance(getApplicationContext()).saveEventClient(EventClientManager.SAVE_EVENT_START_SESSION, LibAppsflyerUtils.TRACK_LOGIN_SUCCESS_AFTER_AUTH, null);
                            }
                        }).start();
                    } catch (Exception e) {
                        // TODO: handle exception
                    }
                    fl.onLoginSuccessful(accID, token);
                } catch (Exception e) {
                    e.printStackTrace();
                    fl.onError(-1, e.getMessage());
                }

            }

            @Override
            public void onPaySuccessful(String userId, String orderId,
                                        String orderProduct, String orderInfo, String orderTime,
                                        String platformPrice, String gamePrice, String state,
                                        String game_role_id, String game_area_id, String is_sandbox) {

                try {
                    double price = 0.01 * Double.parseDouble(platformPrice);
                    final HashMap<String, Object> eventValue = new HashMap<String, Object>();
                    eventValue.put(AFInAppEventParameterName.REVENUE, price);
                    eventValue.put(AFInAppEventParameterName.CONTENT_TYPE,
                            "category_rev");
                    eventValue.put(AFInAppEventParameterName.CONTENT_ID,
                            "123456");
                    eventValue.put(AFInAppEventParameterName.CURRENCY, "USD");
                    eventValue.put(Constants.AF_ORDER_ID, orderId);
                    LibAppsflyerUtils.getInstance().trackPaymentSuccess(activity , eventValue);
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            EventClientManager.getInstance(activity).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, AFInAppEventType.PURCHASE, eventValue);
                        }
                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                    // in case platformPrice cannot be parsed
                }
                // close();

                fl.onPaySuccessful(userId, orderId, orderProduct, orderInfo,
                        orderTime, platformPrice, gamePrice, state,
                        game_role_id, game_area_id, is_sandbox);
            }

            @Override
            public void onError(int errorCode, String message) {
                try {
                    Log.d(TAG, "onError LibListener: " + message);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        mListener = onLoginListener;
    }

    private boolean isShowPopupUpgrade() {
        if (dialog != null) {
            try {
                if (dialog.isShowing())
                    return false;
                else
                    return true;
            } catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        } else {
            return true;
        }
    }

    private void doLoadPopupAds() {
        try {
            boolean showAds = Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_ADS, false);
            if(!showAds){
                return;
            }
            if(popupAd == null){
                return;
            }
            if(adStatus != StatusAd.AD_LOADING && adStatus != StatusAd.AD_OPENED
                    && adStatus != StatusAd.AD_SHOWING && adStatus != StatusAd.AD_LOADED){
                popupAd.loadAd();
                adStatus = StatusAd.AD_LOADING;
                Log.d(TAG, "Ads loading....");
                popupAd.setAdListener(adListener);
            }else{
                showPopup();
            }

        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private ActivityLifecycleCallbacks mActivityLifecycleCallbacks = new ActivityLifecycleCallbacks() {

        private final String TAG = ActivityLifecycleCallbacks.class
                .getSimpleName();

        @Override
        public void onActivityCreated(Activity a, Bundle b) {
            try {
                Log.i(TAG, "onActivityCreated:" + a.getClass().getSimpleName());
                currentActivity = a;
                if (a.equals(activity)) {
                    // Xu li deeplink o day!!!
                    Intent intent = activity.getIntent();
                    if (intent != null) {
                        Bundle bundle = intent.getExtras();
                        if (bundle != null) {
                            String link = intent.getExtras().getString("link");
                            String url = intent.getExtras().getString("url");
                            if (link != null) {
                                Intent intentMobileActivity = new Intent(activity, LibraryActivity.class);
                                intentMobileActivity.putExtra(LibraryActivity.KEY_DATA, "[{\"action\":\"" + link + "\"}]");
                                activity.startActivity(intentMobileActivity);
                            }
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityStarted(Activity a) {
            try {
                Log.i(TAG, "onActivityStarted:" + a.getClass().getSimpleName());
                currentActivity = a;
                if (a.equals(activity)) {

                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityResumed(Activity a) {
            try {
                Log.i(TAG, "onActivityResumed:" + a.getClass().getSimpleName() + " -- " + (scrollTextAnimation == null) + "|" + isTextScrolling);
                currentActivity = a;
                if (isTextScrolling && scrollTextAnimation != null) {
                    long resumedPoint = System.currentTimeMillis() - startPointOfOneScrollingTextNow;
                    scrollTextAnimation.start();
                    if (resumedPoint < durationOfOneScrollingTextNow) {
                        scrollTextAnimation.setCurrentPlayTime(resumedPoint);
                    }
                }
                if (a.equals(activity)) {
                    Log.d(TAG, "menu-id onActivityResumed:");

                    if (notiFloatButton != null)
                        notiFloatButton.show();

                    if (!isFirstTimeRequestIp) {
                        Game gameConfig = GameConfigManager.getInstance().getGameConfig();
                        if (gameConfig == null) {
                            getGameInfoRemote();
                        }
                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && mGetInfoBeforeAuthenTask != null) {
                            checkValidationMode();
                        }
                        LocalBroadcastManager.getInstance(getApplicationContext())
                                .registerReceiver(mMessageReceiver, new IntentFilter(Constants.INTENT_FILTER));

                        if(isLoggedIn() && isShowAds){
                            doLoadPopupAds();
                        }

                        CookieSyncManager.getInstance().startSync();
                    }
                    Log.d(TAG, "isLoggedIn:" + isLoggedIn());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

        @Override
        public void onActivityPaused(Activity a) {
            try {

                Log.i(TAG, "onActivityPaused:" + a.getClass().getSimpleName());
                currentActivity = a;
                if (isShowingNotiFloatButton()) hideNotiFloatButton();
                if (scrollTextTimer != null) scrollTextTimer.cancel();
                scrollTextTimer = null;
                if (scrollTextTimerTask !=null) scrollTextTimerTask.cancel();
                if (a.getClass().getSimpleName().equalsIgnoreCase("LibraryActivity")) {
                    justResumeFromMobActivity = true;
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                justResumeFromMobActivity = false;
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }, 500);
                }
                if (a.equals(activity)) {

                    CookieSyncManager.getInstance().stopSync();

                    LocalBroadcastManager.getInstance(getApplicationContext())
                            .unregisterReceiver(mMessageReceiver);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityStopped(Activity a) {
            try {
                Log.i(TAG, "onActivityStopped:" + a.getClass().getSimpleName());
                if(!a.isFinishing()){
                    Log.d(TAG , "onActivity Go here");
                    long timeFromBefore = getTimeLiveSession();

                    new CountDownTimer(timeFromBefore , timeFromBefore){

                        @Override
                        public void onTick(long millisUntilFinished) {

                        }

                        @Override
                        public void onFinish() {
                            long endSession = System.currentTimeMillis();
                            long startSession = Preference.getLong(a, Constants.START_SESSION , 0);
                            endSession(endSession - startSession);
                        }
                    }.start();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityDestroyed(Activity a) {
            try {
                Log.i(TAG, "onActivityDestroyed:" + a.getClass().getSimpleName());
                if (a.equals(activity)) {
                    if (isLoggedIn()) {
                        EventClientManager.getInstance(a).saveEventClient(EventClientManager.SAVE_EVENT_END_SESSION, null, null);
                    }
//                    if (!a.getClass().getSimpleName().equals("LibraryActivity")
//                            && !a.getClass().getSimpleName()
//                            .equals("FacebookActivity")) {
//                    }
                    Log.i(TAG, "removeAllCookie");

//                    LibraryGCMIntent??Service.destroy(activity);

                    LocalBroadcastManager.getInstance(
                            getApplicationContext()).unregisterReceiver(
                            mGlobalMessageReceiver);

                    Preference.remove(a, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivitySaveInstanceState(Activity a, Bundle b) {
            try {
                if (a.equals(activity)) {

                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    };


    private ComponentCallbacks mComponentCallbacks = new ComponentCallbacks() {

        @Override
        public void onConfigurationChanged(Configuration newConfig) {
            // Checks the orientation of the screen
            try {
                Log.d(TAG, "onConfigurationChanged");
                if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE
                        || newConfig.orientation == Configuration.ORIENTATION_PORTRAIT) {
                    Log.d(TAG, "onConfigurationChanged : " + newConfig.orientation);
                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "float_button");
                    LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

        @Override
        public void onLowMemory() {
        }

    };

    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            Log.d(TAG, "BroadcastReceiver::onReceive");
            try {
                String category = intent.getStringExtra("category");
                Log.e(TAG, "category:" + category);
                if (category != null) {
                    if ("gcm".equalsIgnoreCase(category)) {
                        try {

                            if (intent.getBooleanExtra("play_gif", false)) {
                                GifHelper.playGif(activity);
                            }

                            if (intent.hasExtra("gif_data")) {
                                String gifDataString = intent.getStringExtra("gif_data");
                                GifHelper.fetchFramesImage(activity, GifData.parse(gifDataString));

                                GifHelper.playGif(activity);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if ("moClbmatsach".equalsIgnoreCase(category)) {
                        try {
                            String params = intent.getStringExtra("data");
                            CmdDashboard.getInstance().moClbmatsach(activity, params);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if ("moNhommatsach".equalsIgnoreCase(category)) {
                        try {
                            String params = intent.getStringExtra("data");
                            CmdDashboard.getInstance().moNhommatsach(activity, params);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if ("motrduyen".equalsIgnoreCase(category)) {
                        try {
                            String params = intent.getStringExtra("data");
                            CmdDashboard.getInstance().motrduyen(activity, params);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if ("LibraryUpgradeDialog.btnUpgradeInfo".equalsIgnoreCase(category)) {
                        shouldShowPopup = true;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private BroadcastReceiver mGlobalMessageReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            Log.d(TAG, "GlobalMessageReceiver::onReceive");
            try {
                String category = intent.getStringExtra("category");
                Log.d(TAG, "GlobalMessageReceiver::onReceive " + category);
                if (category != null) {
                    if ("login".equalsIgnoreCase(category)) {
                        handleLogin();
                    } else if ("payment".equalsIgnoreCase(category)) {

                        boolean success = intent.getBooleanExtra("status", false);
                        if (success) {
                            String userId = intent.getStringExtra("user_id");
                            String orderId = intent.getStringExtra("order_id");
                            String orderProduct = intent.getStringExtra("order_product");
                            String orderInfo = intent.getStringExtra("order_info");
                            String orderTime = intent.getStringExtra("order_time");
                            String platformPrice = intent.getStringExtra("platform_price");
                            String gamePrice = intent.getStringExtra("game_price");
                            String state = intent.getStringExtra("state");
                            String game_role_id = intent.getStringExtra("game_role_id");
                            String game_area_id = intent.getStringExtra("game_area_id");
                            String is_sandbox = intent.getStringExtra("is_sandbox");

                            mListener.onPaySuccessful(userId, orderId,
                                    orderProduct, orderInfo, orderTime,
                                    platformPrice, gamePrice, state, game_role_id,
                                    game_area_id, is_sandbox);
                        } else {
                            String message = intent.getStringExtra("message");
                            mListener.onError(LibListener.ERROR_PAYMENT,
                                    message);
                        }
                    } else if ("reload".equalsIgnoreCase(category)) {
                        LibraryActivity.shouldReload = true;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private GetInfoBeforeAuthenTask mGetInfoBeforeAuthenTask;

    private void getGameInfoRemote() {
        try {
            if (mGetInfoBeforeAuthenTask != null
                    && !mGetInfoBeforeAuthenTask.isCancelled())
                mGetInfoBeforeAuthenTask.cancel(true);

            mGetInfoBeforeAuthenTask = new GetInfoBeforeAuthenTask(
                    new GetInfoBeforeAuthenTask.Listener() {

                        @Override
                        public void onSuccess(Game gameConfig) {
                            if (gameConfig == null) {
                                onGetGameInfoRemoteFailed();
                            } else {
                                Log.i(TAG, "Validation Mode: " + gameConfig.getValidationConfig().isShouldShowLogo());
                                GameConfigManager.getInstance().setGameConfig(
                                        gameConfig);
                                if (gameConfig.getValidationConfig().isShouldShowLogo()) {
                                    validationImageUrl = gameConfig.getValidationConfig().getLogoUrl();
                                    validationText = gameConfig.getValidationConfig().getText();
                                    requestOverlayPermission(activity);
                                }
//                                requestOverlayPermission(activity);
                                if (isLoggedIn()) {
                                    handleLogin();
                                }
                            }
                        }

                        @Override
                        public void onFailure(Throwable t) {
                            t.printStackTrace();
                            onGetGameInfoRemoteFailed();
                        }
                    });
            mGetInfoBeforeAuthenTask.execute();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onGetGameInfoRemoteFailed() {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(
                    Utils.getContextThemeWrapper(activity));
            builder.setCancelable(false);
            builder.setMessage(Res.string(activity, R.string.unable_to_connect));
            builder.setPositiveButton(Res.string(activity, R.string.retry),
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int which) {
                            getGameInfoRemote();
                        }
                    });
            builder.setNegativeButton(Res.string(activity, R.string.exit),
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int which) {
                            Intent intent = new Intent(Intent.ACTION_MAIN);
                            intent.addCategory(Intent.CATEGORY_HOME);
                            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                            activity.startActivity(intent);
                        }
                    });
            builder.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<IngameNoti> listNotification = new ArrayList<>();
    private void startTimerCheckNotificationInGame() {
        try {
            if(scrollTextTimer != null) {
                scrollTextTimer.cancel();
                scrollTextTimer = null;
            }
            scrollTextTimer = new Timer();
            if (scrollTextTimerTask == null) {
                scrollTextTimerTask = new LibrarySDKTimerTask(activity, new Runnable() {
                    @Override
                    public void run() {
                        if (isLoggedIn()) {
                            new GetIngameNotificationTask(activity, new GetIngameNotificationTask.Listener() {
                                @Override
                                public void onSuccess(ArrayList<IngameNoti> listItem) {
                                    if (listItem.size()==0) return;
                                    listNotification.addAll(listItem);
                                    showTextScroll(activity,1, null, listNotification.get(0));
                                    Log.e(TAG, "Text Scrolling");
                                }

                                @Override
                                public void onFailure(Throwable t) {
                                    t.printStackTrace();
                                }
                            }).execute();
                        }
                    }
                });
            }
            ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
            if (viewNotice !=null )
                rootView.removeView(viewNotice);
            Log.e(TAG, "Timer Running now");
            scrollTextTimer.schedule(scrollTextTimerTask, PERIOD_TO_SEND_REQUEST_GET_NOTI, PERIOD_TO_SEND_REQUEST_GET_NOTI);
        } catch (Exception e) {
            e.printStackTrace();
        }

        /*long lastCloseAppTime = Preference.getLong(activity,Constants.SHARED_PREF_OPEN_APP_TIME,0); //in milisecond
        if (lastCloseAppTime == 0)
            scrollTextTimer.schedule(scrollTextTimerTask, PERIOD_TO_SEND_REQUEST_GET_NOTI,PERIOD_TO_SEND_REQUEST_GET_NOTI);
        else if (System.currentTimeMillis() - lastCloseAppTime > PERIOD_TO_SEND_REQUEST_GET_NOTI){
            ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
            if (viewNotice !=null )
                rootView.removeView(viewNotice);
            scrollTextTimer.schedule(scrollTextTimerTask,0,PERIOD_TO_SEND_REQUEST_GET_NOTI);
        }
        else
            scrollTextTimer.schedule(scrollTextTimerTask,System.currentTimeMillis()-lastCloseAppTime,PERIOD_TO_SEND_REQUEST_GET_NOTI);*/
    }

    public void showTextScroll(Activity activity){
        try {
            new GetIngameNotificationTask(activity, new GetIngameNotificationTask.Listener() {
                @Override
                public void onSuccess(ArrayList<IngameNoti> notiList) {
                    if (notiList.size() > 0) {
                        showTextScroll(notiList);
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    Log.e("List", t.getMessage());
                }
            }).execute();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showTextScroll(ArrayList<IngameNoti> listNotification) {
        if (this.listNotification.size() == 0) this.listNotification = listNotification;
        else this.listNotification.addAll(listNotification);
        showTextScroll(activity, 1, null, listNotification.get(0));
    }

    private void showTextScroll(final Activity activity, int repeatCount,
                                final Runnable afterHideRunnable, IngameNoti message){
        try {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
//                    if (addToLibrabyList) listNoti.add(message);
                    ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
                    LayoutInflater inflater = LayoutInflater.from(activity);
                    if (viewNotice == null) viewNotice = inflater.inflate(R.layout.layout_notice, null);
                    if (scrollTextLayout == null) {
                        scrollTextLayout = (FrameLayout) viewNotice.findViewById(R.id.layoutNotiIngame);
                        LinearLayout.LayoutParams resizeParams = (LinearLayout.LayoutParams) scrollTextLayout.getLayoutParams();
                        resizeParams.width = rootView.getWidth()/5*4;
                        Log.i("Layout Width", resizeParams.width + " | ScreenWidth: " + rootView.getWidth());
                    }
                    TextView scrollTextView = (TextView) viewNotice.findViewById(R.id.txt_notice);
                    Rect bounds = new Rect();
                    Paint textPaint = scrollTextView.getPaint();
                    long layoutWidth = rootView.getWidth()/5*4;
                    if (isTextScrolling) {
                        initScrollView(message,textPaint,bounds,scrollTextLayout);
                    } else {
                        /* FIRST TIME SET UP ANIMATION */
                        scrollTextViews = new ArrayList<>();
                        scrollTextViewIndex =0; scrollRepeatCount = 0;
                        initScrollView(message,textPaint,bounds,scrollTextLayout);
                        rootView.addView(viewNotice);
                        int startPoint = (rootView.getWidth()/5*4) + rootView.getWidth()/10;
                        startScrollingText(scrollTextViews.get(scrollTextViewIndex),layoutWidth, startPoint, afterHideRunnable, repeatCount);
                    }
                }
            });
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void hideTextScroll(final Activity activity, boolean isAnimated) {
        try {
            Log.e("HERE","Hiding ");
            ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
            if (isTextScrolling) {
                if (isAnimated) {
                    activity.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            Animation animation = AnimationUtils.loadAnimation(
                                    activity, R.anim.top_out);
                            animation.setAnimationListener(new Animation.AnimationListener() {
                                @Override
                                public void onAnimationStart(Animation animation) {
                                }

                                @Override
                                public void onAnimationRepeat(Animation animation) {
                                }

                                @Override
                                public void onAnimationEnd(Animation animation) {

                                }
                            });
                            if (viewNotice !=null ) {
                                viewNotice.startAnimation(animation);
                                rootView.removeView(viewNotice);
                            }
                        }
                    });
                }else {
                    try {
                        if (viewNotice !=null )
                            rootView.removeView(viewNotice);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                isTextScrolling = false;
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void initScrollView(IngameNoti listNoti, Paint textPaint, Rect bounds, FrameLayout layout) {
        try {
            Spanned text = Html.fromHtml(listNoti.getText());
            TextView textView = new TextView(activity);
            textPaint.getTextBounds(String.valueOf(text), 0, text.length(), bounds);
            float textLength = bounds.width();
            textView.setSingleLine(true);
            textView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 16);
            textView.setTextColor(Color.WHITE);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int) textLength, ViewGroup.LayoutParams.WRAP_CONTENT);
            textView.setLayoutParams(lp);
            textView.setText(text);
            switch (listNoti.getType()) {
                case 1:
                    textView.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            try {
                                AlertDialog.Builder builder = new AlertDialog.Builder(
                                        Utils.getContextThemeWrapper(activity));
                                builder.setMessage(Res.string(activity, R.string.open_with_browser));

                                builder.setPositiveButton(Res.string(activity,R.string.yes),
                                        new DialogInterface.OnClickListener() {
                                            public void onClick(DialogInterface dialog, int which) {
                                                activity.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(listNoti.getLink())));
                                            }
                                        });
                                builder.setNegativeButton(Res.string(activity,R.string.no),
                                        new DialogInterface.OnClickListener() {
                                            public void onClick(DialogInterface dialog, int which) {
                                            }
                                        });
                                builder.show();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    break;
                case 2:
                    textView.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            FragmentManager fm = activity.getFragmentManager();
                            DialogInGameFragment dialogIngame = new DialogInGameFragment(listNoti.getLink());
                            dialogIngame.show(fm, "Show Dialog Ingame");
                        }
                    });
                    break;
            }
            scrollTextViews.add(textView);
            layout.addView(textView);
            textView.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startScrollingText(TextView textView, long layoutWidth, float startPoint, Runnable afterHideRunnable, int repeatCount) {
        try {
            scrollRepeatCount++;
            if (!isTextScrolling)
                isTextScrolling = true;
            textView.setVisibility(View.VISIBLE);
            textView.setX(startPoint);
            float scale;
            scale = 3 / (activity.getResources().getDisplayMetrics().density);
            long s = layoutWidth + textView.getLayoutParams().width;
            long textDuration = (long) (s* DEFAULT_SPEED * scale);
            durationOfOneScrollingTextNow = textDuration;
            Log.i(TAG, "Scroll Text Infor: " + textView.getText().toString());
            scrollTextAnimation = ObjectAnimator.ofFloat(textView,"x",-textView.getLayoutParams().width);
            scrollTextAnimation.setDuration(textDuration);
            scrollTextAnimation.setInterpolator(new LinearInterpolator());
            scrollTextAnimation.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    try {
                        textView.setVisibility(View.GONE);
                        if (scrollRepeatCount <= repeatCount) {
                            startScrollingText(scrollTextViews.get(scrollTextViewIndex),layoutWidth, startPoint, afterHideRunnable, repeatCount);
                        } else {
                            hideTextScroll(activity, true);
                            listNotification.remove(scrollTextViewIndex);
                            scrollTextViews.remove(scrollTextViewIndex);
                            scrollRepeatCount = 0;
                            if (listNotification.size()>0) {
                                new Handler().postDelayed(new Runnable() {
                                    @Override
                                    public void run() {
                                        showTextScroll(activity,1,null, listNotification.get(scrollTextViewIndex));
                                    }
                                },PERIOD_BETWEEN_TWO_NOTIFICATION);
                            } else {
                                hideTextScroll(activity, true);
                                if (afterHideRunnable != null) {
                                    afterHideRunnable.run();
                                }
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            startPointOfOneScrollingTextNow = System.currentTimeMillis();
            scrollTextAnimation.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void firstCheckRequestIp(String appkey) {
        try {
            FragmentManager fm = activity.getFragmentManager();
            DialogRequestIpFragment dialogCheckRequestIp = new DialogRequestIpFragment(Constants.URL_REQUESTIP);
            dialogCheckRequestIp.setOnRequestIp(new DialogRequestIpFragment.OnRequestIp() {
                @Override
                public void OnGetResquestIp(String result) {
                    Log.i(TAG, "js result: " +result + "");
                    try {
                        if (result != null) {
                            onFirstCheck.onGetFirstCheck(true);
                            dialogCheckRequestIp.dismiss();

                            if (isFirstTimeRequestIp) {
                                init(activity, appkey);
                                Game gameConfig = GameConfigManager.getInstance().getGameConfig();
                                if (gameConfig == null) {
                                    getGameInfoRemote();
                                }
                                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && mGetInfoBeforeAuthenTask != null) {
                                    checkValidationMode();
                                }
                                LocalBroadcastManager.getInstance(getApplicationContext())
                                        .registerReceiver(mMessageReceiver, new IntentFilter(Constants.INTENT_FILTER));

                                CookieSyncManager.getInstance().startSync();
                                isFirstTimeRequestIp = false;
                            }
                        } else onFirstCheck.onGetFirstCheck(false);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            dialogCheckRequestIp.show(fm, "Show Dialog Ingame");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnFirstCheck(OnFirstCheck onFirstCheck) {
        this.onFirstCheck = onFirstCheck;
    }

    public interface OnFirstCheck {
        void onGetFirstCheck(boolean shouldInit);
    }

    private enum StatusAd {
        AD_INIT, AD_LOADING, AD_OPENED, AD_LOADED, AD_CLOSED, AD_ERROR, AD_SHOWING
    }

    public void endSession(long deltaSession) {
        LibAppsflyerUtils.getInstance().trackSession(currentActivity , deltaSession);
    }


    public long getTimeLiveSession() {
        Game game = GameConfigManager.getInstance().getGameConfig();
        long timeSession = game.getTimeSession() * 60 * 1000;
        if(timeSession == 0){
            timeSession = 10 * 60 * 1000;
            return timeSession;
        }else{
            return timeSession;
        }
    }

    private void checkValidationMode() {
        mGetInfoBeforeAuthenTask = new GetInfoBeforeAuthenTask(
                new GetInfoBeforeAuthenTask.Listener() {

                    @Override
                    public void onSuccess(Game gameConfig) {
                        if (gameConfig == null) {
                            onGetGameInfoRemoteFailed();
                        } else {
                            Log.i(TAG, "Validation Mode: " + gameConfig.getValidationConfig().isShouldShowLogo());
                            if (gameConfig.getValidationConfig().isShouldShowLogo()) {
                                validationImageUrl = gameConfig.getValidationConfig().getLogoUrl();
                                validationText = gameConfig.getValidationConfig().getText();
                                requestOverlayPermission(activity);
                            } else {
                                if (notiFloatButton !=null && notiFloatButton.isShowing()) hideNotiFloatButton();
                            }
                        }
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        t.printStackTrace();
//                        onGetGameInfoRemoteFailed();
                    }
                });
        mGetInfoBeforeAuthenTask.execute();
    }
}